/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.CookieProperties;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetInfo;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetMap;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.SessionProperties;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.web.AdHocContextValve;
import com.sun.enterprise.web.AdHocServletInfo;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.pwc.PwcWebModule;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.enterprise.web.session.SessionCookieConfig;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.FilterMaps;
import org.apache.catalina.loader.WebappClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModule
extends PwcWebModule {
    private static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle _rb = logger.getResourceBundle();
    private static final String ALTERNATE_FROM = "from=";
    private static final String ALTERNATE_DOCBASE = "dir=";
    private SunWebApp iasBean = null;
    private LocaleCharsetMap[] _lcMap = null;
    private boolean hasBeenXmlConfigured = false;
    private WebContainer webContainer;
    private final HashMap<String, AdHocServletInfo> adHocPaths;
    private boolean hasAdHocPaths;
    private final HashMap<String, AdHocServletInfo> adHocSubtrees;
    private boolean hasAdHocSubtrees;
    private StandardPipeline adHocPipeline;
    private String fileEncoding;
    protected Object[] cachedFinds;
    private com.sun.enterprise.config.serverbeans.WebModule bean;
    private WebBundleDescriptor webBundleDescriptor;
    private String compEnvId = null;
    private ServerContext serverContext = null;

    public WebModule(WebContainer webContainer) {
        this.webContainer = webContainer;
        this.adHocPaths = new HashMap();
        this.adHocSubtrees = new HashMap();
        this.adHocPipeline = new StandardPipeline(this);
        this.adHocPipeline.setBasic(new AdHocContextValve(this));
        this.notifyContainerListeners = false;
    }

    public void setIasWebAppConfigBean(SunWebApp iasBean) {
        this.iasBean = iasBean;
    }

    public SunWebApp getIasWebAppConfigBean() {
        return this.iasBean;
    }

    public void setI18nInfo() {
        LocaleCharsetInfo lcinfo;
        if (this.iasBean == null) {
            return;
        }
        if (this.iasBean.isParameterEncoding()) {
            this.formHintField = this.iasBean.getAttributeValue("ParameterEncoding", "FormHintField");
            this.defaultCharset = this.iasBean.getAttributeValue("ParameterEncoding", "DefaultCharset");
        }
        if ((lcinfo = this.iasBean.getLocaleCharsetInfo()) != null) {
            if (lcinfo.getAttributeValue("DefaultLocale") != null) {
                logger.warning("webmodule.default_locale_deprecated");
            }
            if (lcinfo.isParameterEncoding() && !this.iasBean.isParameterEncoding()) {
                this.formHintField = lcinfo.getAttributeValue("ParameterEncoding", "FormHintField");
                this.defaultCharset = lcinfo.getAttributeValue("ParameterEncoding", "DefaultCharset");
            }
            this._lcMap = lcinfo.getLocaleCharsetMap();
        }
    }

    public LocaleCharsetMap[] getLocaleCharsetMap() {
        return this._lcMap;
    }

    @Override
    public boolean hasLocaleToCharsetMapping() {
        LocaleCharsetMap[] locCharsetMap = this.getLocaleCharsetMap();
        return locCharsetMap != null && locCharsetMap.length > 0;
    }

    @Override
    public String mapLocalesToCharset(Enumeration locales) {
        String encoding = null;
        LocaleCharsetMap[] locCharsetMap = this.getLocaleCharsetMap();
        if (locCharsetMap != null && locCharsetMap.length > 0) {
            boolean matchFound = false;
            while (locales.hasMoreElements() && !matchFound) {
                Locale reqLoc = (Locale)locales.nextElement();
                for (int i = 0; i < locCharsetMap.length && !matchFound; ++i) {
                    String language = locCharsetMap[i].getAttributeValue("Locale");
                    if (language == null || language.equals("")) continue;
                    String country = null;
                    int index = language.indexOf(95);
                    if (index != -1) {
                        country = language.substring(index + 1);
                        language = language.substring(0, index);
                    }
                    Locale mapLoc = null;
                    mapLoc = country != null ? new Locale(language, country) : new Locale(language);
                    if (!mapLoc.equals(reqLoc)) continue;
                    encoding = locCharsetMap[i].getAttributeValue("Charset");
                    matchFound = true;
                }
            }
        }
        return encoding;
    }

    public void setXmlConfigured(boolean hasBeenXmlConfigured) {
        this.hasBeenXmlConfigured = hasBeenXmlConfigured;
    }

    public boolean hasBeenXmlConfigured() {
        return this.hasBeenXmlConfigured;
    }

    public void setCachedFindOperation(Object[] cachedFinds) {
        this.cachedFinds = cachedFinds;
    }

    public Object[] getCachedFindOperation() {
        return this.cachedFinds;
    }

    @Override
    public synchronized void start() throws LifecycleException {
        super.start();
        this.configureCatalinaProperties();
        this.started = true;
        this.webContainer.enableMonitoring(this, ((VirtualServer)this.getParent()).getID());
    }

    @Override
    public void stop() throws LifecycleException {
        if (this.started) {
            this.webContainer.disableMonitoring(this, ((VirtualServer)this.getParent()).getID());
            this.started = false;
        }
        if (this.webBundleDescriptor != null && this.webBundleDescriptor.getServiceReferenceDescriptors() != null) {
            for (ServiceReferenceDescriptor serviceReferenceDescriptor : this.webBundleDescriptor.getServiceReferenceDescriptors()) {
            }
        }
        super.stop();
    }

    @Override
    public void setParent(Container container) {
        super.setParent(container);
    }

    @Override
    public boolean hasAdHocPaths() {
        return this.hasAdHocPaths;
    }

    public boolean hasAdHocSubtrees() {
        return this.hasAdHocSubtrees;
    }

    void addAdHocPathAndSubtree(String path, String subtree, AdHocServletInfo servletInfo) {
        if (path == null && subtree == null) {
            return;
        }
        Wrapper adHocWrapper = (Wrapper)this.findChild(servletInfo.getServletName());
        if (adHocWrapper == null) {
            adHocWrapper = this.createAdHocWrapper(servletInfo);
            this.addChild(adHocWrapper);
        }
        if (path != null) {
            this.adHocPaths.put(path, servletInfo);
            this.hasAdHocPaths = true;
        }
        if (subtree != null) {
            this.adHocSubtrees.put(subtree, servletInfo);
            this.hasAdHocSubtrees = true;
        }
    }

    void addAdHocPaths(HashMap newPaths) {
        if (newPaths == null || newPaths.isEmpty()) {
            return;
        }
        for (String adHocPath : newPaths.keySet()) {
            AdHocServletInfo servletInfo = (AdHocServletInfo)newPaths.get(adHocPath);
            Wrapper adHocWrapper = (Wrapper)this.findChild(servletInfo.getServletName());
            if (adHocWrapper == null) {
                adHocWrapper = this.createAdHocWrapper(servletInfo);
                this.addChild(adHocWrapper);
            }
            this.adHocPaths.put(adHocPath, servletInfo);
        }
        this.hasAdHocPaths = true;
    }

    void addAdHocSubtrees(HashMap newSubtrees) {
        if (newSubtrees == null || newSubtrees.isEmpty()) {
            return;
        }
        for (String adHocSubtree : newSubtrees.keySet()) {
            AdHocServletInfo servletInfo = (AdHocServletInfo)newSubtrees.get(adHocSubtree);
            Wrapper adHocWrapper = (Wrapper)this.findChild(servletInfo.getServletName());
            if (adHocWrapper == null) {
                adHocWrapper = this.createAdHocWrapper(servletInfo);
                this.addChild(adHocWrapper);
            }
            this.adHocSubtrees.put(adHocSubtree, servletInfo);
        }
        this.hasAdHocSubtrees = true;
    }

    HashMap getAdHocPaths() {
        return this.adHocPaths;
    }

    HashMap getAdHocSubtrees() {
        return this.adHocSubtrees;
    }

    @Override
    public String getAdHocServletName(String path) {
        if (!this.hasAdHocPaths() && !this.hasAdHocSubtrees()) {
            return null;
        }
        AdHocServletInfo servletInfo = null;
        servletInfo = path == null ? this.adHocPaths.get("") : this.adHocPaths.get(path);
        if (servletInfo == null && path != null && this.hasAdHocSubtrees()) {
            for (String adHocSubtree : this.adHocSubtrees.keySet()) {
                if (!path.startsWith(adHocSubtree)) continue;
                servletInfo = this.adHocSubtrees.get(adHocSubtree);
                break;
            }
        }
        if (servletInfo != null) {
            return servletInfo.getServletName();
        }
        return null;
    }

    void removeAdHocPath(String path) {
        if (path == null) {
            return;
        }
        this.adHocPaths.remove(path);
        if (this.adHocPaths.isEmpty()) {
            this.hasAdHocPaths = false;
        }
    }

    void removeAdHocSubtree(String subtree) {
        if (subtree == null) {
            return;
        }
        this.adHocSubtrees.remove(subtree);
        if (this.adHocSubtrees.isEmpty()) {
            this.hasAdHocSubtrees = false;
        }
    }

    public void addAdHocValve(Valve valve) {
        this.adHocPipeline.addValve(valve);
    }

    public void removeAdHocValve(Valve valve) {
        this.adHocPipeline.removeValve(valve);
    }

    public Pipeline getAdHocPipeline() {
        return this.adHocPipeline;
    }

    public void setFileEncoding(String enc) {
        this.fileEncoding = enc;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setAttribute(String name, Object value) {
        this.context.setAttribute(name, value);
    }

    void addFilterMap(ServletFilterMapping sfm) {
        List urlPatterns;
        List servletNames;
        FilterMaps filterMaps = new FilterMaps();
        filterMaps.setFilterName(sfm.getName());
        Set dispatchers = sfm.getDispatchers();
        if (dispatchers != null) {
            Iterator iter = dispatchers.iterator();
            while (iter.hasNext()) {
                filterMaps.setDispatcher((String)iter.next());
            }
        }
        if ((servletNames = sfm.getServletNames()) != null) {
            Iterator iter = servletNames.iterator();
            while (iter.hasNext()) {
                filterMaps.addServletName((String)iter.next());
            }
        }
        if ((urlPatterns = sfm.getURLPatterns()) != null) {
            Iterator iter = urlPatterns.iterator();
            while (iter.hasNext()) {
                filterMaps.addURLPattern((String)iter.next());
            }
        }
        this.addFilterMaps(filterMaps);
    }

    private Wrapper createAdHocWrapper(AdHocServletInfo servletInfo) {
        StandardWrapper adHocWrapper = new StandardWrapper();
        adHocWrapper.setServletClass(servletInfo.getServletClass().getName());
        adHocWrapper.setName(servletInfo.getServletName());
        Map<String, String> initParams = servletInfo.getServletInitParams();
        if (initParams != null && !initParams.isEmpty()) {
            for (String paramName : initParams.keySet()) {
                adHocWrapper.addInitParameter(paramName, initParams.get(paramName));
            }
        }
        return adHocWrapper;
    }

    protected void configureCatalinaProperties() {
        List props;
        String propName = null;
        String propValue = null;
        if (this.bean != null && (props = this.bean.getProperty()) != null) {
            for (Property prop : props) {
                propName = prop.getName();
                propValue = prop.getValue();
                this.configureCatalinaProperties(propName, propValue);
            }
        }
        if (this.iasBean != null && this.iasBean.sizeWebProperty() > 0) {
            WebProperty[] wprops = this.iasBean.getWebProperty();
            for (int i = 0; i < wprops.length; ++i) {
                propName = wprops[i].getAttributeValue("name");
                propValue = wprops[i].getAttributeValue("value");
                this.configureCatalinaProperties(propName, propValue);
            }
        }
    }

    protected void configureCatalinaProperties(String propName, String propValue) {
        if (propName == null || propValue == null) {
            logger.log(Level.WARNING, "webcontainer.nullWebModuleProperty", this.getName());
            return;
        }
        if (propName.startsWith("valve_")) {
            this.addValve(propValue);
        } else if (propName.startsWith("listener_")) {
            this.addListener(propValue);
        }
    }

    protected void addValve(String valveName) {
        Valve valve = (Valve)this.loadInstance(valveName);
        if (valve == null) {
            return;
        }
        super.addValve(valve);
    }

    protected void addListener(String listenerName) {
        Object listener = this.loadInstance(listenerName);
        if (listener == null) {
            return;
        }
        if (listener instanceof ContainerListener) {
            this.addContainerListener((ContainerListener)listener);
        } else if (listener instanceof LifecycleListener) {
            this.addLifecycleListener((LifecycleListener)listener);
        } else if (listener instanceof InstanceListener) {
            this.addInstanceListener(listenerName);
        } else {
            logger.log(Level.SEVERE, "webcontainer.invalidListener" + listenerName);
        }
    }

    private Object loadInstance(String className) {
        try {
            WebappClassLoader loader = (WebappClassLoader)this.getLoader().getClassLoader();
            Class clazz = loader.loadClass(className);
            return clazz.newInstance();
        }
        catch (Throwable ex) {
            String msg = _rb.getString("webcontainer.unableToLoadExtension");
            msg = MessageFormat.format(msg, className, this.getName());
            logger.log(Level.SEVERE, msg, ex);
            return null;
        }
    }

    public com.sun.enterprise.config.serverbeans.WebModule getBean() {
        return this.bean;
    }

    public void setBean(com.sun.enterprise.config.serverbeans.WebModule bean) {
        this.bean = bean;
    }

    void setWebBundleDescriptor(WebBundleDescriptor wbd) {
        this.webBundleDescriptor = wbd;
    }

    public WebBundleDescriptor getWebBundleDescriptor() {
        return this.webBundleDescriptor;
    }

    public String getComponentId() {
        return this.compEnvId;
    }

    void setComponentId(String compEnvId) {
        this.compEnvId = compEnvId;
    }

    public ServerContext getServerContext() {
        return this.serverContext;
    }

    void setServerContext(ServerContext serverContext) {
        this.serverContext = serverContext;
    }

    void setAlternateDocBases(List<Property> props) {
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            this.parseAlternateDocBase(prop.getName(), prop.getValue());
        }
    }

    void parseAlternateDocBase(String propName, String propValue) {
        if (propName == null || propValue == null) {
            logger.log(Level.WARNING, "Null property name or value");
            return;
        }
        if (!propName.startsWith("alternatedocroot_")) {
            return;
        }
        String urlPattern = null;
        String docBase = null;
        int fromIndex = propValue.indexOf(ALTERNATE_FROM);
        int dirIndex = propValue.indexOf(ALTERNATE_DOCBASE);
        if (fromIndex < 0 || dirIndex < 0) {
            logger.log(Level.WARNING, "webmodule.alternateDocBase.missingPathOrUrlPattern", propValue);
            return;
        }
        if (fromIndex > dirIndex) {
            urlPattern = propValue.substring(fromIndex + ALTERNATE_FROM.length());
            docBase = propValue.substring(dirIndex + ALTERNATE_DOCBASE.length(), fromIndex);
        } else {
            urlPattern = propValue.substring(fromIndex + ALTERNATE_FROM.length(), dirIndex);
            docBase = propValue.substring(dirIndex + ALTERNATE_DOCBASE.length());
        }
        urlPattern = urlPattern.trim();
        if (!this.validateURLPattern(urlPattern)) {
            logger.log(Level.WARNING, "webmodule.alternateDocBase.illegalUrlPattern", urlPattern);
            return;
        }
        docBase = docBase.trim();
        this.addAlternateDocBase(urlPattern, docBase);
    }

    private boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.indexOf(10) >= 0 || urlPattern.indexOf(13) >= 0) {
            logger.log(Level.WARNING, "webmodule.alternateDocBase.crlfInUrlPattern", urlPattern);
            return false;
        }
        if (urlPattern.startsWith("*.")) {
            return urlPattern.indexOf(47) < 0;
        }
        return urlPattern.startsWith("/") && urlPattern.indexOf("*.") < 0;
    }

    protected void configureSessionSettings(WebBundleDescriptor wbd, WebModuleConfig wmInfo) {
        SessionConfig cfg = null;
        SessionManager smBean = null;
        SessionProperties sessionPropsBean = null;
        CookieProperties cookieBean = null;
        if (this.iasBean != null && (cfg = this.iasBean.getSessionConfig()) != null) {
            smBean = cfg.getSessionManager();
            sessionPropsBean = cfg.getSessionProperties();
            cookieBean = cfg.getCookieProperties();
        }
        this.configureSessionManager(smBean, wbd, wmInfo);
        this.configureSession(sessionPropsBean, wbd);
        this.configureCookieProperties(cookieBean);
    }

    private void configureSessionManager(SessionManager smBean, WebBundleDescriptor wbd, WebModuleConfig wmInfo) {
        PersistenceType persistence = PersistenceType.MEMORY;
        String frequency = null;
        String scope = null;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("IN WebContainer>>ConfigureSessionManager before builder factory");
            logger.finest("FINAL_PERSISTENCE-TYPE IS = " + persistence.getType());
            logger.finest("FINAL_PERSISTENCE_FREQUENCY IS = " + frequency);
            logger.finest("FINAL_PERSISTENCE_SCOPE IS = " + scope);
        }
    }

    private void configureSession(SessionProperties spBean, WebBundleDescriptor wbd) {
        boolean timeoutConfigured = false;
        int timeoutSeconds = 1800;
        this.setCookies(this.webContainer.instanceEnableCookies);
        if (spBean != null && spBean.sizeWebProperty() > 0) {
            WebProperty[] props = spBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (name.equalsIgnoreCase("timeoutSeconds")) {
                    try {
                        timeoutSeconds = Integer.parseInt(value);
                        timeoutConfigured = true;
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (name.equalsIgnoreCase("enableCookies")) {
                    this.setCookies(ConfigBeansUtilities.toBoolean((String)value));
                    continue;
                }
                Object[] params = new Object[]{name};
                logger.log(Level.INFO, "webcontainer.notYet", params);
            }
        }
        int webXmlTimeoutSeconds = -1;
        if (wbd != null) {
            webXmlTimeoutSeconds = wbd.getSessionTimeout() * 60;
        }
        if (webXmlTimeoutSeconds != -1 && webXmlTimeoutSeconds != 1800) {
            this.getManager().setMaxInactiveIntervalSeconds(webXmlTimeoutSeconds);
        } else if (timeoutConfigured) {
            this.getManager().setMaxInactiveIntervalSeconds(timeoutSeconds);
        }
    }

    private void configureCookieProperties(CookieProperties bean) {
        WebProperty[] props;
        if (bean != null && (props = bean.getWebProperty()) != null) {
            SessionCookieConfig cookieConfig = new SessionCookieConfig();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (name.equalsIgnoreCase("cookieName")) {
                    cookieConfig.setName(value);
                    continue;
                }
                if (name.equalsIgnoreCase("cookiePath")) {
                    cookieConfig.setPath(value);
                    continue;
                }
                if (name.equalsIgnoreCase("cookieMaxAgeSeconds")) {
                    try {
                        cookieConfig.setMaxAge(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (name.equalsIgnoreCase("cookieDomain")) {
                    cookieConfig.setDomain(value);
                    continue;
                }
                if (name.equalsIgnoreCase("cookieComment")) {
                    cookieConfig.setComment(value);
                    continue;
                }
                Object[] params = new Object[]{name, value};
                logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
            }
            if (props.length > 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WebModule[" + this.getPath() + "]: " + cookieConfig);
                }
                this.setSessionCookieConfig(cookieConfig);
            }
        }
    }
}

