/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.org.apache.commons.beanutils.PropertyUtils;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.Registry;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.Store;
import org.apache.catalina.Valve;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;

public final class StandardServer
implements Lifecycle,
Server,
MBeanRegistration {
    private static Log log = LogFactory.getLog(StandardServer.class);
    private static String[][] exceptions = new String[][]{{"org.apache.catalina.core.StandardEngine", "domain"}, {"org.apache.catalina.core.StandardHost", "domain"}, {"org.apache.catalina.core.StandardContext", "available"}, {"org.apache.catalina.core.StandardContext", "configFile"}, {"org.apache.catalina.core.StandardContext", "configured"}, {"org.apache.catalina.core.StandardContext", "distributable"}, {"org.apache.catalina.core.StandardContext", "domain"}, {"org.apache.catalina.core.StandardContext", "engineName"}, {"org.apache.catalina.core.StandardContext", "name"}, {"org.apache.catalina.core.StandardContext", "override"}, {"org.apache.catalina.core.StandardContext", "publicId"}, {"org.apache.catalina.core.StandardContext", "replaceWelcomeFiles"}, {"org.apache.catalina.core.StandardContext", "sessionTimeout"}, {"org.apache.catalina.core.StandardContext", "startupTime"}, {"org.apache.catalina.core.StandardContext", "tldScanTime"}, {"org.apache.catalina.core.StandardContext", "workDir"}, {"org.apache.catalina.session.StandardManager", "distributable"}, {"org.apache.catalina.session.StandardManager", "entropy"}};
    private static Class[] persistables = new Class[]{String.class, Integer.class, Integer.TYPE, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE};
    private static String[] skippables = new String[]{"org.apache.catalina.authenticator.BasicAuthenticator", "org.apache.catalina.authenticator.DigestAuthenticator", "org.apache.catalina.authenticator.FormAuthenticator", "org.apache.catalina.authenticator.NonLoginAuthenticator", "org.apache.catalina.authenticator.SSLAuthenticator", "org.apache.catalina.core.NamingContextListener", "org.apache.catalina.core.StandardContextValve", "org.apache.catalina.core.StandardDefaultContext", "org.apache.catalina.core.StandardEngineValve", "org.apache.catalina.core.StandardHostValve", "org.apache.catalina.startup.ContextConfig", "org.apache.catalina.startup.EngineConfig", "org.apache.catalina.startup.HostConfig", "org.apache.catalina.valves.CertificatesValve", "org.apache.catalina.valves.ErrorReportValve", "org.apache.catalina.valves.RequestListenerValve"};
    private static String[] standardImplementations = new String[]{"org.apache.catalina.core.StandardServer", "org.apache.catalina.core.StandardService", "org.apache.coyote.tomcat5.CoyoteConnector", "org.apache.catalina.core.StandardEngine", "org.apache.catalina.core.StandardHost", "org.apache.catalina.core.StandardContext"};
    private static String SERVER_LISTENER_CLASS_NAME = "org.apache.catalina.mbeans.ServerLifecycleListener";
    private int debug = 0;
    private javax.naming.Context globalNamingContext = null;
    private NamingResources globalNamingResources = null;
    private static final String info = "org.apache.catalina.core.StandardServer/1.0";
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private NamingContextListener namingContextListener = null;
    private int port = 8005;
    private Random random = null;
    private Service[] services = new Service[0];
    private String shutdown = "SHUTDOWN";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;
    private boolean initialized = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public StandardServer() {
        ServerFactory.setServer(this);
        this.globalNamingResources = new NamingResources();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming() && this.namingContextListener == null) {
            this.namingContextListener = new NamingContextListener();
            this.namingContextListener.setDebug(this.getDebug());
            this.addLifecycleListener(this.namingContextListener);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public javax.naming.Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(javax.naming.Context globalNamingContext) {
        this.globalNamingContext = globalNamingContext;
    }

    public NamingResources getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    public void setGlobalNamingResources(NamingResources globalNamingResources) {
        NamingResources oldGlobalNamingResources = this.globalNamingResources;
        this.globalNamingResources = globalNamingResources;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", oldGlobalNamingResources, this.globalNamingResources);
    }

    public String getInfo() {
        return info;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(String shutdown) {
        this.shutdown = shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(Service service) {
        service.setServer(this);
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            Service[] results = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, results, 0, this.services.length);
            results[this.services.length] = service;
            this.services = results;
            if (this.initialized) {
                try {
                    service.initialize();
                }
                catch (LifecycleException e) {
                    log.error((Object)e);
                }
            }
            if (this.started && service instanceof Lifecycle) {
                try {
                    ((Lifecycle)service).start();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void await() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port, 1, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException e) {
            log.error((Object)("StandardServer.await: create[" + this.port + "]: "), (Throwable)e);
            System.exit(1);
        }
        while (true) {
            int expected;
            Socket socket = null;
            InputStream stream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                stream = socket.getInputStream();
            }
            catch (AccessControlException ace) {
                log.warn((Object)("StandardServer.accept security exception: " + ace.getMessage()), (Throwable)ace);
                continue;
            }
            catch (IOException e) {
                log.error((Object)"StandardServer.await: accept: ", (Throwable)e);
                System.exit(1);
            }
            StringBuffer command = new StringBuffer();
            for (expected = 1024; expected < this.shutdown.length(); expected += this.random.nextInt(1024)) {
                if (this.random != null) continue;
                this.random = new Random(System.currentTimeMillis());
            }
            while (expected > 0) {
                int ch = -1;
                try {
                    ch = stream.read();
                }
                catch (IOException e) {
                    log.warn((Object)"StandardServer.await: read: ", (Throwable)e);
                    ch = -1;
                }
                if (ch < 32) break;
                command.append((char)ch);
                --expected;
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            boolean match = command.toString().equals(this.shutdown);
            if (match) break;
            log.warn((Object)("StandardServer.await: Invalid command '" + command.toString() + "' received"));
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service findService(String name) {
        if (name == null) {
            return null;
        }
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!name.equals(this.services[i].getName())) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.services[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public Service[] findServices() {
        return this.services;
    }

    public ObjectName[] getServiceNames() {
        ObjectName[] onames = new ObjectName[this.services.length];
        for (int i = 0; i < this.services.length; ++i) {
            onames[i] = ((StandardService)this.services[i]).getObjectName();
        }
        return onames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(Service service) {
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            int j = -1;
            for (int i = 0; i < this.services.length; ++i) {
                if (service != this.services[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.services[j] instanceof Lifecycle) {
                try {
                    ((Lifecycle)this.services[j]).stop();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            int k = 0;
            Service[] results = new Service[this.services.length - 1];
            for (int i = 0; i < this.services.length; ++i) {
                if (i == j) continue;
                results[k++] = this.services[i];
            }
            this.services = results;
            this.support.firePropertyChange("service", service, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardServer[");
        sb.append(this.getPort());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void storeConfig() throws Exception {
        File configNew;
        String configFile = "conf/server.xml";
        File configOld = new File(configFile);
        if (!configOld.isAbsolute()) {
            configOld = new File(System.getProperty("catalina.base"), configFile);
        }
        if (!(configNew = new File(configFile + ".new")).isAbsolute()) {
            configNew = new File(System.getProperty("catalina.base"), configFile + ".new");
        }
        String ts = new Timestamp(System.currentTimeMillis()).toString();
        StringBuffer sb = new StringBuffer(".");
        sb.append(ts.substring(0, 10));
        sb.append('.');
        sb.append(ts.substring(11, 13));
        sb.append('-');
        sb.append(ts.substring(14, 16));
        sb.append('-');
        sb.append(ts.substring(17, 19));
        File configSave = new File(configFile + sb.toString());
        if (!configSave.isAbsolute()) {
            configSave = new File(System.getProperty("catalina.base"), configFile + sb.toString());
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configNew), "UTF8"));
        }
        catch (IOException e) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            this.storeServer(writer, 0, this);
        }
        catch (Exception e) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw e;
        }
        writer.flush();
        writer.close();
        if (configOld.renameTo(configSave)) {
            if (configNew.renameTo(configOld)) {
                return;
            }
            configSave.renameTo(configOld);
            throw new IOException("Cannot rename " + configNew.getAbsolutePath() + " to " + configOld.getAbsolutePath());
        }
        throw new IOException("Cannot rename " + configOld.getAbsolutePath() + " to " + configSave.getAbsolutePath());
    }

    public synchronized void storeContext(Context context) throws Exception {
        String configFile = context.getConfigFile();
        if (configFile != null) {
            File config = new File(configFile);
            if (!config.isAbsolute()) {
                config = new File(System.getProperty("catalina.base"), configFile);
            }
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(new FileWriter(config));
            }
            catch (IOException e) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw e;
            }
            writer.print("<Context");
            this.storeAttributes(writer, context);
            writer.println(">");
            writer.println("</Context>");
            writer.flush();
            writer.close();
        }
    }

    private String convertStr(String input) {
        StringBuffer filtered = new StringBuffer(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '<') {
                filtered.append("&lt;");
                continue;
            }
            if (c == '>') {
                filtered.append("&gt;");
                continue;
            }
            if (c == '\'') {
                filtered.append("&apos;");
                continue;
            }
            if (c == '\"') {
                filtered.append("&quot;");
                continue;
            }
            if (c == '&') {
                filtered.append("&amp;");
                continue;
            }
            filtered.append(c);
        }
        return filtered.toString();
    }

    private boolean isDefaultLoader(Loader loader) {
        if (!(loader instanceof WebappLoader)) {
            return false;
        }
        WebappLoader wloader = (WebappLoader)loader;
        return wloader.getDebug() == 0 && !wloader.getDelegate() && wloader.getLoaderClass().equals("org.apache.catalina.loader.WebappClassLoader");
    }

    private boolean isDefaultManager(Manager manager) {
        if (!(manager instanceof StandardManager)) {
            return false;
        }
        StandardManager smanager = (StandardManager)manager;
        return smanager.getDebug() == 0 && smanager.getPathname().equals("SESSIONS.ser") && smanager.getRandomClass().equals("java.security.SecureRandom") && smanager.getMaxActiveSessions() == -1 && smanager.getAlgorithm().equals("MD5");
    }

    private boolean isException(String className, String property) {
        for (int i = 0; i < exceptions.length; ++i) {
            if (!className.equals(exceptions[i][0]) || !property.equals(exceptions[i][1])) continue;
            return true;
        }
        return false;
    }

    private boolean isPersistable(Class clazz) {
        for (int i = 0; i < persistables.length; ++i) {
            if (persistables[i] != clazz) continue;
            return true;
        }
        return false;
    }

    private boolean isSkippable(String className) {
        for (int i = 0; i < skippables.length; ++i) {
            if (!skippables[i].equals(className)) continue;
            return true;
        }
        return false;
    }

    private void storeAttributes(PrintWriter writer, Object bean) throws Exception {
        this.storeAttributes(writer, true, bean);
    }

    private void storeAttributes(PrintWriter writer, boolean include, Object bean) throws Exception {
        PropertyDescriptor[] descriptors;
        String className = bean.getClass().getName();
        if (include) {
            for (int i = 0; i < standardImplementations.length; ++i) {
                if (!className.equals(standardImplementations[i])) continue;
                include = false;
            }
            if (include) {
                writer.print(" className=\"");
                writer.print(bean.getClass().getName());
                writer.print("\"");
            }
        }
        if ((descriptors = PropertyUtils.getPropertyDescriptors((Object)bean)) == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        Object bean2 = bean.getClass().newInstance();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i] instanceof IndexedPropertyDescriptor || !this.isPersistable(descriptors[i].getPropertyType()) || descriptors[i].getReadMethod() == null || descriptors[i].getWriteMethod() == null) continue;
            Object value = PropertyUtils.getSimpleProperty((Object)bean, (String)descriptors[i].getName());
            Object value2 = PropertyUtils.getSimpleProperty(bean2, (String)descriptors[i].getName());
            if (value == null || this.isException(className, descriptors[i].getName()) || value.equals(value2)) continue;
            if (!(value instanceof String)) {
                value = value.toString();
            }
            writer.print(' ');
            writer.print(descriptors[i].getName());
            writer.print("=\"");
            String strValue = this.convertStr((String)value);
            writer.print(strValue);
            writer.print("\"");
        }
    }

    private void storeConnector(PrintWriter writer, int indent, Connector connector) throws Exception {
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Connector");
        this.storeAttributes(writer, connector);
        writer.println(">");
        ServerSocketFactory factory = connector.getFactory();
        if (factory != null) {
            this.storeFactory(writer, indent + 2, factory);
        }
        if (connector instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)connector).findLifecycleListeners();
            if (listeners == null) {
                listeners = new LifecycleListener[]{};
            }
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) continue;
                this.storeListener(writer, indent + 2, listeners[i]);
            }
        }
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.println("</Connector>");
    }

    private void storeContext(PrintWriter writer, int indent, Context context) throws Exception {
        int i;
        DirContext resources;
        Manager manager;
        Logger logger;
        Loader loader;
        String configFile = context.getConfigFile();
        if (configFile != null) {
            File config = new File(configFile);
            if (!config.isAbsolute()) {
                config = new File(System.getProperty("catalina.base"), configFile);
            }
            writer = null;
            try {
                writer = new PrintWriter(new FileWriter(config));
            }
            catch (IOException e) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw e;
            }
            indent = 0;
        }
        for (int i2 = 0; i2 < indent; ++i2) {
            writer.print(' ');
        }
        writer.print("<Context");
        this.storeAttributes(writer, context);
        writer.println(">");
        String[] iListeners = context.findInstanceListeners();
        for (int i3 = 0; i3 < iListeners.length; ++i3) {
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.print("<InstanceListener>");
            writer.print(iListeners[i3]);
            writer.println("</InstanceListener>");
        }
        if (context instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)context).findLifecycleListeners();
            for (int i4 = 0; i4 < listeners.length; ++i4) {
                if (listeners[i4].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) continue;
                this.storeListener(writer, indent + 2, listeners[i4]);
            }
        }
        if ((loader = context.getLoader()) != null) {
            this.storeLoader(writer, indent + 2, loader);
        }
        if ((logger = context.getLogger()) != null) {
            Logger parentLogger = null;
            if (context.getParent() != null) {
                parentLogger = context.getParent().getLogger();
            }
            if (logger != parentLogger) {
                this.storeLogger(writer, indent + 2, logger);
            }
        }
        if ((manager = context.getManager()) != null) {
            this.storeManager(writer, indent + 2, manager);
        }
        ApplicationParameter[] appParams = context.findApplicationParameters();
        for (int i5 = 0; i5 < appParams.length; ++i5) {
            for (int j = 0; j < indent + 2; ++j) {
                writer.print(' ');
            }
            writer.print("<Parameter");
            this.storeAttributes(writer, false, appParams[i5]);
            writer.println("/>");
        }
        Realm realm = context.getRealm();
        if (realm != null) {
            Realm parentRealm = null;
            if (context.getParent() != null) {
                parentRealm = context.getParent().getRealm();
            }
            if (realm != parentRealm) {
                this.storeRealm(writer, indent + 2, realm);
            }
        }
        if ((resources = context.getResources()) != null) {
            this.storeResources(writer, indent + 2, resources);
        }
        if (context instanceof Pipeline) {
            Valve[] valves = ((Pipeline)((Object)context)).getValves();
            for (i = 0; i < valves.length; ++i) {
                this.storeValve(writer, indent + 2, valves[i]);
            }
        }
        String[] wLifecycles = context.findWrapperLifecycles();
        for (i = 0; i < wLifecycles.length; ++i) {
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.print("<WrapperLifecycle>");
            writer.print(wLifecycles[i]);
            writer.println("</WrapperLifecycle>");
        }
        String[] wListeners = context.findWrapperListeners();
        for (int i6 = 0; i6 < wListeners.length; ++i6) {
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.print("<WrapperListener>");
            writer.print(wListeners[i6]);
            writer.println("</WrapperListener>");
        }
        NamingResources nresources = context.getNamingResources();
        if (nresources != null) {
            this.storeNamingResources(writer, indent + 2, nresources);
        }
        for (int i7 = 0; i7 < indent; ++i7) {
            writer.print(' ');
        }
        writer.println("</Context>");
        if (configFile != null) {
            writer.flush();
            writer.close();
        }
    }

    private void storeDefaultContext(PrintWriter writer, int indent, DefaultContext dcontext) throws Exception {
        int i;
        Manager manager;
        Loader loader;
        for (int i2 = 0; i2 < indent; ++i2) {
            writer.print(' ');
        }
        writer.print("<DefaultContext");
        this.storeAttributes(writer, dcontext);
        writer.println(">");
        String[] iListeners = dcontext.findInstanceListeners();
        for (int i3 = 0; i3 < iListeners.length; ++i3) {
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.print("<InstanceListener>");
            writer.print(iListeners[i3]);
            writer.println("</InstanceListener>");
        }
        if (dcontext instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)dcontext).findLifecycleListeners();
            for (int i4 = 0; i4 < listeners.length; ++i4) {
                if (listeners[i4].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) continue;
                this.storeListener(writer, indent + 2, listeners[i4]);
            }
        }
        if ((loader = dcontext.getLoader()) != null) {
            this.storeLoader(writer, indent + 2, loader);
        }
        if ((manager = dcontext.getManager()) != null) {
            this.storeManager(writer, indent + 2, manager);
        }
        ApplicationParameter[] appParams = dcontext.findApplicationParameters();
        for (int i5 = 0; i5 < appParams.length; ++i5) {
            for (int j = 0; j < indent + 2; ++j) {
                writer.print(' ');
            }
            writer.print("<Parameter");
            this.storeAttributes(writer, false, appParams[i5]);
            writer.println("/>");
        }
        DirContext resources = dcontext.getResources();
        if (resources != null) {
            this.storeResources(writer, indent + 2, resources);
        }
        if (dcontext instanceof Pipeline) {
            Valve[] valves = ((Pipeline)((Object)dcontext)).getValves();
            for (i = 0; i < valves.length; ++i) {
                this.storeValve(writer, indent + 2, valves[i]);
            }
        }
        String[] wLifecycles = dcontext.findWrapperLifecycles();
        for (i = 0; i < wLifecycles.length; ++i) {
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.print("<WrapperLifecycle>");
            writer.print(wLifecycles[i]);
            writer.println("</WrapperLifecycle>");
        }
        String[] wListeners = dcontext.findWrapperListeners();
        for (int i6 = 0; i6 < wListeners.length; ++i6) {
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.print("<WrapperListener>");
            writer.print(wListeners[i6]);
            writer.println("</WrapperListener>");
        }
        NamingResources nresources = dcontext.getNamingResources();
        if (nresources != null) {
            this.storeNamingResources(writer, indent + 2, nresources);
        }
        for (int i7 = 0; i7 < indent; ++i7) {
            writer.print(' ');
        }
        writer.println("</DefaultContext>");
    }

    private void storeEngine(PrintWriter writer, int indent, Engine engine) throws Exception {
        Realm realm;
        Logger logger;
        DefaultContext dcontext;
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Engine");
        this.storeAttributes(writer, engine);
        writer.println(">");
        if (engine instanceof StandardEngine && (dcontext = ((StandardEngine)engine).getDefaultContext()) != null) {
            this.storeDefaultContext(writer, indent + 2, dcontext);
        }
        Container[] children = engine.findChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof Context) {
                this.storeContext(writer, indent + 2, (Context)children[i]);
                continue;
            }
            if (children[i] instanceof Engine) {
                this.storeEngine(writer, indent + 2, (Engine)children[i]);
                continue;
            }
            if (!(children[i] instanceof Host)) continue;
            this.storeHost(writer, indent + 2, (Host)children[i]);
        }
        if (engine instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)engine).findLifecycleListeners();
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) continue;
                this.storeListener(writer, indent + 2, listeners[i]);
            }
        }
        if ((logger = engine.getLogger()) != null) {
            Logger parentLogger = null;
            if (engine.getParent() != null) {
                parentLogger = engine.getParent().getLogger();
            }
            if (logger != parentLogger) {
                this.storeLogger(writer, indent + 2, logger);
            }
        }
        if ((realm = engine.getRealm()) != null) {
            Realm parentRealm = null;
            if (engine.getParent() != null) {
                parentRealm = engine.getParent().getRealm();
            }
            if (realm != parentRealm) {
                this.storeRealm(writer, indent + 2, realm);
            }
        }
        if (engine instanceof Pipeline) {
            Valve[] valves = ((Pipeline)((Object)engine)).getValves();
            for (int i = 0; i < valves.length; ++i) {
                this.storeValve(writer, indent + 2, valves[i]);
            }
        }
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.println("</Engine>");
    }

    private void storeFactory(PrintWriter writer, int indent, ServerSocketFactory factory) throws Exception {
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Factory");
        this.storeAttributes(writer, factory);
        writer.println("/>");
    }

    private void storeHost(PrintWriter writer, int indent, Host host) throws Exception {
        Realm realm;
        Logger logger;
        DefaultContext pcontext;
        Container parent;
        DefaultContext dcontext;
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Host");
        this.storeAttributes(writer, host);
        writer.println(">");
        String[] aliases = host.findAliases();
        for (int i = 0; i < aliases.length; ++i) {
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.print("<Alias>");
            writer.print(aliases[i]);
            writer.println("</Alias>");
        }
        Container[] children = host.findChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof Context) {
                this.storeContext(writer, indent + 2, (Context)children[i]);
                continue;
            }
            if (children[i] instanceof Engine) {
                this.storeEngine(writer, indent + 2, (Engine)children[i]);
                continue;
            }
            if (!(children[i] instanceof Host)) continue;
            this.storeHost(writer, indent + 2, (Host)children[i]);
        }
        if (host instanceof StandardHost && (dcontext = ((StandardHost)host).getDefaultContext()) != null && (parent = host.getParent()) != null && parent instanceof StandardEngine && dcontext != (pcontext = ((StandardEngine)parent).getDefaultContext())) {
            this.storeDefaultContext(writer, indent + 2, dcontext);
        }
        if (host instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)host).findLifecycleListeners();
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) continue;
                this.storeListener(writer, indent + 2, listeners[i]);
            }
        }
        if ((logger = host.getLogger()) != null) {
            Logger parentLogger = null;
            if (host.getParent() != null) {
                parentLogger = host.getParent().getLogger();
            }
            if (logger != parentLogger) {
                this.storeLogger(writer, indent + 2, logger);
            }
        }
        if ((realm = host.getRealm()) != null) {
            Realm parentRealm = null;
            if (host.getParent() != null) {
                parentRealm = host.getParent().getRealm();
            }
            if (realm != parentRealm) {
                this.storeRealm(writer, indent + 2, realm);
            }
        }
        if (host instanceof Pipeline) {
            Valve[] valves = ((Pipeline)((Object)host)).getValves();
            for (int i = 0; i < valves.length; ++i) {
                this.storeValve(writer, indent + 2, valves[i]);
            }
        }
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.println("</Host>");
    }

    private void storeListener(PrintWriter writer, int indent, LifecycleListener listener) throws Exception {
        if (this.isSkippable(listener.getClass().getName())) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Listener");
        this.storeAttributes(writer, listener);
        writer.println("/>");
    }

    private void storeLoader(PrintWriter writer, int indent, Loader loader) throws Exception {
        if (this.isDefaultLoader(loader)) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Loader");
        this.storeAttributes(writer, loader);
        writer.println("/>");
    }

    private void storeLogger(PrintWriter writer, int indent, Logger logger) throws Exception {
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Logger");
        this.storeAttributes(writer, logger);
        writer.println("/>");
    }

    private void storeManager(PrintWriter writer, int indent, Manager manager) throws Exception {
        Store store;
        int i;
        if (this.isDefaultManager(manager)) {
            return;
        }
        for (i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Manager");
        this.storeAttributes(writer, manager);
        writer.println(">");
        if (manager instanceof PersistentManager && (store = ((PersistentManager)manager).getStore()) != null) {
            this.storeStore(writer, indent + 2, store);
        }
        for (i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.println("</Manager>");
    }

    private void storeNamingResources(PrintWriter writer, int indent, NamingResources resources) throws Exception {
        ContextLocalEjb[] lejbs;
        ContextEnvironment[] envs;
        ContextEjb[] ejbs = resources.findEjbs();
        if (ejbs.length > 0) {
            for (int i = 0; i < ejbs.length; ++i) {
                for (int j = 0; j < indent; ++j) {
                    writer.print(' ');
                }
                writer.print("<Ejb");
                this.storeAttributes(writer, false, ejbs[i]);
                writer.println("/>");
            }
        }
        if ((envs = resources.findEnvironments()).length > 0) {
            for (int i = 0; i < envs.length; ++i) {
                for (int j = 0; j < indent; ++j) {
                    writer.print(' ');
                }
                writer.print("<Environment");
                this.storeAttributes(writer, false, envs[i]);
                writer.println("/>");
            }
        }
        if ((lejbs = resources.findLocalEjbs()).length > 0) {
            for (int i = 0; i < lejbs.length; ++i) {
                for (int j = 0; j < indent; ++j) {
                    writer.print(' ');
                }
                writer.print("<LocalEjb");
                this.storeAttributes(writer, false, lejbs[i]);
                writer.println("/>");
            }
        }
        ContextResource[] dresources = resources.findResources();
        for (int i = 0; i < dresources.length; ++i) {
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.print("<Resource");
            this.storeAttributes(writer, false, dresources[i]);
            writer.println("/>");
        }
        String[] eresources = resources.findResourceEnvRefs();
        for (int i = 0; i < eresources.length; ++i) {
            int j;
            for (j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.println("<ResourceEnvRef>");
            for (j = 0; j < indent + 2; ++j) {
                writer.print(' ');
            }
            writer.print("<name>");
            writer.print(eresources[i]);
            writer.println("</name>");
            for (j = 0; j < indent + 2; ++j) {
                writer.print(' ');
            }
            writer.print("<type>");
            writer.print(resources.findResourceEnvRef(eresources[i]));
            writer.println("</type>");
            for (j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.println("</ResourceEnvRef>");
        }
        ResourceParams[] params = resources.findResourceParams();
        for (int i = 0; i < params.length; ++i) {
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.print("<ResourceParams");
            this.storeAttributes(writer, false, params[i]);
            writer.println(">");
            Hashtable resourceParams = params[i].getParameters();
            Enumeration nameEnum = resourceParams.keys();
            while (nameEnum.hasMoreElements()) {
                int j;
                String name = (String)nameEnum.nextElement();
                String value = (String)resourceParams.get(name);
                for (j = 0; j < indent + 2; ++j) {
                    writer.print(' ');
                }
                writer.println("<parameter>");
                for (j = 0; j < indent + 4; ++j) {
                    writer.print(' ');
                }
                writer.print("<name>");
                writer.print(name);
                writer.println("</name>");
                for (j = 0; j < indent + 4; ++j) {
                    writer.print(' ');
                }
                writer.print("<value>");
                writer.print(this.convertStr(value));
                writer.println("</value>");
                for (j = 0; j < indent + 2; ++j) {
                    writer.print(' ');
                }
                writer.println("</parameter>");
            }
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.println("</ResourceParams>");
        }
        ContextResourceLink[] resourceLinks = resources.findResourceLinks();
        for (int i = 0; i < resourceLinks.length; ++i) {
            for (int j = 0; j < indent; ++j) {
                writer.print(' ');
            }
            writer.print("<ResourceLink");
            this.storeAttributes(writer, false, resourceLinks[i]);
            writer.println("/>");
        }
    }

    private void storeRealm(PrintWriter writer, int indent, Realm realm) throws Exception {
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Realm");
        this.storeAttributes(writer, realm);
        writer.println("/>");
    }

    private void storeResources(PrintWriter writer, int indent, DirContext resources) throws Exception {
        if (resources instanceof FileDirContext) {
            return;
        }
        if (resources instanceof ProxyDirContext) {
            return;
        }
        if (resources instanceof WARDirContext) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Resources");
        this.storeAttributes(writer, resources);
        writer.println("/>");
    }

    private void storeServer(PrintWriter writer, int indent, Server server) throws Exception {
        int i;
        NamingResources globalNamingResources;
        int i2;
        writer.println("<?xml version='1.0' encoding='utf-8'?>");
        for (int i3 = 0; i3 < indent; ++i3) {
            writer.print(' ');
        }
        writer.print("<Server");
        this.storeAttributes(writer, server);
        writer.println(">");
        if (server instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)server).findLifecycleListeners();
            for (i2 = 0; i2 < listeners.length; ++i2) {
                this.storeListener(writer, indent + 2, listeners[i2]);
            }
        }
        if ((globalNamingResources = server.getGlobalNamingResources()) != null) {
            for (i2 = 0; i2 < indent + 2; ++i2) {
                writer.print(' ');
            }
            writer.println("<GlobalNamingResources>");
            this.storeNamingResources(writer, indent + 4, globalNamingResources);
            for (i2 = 0; i2 < indent + 2; ++i2) {
                writer.print(' ');
            }
            writer.println("</GlobalNamingResources>");
        }
        Service[] services = server.findServices();
        for (i = 0; i < services.length; ++i) {
            this.storeService(writer, indent + 2, services[i]);
        }
        for (i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.println("</Server>");
    }

    private void storeService(PrintWriter writer, int indent, Service service) throws Exception {
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Service");
        this.storeAttributes(writer, service);
        writer.println(">");
        Connector[] connectors = service.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            this.storeConnector(writer, indent + 2, connectors[i]);
        }
        Container container = service.getContainer();
        if (container != null) {
            if (container instanceof Context) {
                this.storeContext(writer, indent + 2, (Context)container);
            } else if (container instanceof Engine) {
                this.storeEngine(writer, indent + 2, (Engine)container);
            } else if (container instanceof Host) {
                this.storeHost(writer, indent + 2, (Host)container);
            }
        }
        if (service instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)service).findLifecycleListeners();
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) continue;
                this.storeListener(writer, indent + 2, listeners[i]);
            }
        }
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.println("</Service>");
    }

    private void storeStore(PrintWriter writer, int indent, Store store) throws Exception {
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Store");
        this.storeAttributes(writer, store);
        writer.println("/>");
    }

    private void storeValve(PrintWriter writer, int indent, Valve valve) throws Exception {
        if (this.isSkippable(valve.getClass().getName())) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            writer.print(' ');
        }
        writer.print("<Valve");
        this.storeAttributes(writer, valve);
        writer.println("/>");
    }

    private boolean isSameAddress(InetAddress server, InetAddress client) {
        int i;
        byte[] clientAddr;
        byte[] serverAddr = server.getAddress();
        if (serverAddr.length != (clientAddr = client.getAddress()).length) {
            return false;
        }
        boolean match = true;
        for (i = 0; i < serverAddr.length; ++i) {
            if (serverAddr[i] == clientAddr[i]) continue;
            match = false;
            break;
        }
        if (match) {
            return true;
        }
        for (i = 0; i < serverAddr.length; ++i) {
            if (serverAddr[i] == clientAddr[serverAddr.length - 1 - i]) continue;
            return false;
        }
        return true;
    }

    private boolean isUseNaming() {
        boolean useNaming = true;
        String useNamingProperty = System.getProperty("catalina.useNaming");
        if (useNamingProperty != null && useNamingProperty.equals("false")) {
            useNaming = false;
        }
        return useNaming;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        if (this.started) {
            log.debug((Object)sm.getString("standardServer.start.started"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!(this.services[i] instanceof Lifecycle)) continue;
                ((Lifecycle)this.services[i]).start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.lifecycle.fireLifecycleEvent("after_start", null);
            return;
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        for (int i = 0; i < this.services.length; ++i) {
            if (!(this.services[i] instanceof Lifecycle)) continue;
            ((Lifecycle)this.services[i]).stop();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    public void init() throws Exception {
        this.initialize();
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            log.info((Object)sm.getString("standardServer.initialize.initialized"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("init", null);
        this.initialized = true;
        if (this.oname == null) {
            try {
                this.oname = new ObjectName("Catalina:type=Server");
                Registry.getRegistry().registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                log.error((Object)"Error registering ", (Throwable)e);
            }
        }
        for (int i = 0; i < this.services.length; ++i) {
            this.services[i].initialize();
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

