/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.digester.RuleSet;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.realm.MemoryRuleSet;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

public class JAASMemoryLoginModule
extends MemoryRealm
implements LoginModule,
Realm {
    private static Log log = LogFactory.getLog(JAASMemoryLoginModule.class);
    protected CallbackHandler callbackHandler = null;
    protected boolean committed = false;
    protected boolean debug = false;
    protected Map options = null;
    protected String pathname = "conf/tomcat-users.xml";
    protected Principal principal = null;
    protected HashMap principals = new HashMap();
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    protected Map sharedState = null;
    protected Subject subject = null;

    public JAASMemoryLoginModule() {
        log.debug((Object)"MEMORY LOGIN MODULE");
    }

    public boolean abort() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (this.committed) {
            this.logout();
        } else {
            this.committed = false;
            this.principal = null;
        }
        log.debug((Object)"Abort");
        return true;
    }

    public boolean commit() throws LoginException {
        log.debug((Object)("commit " + this.principal));
        if (this.principal == null) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        this.committed = true;
        return true;
    }

    public SecurityConstraint[] findSecurityConstraints(HttpRequest request, Context context) {
        ArrayList<SecurityConstraint> results = null;
        SecurityConstraint[] constraints = context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            if (this.debug) {
                this.log("  No applicable constraints defined");
            }
            return null;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        String uri = request.getDecodedRequestURI();
        String contextPath = hreq.getContextPath();
        if (contextPath.length() > 0) {
            uri = uri.substring(contextPath.length());
        }
        uri = RequestUtil.URLDecode(uri);
        String method = hreq.getMethod();
        for (int i = 0; i < constraints.length; ++i) {
            boolean caseSensitiveMapping = ((StandardContext)context).isCaseSensitiveMapping();
            if (this.debug) {
                this.log("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method, caseSensitiveMapping));
            }
            if (!constraints[i].included(uri, method, caseSensitiveMapping)) continue;
            if (results == null) {
                results = new ArrayList<SecurityConstraint>();
            }
            results.add(constraints[i]);
        }
        if (this.debug) {
            this.log("  No applicable constraint located");
        }
        if (results == null) {
            return null;
        }
        SecurityConstraint[] array = new SecurityConstraint[results.size()];
        System.arraycopy(results.toArray(), 0, array, 0, array.length);
        return array;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        log.debug((Object)"Init");
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (options.get("pathname") != null) {
            this.pathname = (String)options.get("pathname");
        }
        this.load();
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler specified");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = ((NameCallback)callbacks[0]).getName();
            password = new String(((PasswordCallback)callbacks[1]).getPassword());
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.toString());
        }
        this.principal = super.authenticate(username, password);
        log.debug((Object)("login " + username + " " + this.principal));
        if (this.principal != null) {
            return true;
        }
        throw new FailedLoginException("Username or password is incorrect");
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.committed = false;
        this.principal = null;
        return true;
    }

    protected void load() {
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (!file.exists() || !file.canRead()) {
            this.log("Cannot load configuration file " + file.getAbsolutePath());
            return;
        }
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addRuleSet((RuleSet)new MemoryRuleSet());
        try {
            digester.push((Object)this);
            digester.parse(file);
        }
        catch (Exception e) {
            this.log("Error processing configuration file " + file.getAbsolutePath(), e);
            return;
        }
    }
}

