/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public abstract class StoreBase
implements Lifecycle,
Store {
    protected String info = "StoreBase/1.0";
    protected String storeName = "StoreBase";
    protected int debug = 0;
    protected boolean started = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected Manager manager;

    public String getInfo() {
        return this.info;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    public Manager getManager() {
        return this.manager;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void writeSession(Session sess, ObjectOutputStream oos) throws IOException {
        if (sess == null) {
            return;
        }
        oos.writeObject(sess);
    }

    public Session readSession(Manager manager, ObjectInputStream ois) throws ClassNotFoundException, IOException {
        StandardSession sess = StandardSession.deserialize(ois, manager);
        sess.setManager(manager);
        return sess;
    }

    public void doProcessExpires() {
        this.processExpires();
    }

    public void removeFromStoreCache(String id) {
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        String[] keys = null;
        if (!this.started) {
            return;
        }
        try {
            keys = this.keys();
        }
        catch (IOException e) {
            this.log(e.toString());
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            try {
                StandardSession session = (StandardSession)this.load(keys[i]);
                if (session == null || session.isValid()) continue;
                if (((PersistentManagerBase)this.manager).isLoaded(keys[i])) {
                    session.recycle();
                } else {
                    session.expire();
                }
                this.remove(session.getIdInternal());
                continue;
            }
            catch (IOException e) {
                this.log(e.toString());
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                this.log(e.toString());
                e.printStackTrace();
            }
        }
    }

    protected void log(String message) {
        Logger logger = null;
        Container container = this.manager.getContainer();
        if (container != null) {
            logger = container.getLogger();
        }
        if (logger != null) {
            logger.log(this.getStoreName() + "[" + container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (container != null) {
                containerName = container.getName();
            }
            System.out.println(this.getStoreName() + "[" + containerName + "]: " + message);
        }
    }

    public Session load(String id, String version) throws ClassNotFoundException, IOException {
        return this.load(id);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString(this.getStoreName() + ".alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString(this.getStoreName() + ".notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }
}

