/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise;

import com.sun.enterprise.security.CachedPermissionImpl;
import com.sun.enterprise.security.PermissionCache;
import com.sun.logging.LogDomains;
import java.net.SocketPermission;
import java.rmi.RMISecurityManager;
import java.util.PropertyPermission;
import java.util.logging.Logger;

public class J2EESecurityManager
extends RMISecurityManager {
    private static Logger _logger = null;
    private CachedPermissionImpl connectPerm;
    private PermissionCache cache;
    private boolean cacheEnabled = false;

    public void checkAccess(ThreadGroup t) {
        super.checkAccess(t);
        this.checkPermission(new RuntimePermission("modifyThreadGroup"));
    }

    public void checkPackageAccess(String pkgname) {
        if (!pkgname.startsWith("sun.")) {
            super.checkPackageAccess(pkgname);
        }
    }

    public void checkExit(int status) {
        super.checkExit(status);
    }

    public void checkConnect(String host, int port) {
        if (this.checkConnectPermission()) {
            return;
        }
        super.checkConnect(host, port);
    }

    public void checkConnect(String host, int port, Object context) {
        if (this.checkConnectPermission()) {
            return;
        }
        super.checkConnect(host, port, context);
    }

    public void checkPropertyAccess(String key) {
        if (this.checkProperty(key)) {
            return;
        }
        super.checkPropertyAccess(key);
    }

    private boolean checkConnectPermission() {
        if (this.cacheEnabled()) {
            return this.connectPerm.checkPermission();
        }
        return false;
    }

    private boolean checkProperty(String key) {
        if (this.cacheEnabled()) {
            return this.cache.checkPermission(new PropertyPermission(key, "read"));
        }
        return false;
    }

    public synchronized boolean cacheEnabled() {
        return this.cacheEnabled;
    }

    public synchronized void enablePermissionCache(PermissionCache c) {
        if (c != null) {
            this.cache = c;
            this.connectPerm = new CachedPermissionImpl(this.cache, new SocketPermission("*", "connect"));
            this.cacheEnabled = true;
        }
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise");
    }
}

