/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.SecurityContainer;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DummyApplication;
import org.glassfish.deployment.common.SimpleDeployer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SecurityDeployer
extends SimpleDeployer<SecurityContainer, DummyApplication> {
    private static Logger _logger = null;
    @Inject
    private ServerContext serverContext;
    @Inject
    private PolicyLoader policyLoader;

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        this.generatePolicy(dc);
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
        this.removePolicy(dc);
    }

    public DummyApplication load(SecurityContainer container, DeploymentContext context) {
        return new DummyApplication();
    }

    protected void generatePolicy(DeploymentContext dc) throws DeploymentException {
        Properties params = dc.getCommandParameters();
        String appName = params.getProperty("name");
        try {
            this.policyLoader.loadPolicy();
            Application app = (Application)dc.getModuleMetaData(Application.class);
            if (app.isVirtual()) {
                WebBundleDescriptor wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
                WebSecurityManagerFactory wsmf = WebSecurityManagerFactory.getInstance();
                wsmf.newWebSecurityManager(wbd, this.serverContext);
                String name = WebSecurityManager.getContextID(wbd);
                SecurityUtil.generatePolicyFile(name);
            }
        }
        catch (IASSecurityException se) {
            String msg = "Error in generating security policy for " + appName;
            throw new DeploymentException(msg, (Throwable)se);
        }
    }

    private void removePolicy(DeploymentContext dc) throws DeploymentException {
        Properties params = dc.getCommandParameters();
        String appName = params.getProperty("name");
        try {
            WebSecurityManagerFactory wsmf = WebSecurityManagerFactory.getInstance();
            String[] name = wsmf.getAndRemoveContextIdForWebAppName(appName);
            if (name != null && name[0] != null) {
                SecurityUtil.removePolicy(name[0]);
                wsmf.removeWebSecurityManager(name[0]);
            }
        }
        catch (IASSecurityException ex) {
            String msg = "Error in removing security policy for " + appName;
            _logger.log(Level.WARNING, msg, ex);
            throw new DeploymentException(msg, (Throwable)ex);
        }
    }

    public MetaData getMetaData() {
        ArrayList<ModuleDefinition> apis = new ArrayList<ModuleDefinition>();
        Module module = this.modulesRegistry.makeModuleFor("javax.javaee:javaee", "5.0");
        if (module != null) {
            apis.add(module.getModuleDefinition());
        }
        if ((module = this.modulesRegistry.makeModuleFor("org.glassfish.core:security", null)) != null) {
            apis.add(module.getModuleDefinition());
        }
        return new MetaData(false, apis.toArray(new ModuleDefinition[apis.size()]), null, new Class[]{Application.class});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initRoleMapperFactory() {
        Object o = null;
        Class<?> c = null;
        try {
            c = Class.forName("com.sun.enterprise.security.acl.RoleMapperFactory");
            if (c != null && (o = c.newInstance()) != null && o instanceof SecurityRoleMapperFactory) {
                SecurityRoleMapperFactoryMgr.registerFactory((SecurityRoleMapperFactory)o);
            }
            if (o != null) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
        SecurityDeployer.initRoleMapperFactory();
    }
}

