/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.realm.jdbc.JDBCRealm;
import java.util.logging.Level;

public class JDBCLoginModule
extends PasswordLoginModule {
    protected void authenticate() throws LoginException {
        if (!(this._currentRealm instanceof JDBCRealm)) {
            String msg = sm.getString("jdbclm.badrealm");
            throw new LoginException(msg);
        }
        JDBCRealm jdbcRealm = (JDBCRealm)this._currentRealm;
        if (this._username == null || this._username.length() == 0) {
            String msg = sm.getString("jdbclm.nulluser");
            throw new LoginException(msg);
        }
        String[] grpList = jdbcRealm.authenticate(this._username, this._password);
        if (grpList == null) {
            String msg = sm.getString("jdbclm.loginfail", (Object)this._username);
            throw new LoginException(msg);
        }
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("JDBC login succeeded for: " + this._username + " groups:" + grpList);
        }
        String[] groupListToForward = new String[grpList.length];
        System.arraycopy(grpList, 0, groupListToForward, 0, grpList.length);
        this.commitAuthentication(this._username, this._password, this._currentRealm, groupListToForward);
    }
}

