/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.http.AsyncFilter;
import com.sun.grizzly.http.AsyncHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.jruby.RailsAdapter;
import com.sun.grizzly.jruby.RubyObjectPool;
import com.sun.grizzly.jruby.RubyRuntimeAsyncFilter;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import java.io.IOException;
import java.util.logging.Level;

public class RailsSelectorThread
extends SelectorThread {
    private static final String NUMBER_OF_RUNTIME = "com.sun.grizzly.rails.numberOfRuntime";
    private String jrubyLib = null;
    private int numberOfRuntime = 5;
    private RubyObjectPool pool = null;
    private String railsRoot = null;

    public String getRailsRoot() {
        return this.railsRoot;
    }

    public void initEndpoint() throws IOException, InstantiationException {
        this.setupSystemProperties();
        this.initializeRubyRuntime();
        RailsSelectorThread.setWebAppRootPath((String)(this.railsRoot + "/public"));
        this.setBufferResponse(false);
        this.asyncExecution = true;
        DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
        this.setAsyncHandler((AsyncHandler)asyncHandler);
        RubyRuntimeAsyncFilter asyncFilter = new RubyRuntimeAsyncFilter();
        asyncFilter.setRubyRuntimeQueue(this.pool.getRubyRuntimeQueue());
        asyncHandler.addAsyncFilter((AsyncFilter)asyncFilter);
        this.adapter = new RailsAdapter(this.pool, asyncFilter);
        this.algorithmClassName = StaticStreamAlgorithm.class.getName();
        super.initEndpoint();
    }

    public void setNumberOfRuntime(int numberOfRuntime) {
        this.numberOfRuntime = numberOfRuntime;
    }

    public void setRailsRoot(String railsRoot) {
        this.railsRoot = railsRoot;
    }

    public synchronized void stopEndpoint() {
        this.pool.stop();
        super.stopEndpoint();
    }

    protected void initializeRubyRuntime() {
        this.pool = new RubyObjectPool();
        this.pool.setNumberOfRuntime(this.numberOfRuntime);
        this.pool.setJrubyLib(this.jrubyLib);
        this.pool.setRailsRoot(this.railsRoot);
        this.pool.setAsyncEnabled(this.asyncExecution);
        try {
            this.pool.start();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, t.getMessage());
        }
    }

    protected void setupSystemProperties() {
        this.jrubyLib = System.getProperty("jruby.lib");
        if (this.jrubyLib == null) {
            this.jrubyLib = System.getenv().get("JRUBY_HOME") + "/lib";
            System.setProperty("jruby.lib", this.jrubyLib);
        }
        if (System.getProperty(NUMBER_OF_RUNTIME) != null) {
            try {
                this.numberOfRuntime = Integer.parseInt(System.getProperty(NUMBER_OF_RUNTIME));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "Invalid number of Runtime");
            }
        }
    }
}

