/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.async;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueue;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueWriter;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.async.AsyncWriteQueueRecord;
import com.sun.grizzly.util.ByteBufferFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class TCPAsyncQueueWriter
implements AsyncQueueWriter {
    private SelectorHandler selectorHandler;
    private AsyncQueue<SelectableChannel, AsyncWriteQueueRecord> writeQueue;
    private ConcurrentLinkedQueue<AsyncWriteQueueRecord> recordQueue;

    public TCPAsyncQueueWriter(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
        this.writeQueue = new AsyncQueue();
        this.recordQueue = new ConcurrentLinkedQueue();
    }

    public void write(SelectionKey key, ByteBuffer buffer) throws IOException {
        this.write(key, buffer, null);
    }

    public void write(SelectionKey key, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        this.write(key, buffer, callbackHandler, null);
    }

    public void write(SelectionKey key, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        this.write(key, buffer, callbackHandler, writePreProcessor, false);
    }

    public void write(SelectionKey key, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, boolean isCloneByteBuffer) throws IOException {
        if (key == null) {
            throw new IOException("SelectionKey is null! Probably key was cancelled or connection was closed?");
        }
        SelectableChannel channel = key.channel();
        AsyncQueue.AsyncQueueEntry channelEntry = this.writeQueue.obtainAsyncQueueEntry(channel);
        ConcurrentLinkedQueue<AsyncWriteQueueRecord> queue = channelEntry.queue;
        AtomicReference currentElement = channelEntry.currentElement;
        ReentrantLock lock = channelEntry.queuedActionLock;
        try {
            block22: {
                try {
                    AsyncWriteQueueRecord record = null;
                    if (currentElement.get() == null && lock.tryLock()) {
                        record = this.obtainRecord();
                        if (currentElement.compareAndSet(null, record)) {
                            this.doWrite((WritableByteChannel)((Object)channel), buffer, writePreProcessor);
                        } else {
                            lock.unlock();
                        }
                    }
                    if (buffer.hasRemaining() || lock.isHeldByCurrentThread() && writePreProcessor != null && writePreProcessor.getInternalByteBuffer().hasRemaining()) {
                        if (record == null) {
                            record = this.obtainRecord();
                        }
                        if (isCloneByteBuffer) {
                            int size = buffer.remaining();
                            ByteBuffer newBuffer = ByteBufferFactory.allocateView(size, buffer.isDirect());
                            newBuffer.put(buffer);
                            newBuffer.position(0);
                            buffer = newBuffer;
                        }
                        record.set(buffer, callbackHandler, writePreProcessor, null);
                        boolean isRegisterForWriting = false;
                        if (currentElement.get() != record) {
                            queue.offer(record);
                            if (!lock.isLocked()) {
                                isRegisterForWriting = true;
                            }
                        } else {
                            isRegisterForWriting = true;
                            lock.unlock();
                        }
                        if (isRegisterForWriting) {
                            this.registerForWriting(key);
                        }
                        break block22;
                    }
                    if (callbackHandler != null) {
                        callbackHandler.onWriteCompleted(key, buffer);
                    }
                    if (lock.isHeldByCurrentThread()) {
                        AsyncWriteQueueRecord nextRecord = (AsyncWriteQueueRecord)queue.poll();
                        if (nextRecord != null) {
                            currentElement.set(nextRecord);
                            lock.unlock();
                            this.registerForWriting(key);
                        } else {
                            currentElement.set(null);
                            lock.unlock();
                            if (queue.peek() != null) {
                                this.registerForWriting(key);
                            }
                        }
                    }
                    if (record == null) break block22;
                    this.recordQueue.offer(record);
                }
                catch (IOException e) {
                    this.onClose(channel);
                    throw e;
                }
            }
            Object var15_16 = null;
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
            throw throwable;
        }
    }

    public boolean hasReadyAsyncWriteData(SelectionKey key) {
        AsyncQueue.AsyncQueueEntry channelEntry = this.writeQueue.getAsyncQueueEntry(key.channel());
        return channelEntry != null && (channelEntry.currentElement.get() != null || channelEntry.queue != null && !channelEntry.queue.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onWrite(SelectionKey key) throws IOException {
        SelectableChannel channel = key.channel();
        AsyncQueue.AsyncQueueEntry channelEntry = this.writeQueue.obtainAsyncQueueEntry(channel);
        ConcurrentLinkedQueue<AsyncWriteQueueRecord> queue = channelEntry.queue;
        AtomicReference currentElement = channelEntry.currentElement;
        ReentrantLock lock = channelEntry.queuedActionLock;
        if (currentElement.get() == null) {
            AsyncWriteQueueRecord nextRecord = (AsyncWriteQueueRecord)queue.peek();
            if (nextRecord == null || !lock.tryLock()) return;
            if (currentElement.compareAndSet(null, nextRecord)) {
                queue.remove();
            }
        } else if (!lock.tryLock()) {
            return;
        }
        try {
            while (currentElement.get() != null) {
                AsyncWriteQueueRecord queueRecord = (AsyncWriteQueueRecord)currentElement.get();
                ByteBuffer byteBuffer = queueRecord.byteBuffer;
                AsyncQueueDataProcessor writePreProcessor = queueRecord.writePreProcessor;
                try {
                    this.doWrite((WritableByteChannel)((Object)channel), byteBuffer, writePreProcessor);
                }
                catch (IOException e) {
                    if (queueRecord.callbackHandler != null) {
                        queueRecord.callbackHandler.onIOException(e, key, byteBuffer, queue);
                    } else {
                        Controller.logger().log(Level.SEVERE, "Exception occured when executing asynchronous queue writing", e);
                    }
                    this.onClose(channel);
                }
                if (!(byteBuffer.hasRemaining() || writePreProcessor != null && writePreProcessor.getInternalByteBuffer().hasRemaining())) {
                    if (queueRecord.callbackHandler != null) {
                        queueRecord.callbackHandler.onWriteCompleted(key, byteBuffer);
                    }
                    currentElement.set(queue.poll());
                    this.recordQueue.offer(queueRecord);
                    if (currentElement.get() != null) continue;
                    lock.unlock();
                    AsyncWriteQueueRecord nextRecord = queue.peek();
                    if (nextRecord == null || !lock.tryLock()) break;
                    if (!currentElement.compareAndSet(null, nextRecord)) continue;
                    queue.remove();
                    continue;
                }
                lock.unlock();
                this.registerForWriting(key);
                break;
            }
            Object var12_12 = null;
            if (!lock.isHeldByCurrentThread()) return;
            channelEntry.queuedActionLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (!lock.isHeldByCurrentThread()) throw throwable;
            channelEntry.queuedActionLock.unlock();
            throw throwable;
        }
    }

    public void write(SelectionKey key, SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
        throw new UnsupportedOperationException("Not supported for TCP transport.");
    }

    public void write(SelectionKey key, SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        throw new UnsupportedOperationException("Not supported for TCP transport.");
    }

    public void write(SelectionKey key, SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        throw new UnsupportedOperationException("Not supported for TCP transport.");
    }

    public void write(SelectionKey key, SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, boolean isCloneByteBuffer) throws IOException {
        throw new UnsupportedOperationException("Not supported for TCP transport.");
    }

    public void onClose(SelectableChannel channel) {
        this.writeQueue.removeEntry(channel);
    }

    public void close() {
        this.writeQueue.clear();
    }

    private void doWrite(WritableByteChannel channel, ByteBuffer byteBuffer, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        if (writePreProcessor != null) {
            ByteBuffer resultByteBuffer = null;
            do {
                if (byteBuffer.hasRemaining()) {
                    writePreProcessor.process(byteBuffer);
                }
                resultByteBuffer = writePreProcessor.getInternalByteBuffer();
                this.doWrite(channel, resultByteBuffer);
            } while (byteBuffer.hasRemaining() && !resultByteBuffer.hasRemaining());
        } else {
            this.doWrite(channel, byteBuffer);
        }
    }

    private void doWrite(WritableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        int lastWriteBytes = 0;
        while ((lastWriteBytes = channel.write(byteBuffer)) > 0 && byteBuffer.hasRemaining()) {
        }
    }

    private void registerForWriting(SelectionKey key) {
        this.selectorHandler.register(key, 4);
    }

    private AsyncWriteQueueRecord obtainRecord() {
        AsyncWriteQueueRecord record = this.recordQueue.poll();
        if (record == null) {
            record = new AsyncWriteQueueRecord();
        }
        return record;
    }
}

