/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.Controller;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerThreadImpl
extends Thread
implements WorkerThread {
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    protected Runnable target;
    protected ByteBuffer byteBuffer;
    protected Pipeline<Callable> pipeline;
    protected volatile boolean execute = true;
    protected static final ThreadGroup threadGroup = new ThreadGroup("Grizzly");
    protected ByteBuffer inputBB;
    protected ByteBuffer outputBB;
    protected SSLEngine sslEngine;
    private ThreadAttachment threadAttachment;
    private ByteBufferFactory.ByteBufferType byteBufferType = ByteBufferFactory.ByteBufferType.HEAP_VIEW;
    private int initialByteBufferSize;

    public WorkerThreadImpl(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, 8192);
    }

    public WorkerThreadImpl(ThreadGroup threadGroup, Runnable runnable, int initialByteBufferSize) {
        super(threadGroup, runnable);
        this.setDaemon(true);
        this.target = runnable;
        this.initialByteBufferSize = initialByteBufferSize;
    }

    public WorkerThreadImpl(Pipeline<Callable> pipeline, String name) {
        this(pipeline, name, 8192);
    }

    public WorkerThreadImpl(Pipeline<Callable> pipeline, String name, int initialByteBufferSize) {
        super(threadGroup, name);
        this.pipeline = pipeline;
        this.setDaemon(true);
        this.initialByteBufferSize = initialByteBufferSize;
    }

    @Override
    public void run() {
        if (this.byteBuffer == null) {
            this.byteBuffer = ByteBufferFactory.allocate(this.byteBufferType, this.initialByteBufferSize);
        }
        if (this.target != null) {
            this.target.run();
            return;
        }
        while (this.execute) {
            try {
                Callable t = this.pipeline.waitForIoTask();
                if (t == null) continue;
                t.call();
                t = null;
            }
            catch (Throwable t) {
                if (this.byteBuffer != null) {
                    this.byteBuffer.clear();
                }
                if (this.inputBB != null) {
                    this.inputBB.clear();
                }
                if (this.outputBB != null) {
                    this.outputBB.clear();
                }
                if (this.execute) {
                    Controller.logger().log(Level.SEVERE, "WorkerThreadImpl unexpected exception: ", t);
                    continue;
                }
                Controller.logger().log(Level.FINE, "WorkerThreadImpl unexpected exception, when WorderThread supposed to be closed: ", t);
            }
        }
    }

    public void terminate() {
        this.execute = false;
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public ByteBuffer getInputBB() {
        return this.inputBB;
    }

    @Override
    public void setInputBB(ByteBuffer inputBB) {
        this.inputBB = inputBB;
    }

    @Override
    public ByteBuffer getOutputBB() {
        return this.outputBB;
    }

    @Override
    public void setOutputBB(ByteBuffer outputBB) {
        this.outputBB = outputBB;
    }

    @Override
    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    @Override
    public void setSSLEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadAttachment detach(boolean copyState) {
        ThreadAttachment threadAttachment;
        block4: {
            ThreadAttachment newTA2;
            if (this.threadAttachment == null) {
                this.threadAttachment = new ThreadAttachment();
            }
            try {
                this.threadAttachment.setByteBuffer(this.byteBuffer);
                this.threadAttachment.setSSLEngine(this.sslEngine);
                this.threadAttachment.setInputBB(this.inputBB);
                this.threadAttachment.setOutputBB(this.outputBB);
                threadAttachment = this.threadAttachment;
                Object var4_3 = null;
                if (!copyState) break block4;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (copyState) {
                    ThreadAttachment newTA2;
                    this.byteBuffer = ByteBufferFactory.allocate(this.byteBufferType, this.initialByteBufferSize);
                    this.threadAttachment = newTA2 = new ThreadAttachment();
                }
                this.threadAttachment.setThreadId(this.getName() + "-" + this.getId());
                throw throwable;
            }
            this.byteBuffer = ByteBufferFactory.allocate(this.byteBufferType, this.initialByteBufferSize);
            this.threadAttachment = newTA2 = new ThreadAttachment();
        }
        this.threadAttachment.setThreadId(this.getName() + "-" + this.getId());
        return threadAttachment;
    }

    @Override
    public void attach(ThreadAttachment threadAttachment) {
        this.byteBuffer = threadAttachment.getByteBuffer();
        this.sslEngine = threadAttachment.getSSLEngine();
        this.inputBB = threadAttachment.getInputBB();
        this.outputBB = threadAttachment.getOutputBB();
        this.threadAttachment = threadAttachment;
        threadAttachment.setThreadId(this.getName() + "-" + this.getId());
    }

    public ByteBufferFactory.ByteBufferType getByteBufferType() {
        return this.byteBufferType;
    }

    public void setByteBufferType(ByteBufferFactory.ByteBufferType byteBufferType) {
        this.byteBufferType = byteBufferType;
    }
}

