/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.loader;

import com.sun.appserv.management.util.jmx.JMXUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.loader.AMXConfigRegistrar;
import org.glassfish.admin.amx.support.LoadAMX;

public final class StartAMX {
    private static StartAMX INSTANCE;
    private volatile ObjectName mAMXLoaderObjectName;
    private final AMXConfigRegistrar mConfigRegistrar;
    private final MBeanServer mMBeanServer;
    private volatile JMXConnectorServer mJMXMP = null;
    private volatile JMXServiceURL mJMXMPServiceURL = null;
    private volatile ObjectName mJMXMPObjectName = null;
    public static final int JMXMP_PORT = 8888;

    protected static void debug(String s) {
        System.out.println(s);
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.mJMXMPServiceURL;
    }

    private StartAMX(MBeanServer mbs, AMXConfigRegistrar registrar) {
        this.mMBeanServer = mbs;
        this.mConfigRegistrar = registrar;
    }

    public static boolean isStarted() {
        return StartAMX.getInstance() != null;
    }

    private synchronized void start() {
        this.mAMXLoaderObjectName = LoadAMX.loadAMX(this.mMBeanServer);
        this.mConfigRegistrar.getAMXConfigLoader().start(this.mMBeanServer);
        try {
            this.startJMXMPConnectorServer(this.mMBeanServer, 8888);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized StartAMX getInstance() {
        return INSTANCE;
    }

    public static synchronized void startAMX(MBeanServer mbs, AMXConfigRegistrar registrar) {
        if (INSTANCE == null) {
            INSTANCE = new StartAMX(mbs, registrar);
            INSTANCE.start();
        }
    }

    private synchronized JMXConnectorServer startJMXMPConnectorServer(MBeanServer mbeanServer, int port) throws MalformedURLException, IOException {
        if (this.mJMXMP == null) {
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
            env.put("jmx.remote.protocol.provider.class.loader", this.getClass().getClassLoader());
            JMXServiceURL url = this.mJMXMPServiceURL = new JMXServiceURL("service:jmx:jmxmp://localhost:" + port);
            this.mJMXMP = JMXConnectorServerFactory.newJMXConnectorServer(this.mJMXMPServiceURL, env, null);
            ObjectName objectName = JMXUtil.newObjectName((String)"jmxremote:type=jmx-connector,name=jmxmp");
            try {
                this.mJMXMPObjectName = mbeanServer.registerMBean(this.mJMXMP, objectName).getObjectName();
                this.mJMXMP.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.mJMXMP;
    }
}

