/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.util.misc.Output;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanParameterInfo;
import org.glassfish.admin.amx.mbean.Delegate;
import org.glassfish.admin.amx.mbean.DelegateOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegateBase
implements Delegate {
    private volatile DelegateOwner mOwner;
    private volatile Output mDebug;
    private final String mID;

    protected void unimplementedOperation(String operation) {
        this.debug("unimplemented operation: " + operation);
        throw new UnsupportedOperationException(operation);
    }

    public DelegateBase(String id) {
        this.mID = id;
        this.mOwner = null;
        this.mDebug = null;
    }

    public void setDebugOutput(Output debugOutput) {
        this.mDebug = debugOutput;
    }

    protected final void debug(Object o) {
        if (this.mDebug != null) {
            this.mDebug.println(o);
        }
    }

    @Override
    public final String getID() {
        return this.mID;
    }

    @Override
    public void setOwner(DelegateOwner owner) {
        this.mOwner = owner;
    }

    public DelegateOwner getOwner() {
        return this.mOwner;
    }

    @Override
    public AttributeList getAttributes(String[] attrNames) {
        AttributeList attrs = new AttributeList();
        for (int i = 0; i < attrNames.length; ++i) {
            try {
                String attrName = attrNames[i];
                Attribute attr = new Attribute(attrName, this.getAttribute(attrName));
                attrs.add(attr);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return attrs;
    }

    @Override
    public abstract AttributeList setAttributes(AttributeList var1, Map<String, Object> var2);

    private boolean typesMatch(String[] types, MBeanParameterInfo[] paramInfos) {
        int numParams;
        boolean matches = false;
        int numTypes = types == null ? 0 : types.length;
        int n = numParams = paramInfos == null ? 0 : paramInfos.length;
        if (numTypes == numParams) {
            matches = true;
            for (int i = 0; i < numTypes; ++i) {
                if (types[i].equals(paramInfos[i].getType())) continue;
                matches = false;
                break;
            }
        }
        return matches;
    }

    @Override
    public boolean supportsAttribute(String attrName) {
        return true;
    }

    protected String _getDefaultValue(String name) throws AttributeNotFoundException {
        return "!!! NO DEFAULT VALUE FOR: \"" + name + "\" !!!" + ", " + this.getClass().getName();
    }

    @Override
    public final String getDefaultValue(String name) throws AttributeNotFoundException {
        if (!this.supportsAttribute(name)) {
            throw new AttributeNotFoundException(name);
        }
        return this._getDefaultValue(name);
    }

    @Override
    public boolean supportsOperation(String operationName, Object[] args, String[] types) {
        return false;
    }
}

