/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import org.glassfish.admin.amx.mbean.DelegateBase;
import org.glassfish.admin.amx.mbean.NameMapping;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegateToConfigBeanDelegate
extends DelegateBase {
    private final ConfigBean mConfigBean;
    private static final String[] SINGLE_STRING_SIG = new String[]{String.class.getName()};

    private static void debug(String s) {
        System.out.println(s);
    }

    public DelegateToConfigBeanDelegate(ConfigBean configBean) {
        super("DelegateToConfigBeanDelegate." + configBean.toString());
        this.mConfigBean = configBean;
    }

    @Override
    public boolean supportsAttribute(String attrName) {
        String xmlName = this.getXMLName(attrName);
        return xmlName != null;
    }

    private final String getXMLName(String amxName) {
        String xmlName = NameMapping.getXMLName(amxName);
        if (xmlName == null) {
            Set xmlNames = this.mConfigBean.getAttributeNames();
            xmlName = NameMapping.matchAMXName(amxName, xmlNames);
        }
        return xmlName;
    }

    @Override
    public final Object getAttribute(String attrName) throws AttributeNotFoundException {
        String xmlName = this.getXMLName(attrName);
        return this.mConfigBean.rawAttribute(xmlName);
    }

    @Override
    protected final String _getDefaultValue(String name) throws AttributeNotFoundException {
        throw new AttributeNotFoundException(name);
    }

    private Map<String, PropertyChangeEvent> makePropertyChangeEventMap(List<PropertyChangeEvent> changeEvents) {
        HashMap<String, PropertyChangeEvent> m = new HashMap<String, PropertyChangeEvent>();
        for (PropertyChangeEvent changeEvent : changeEvents) {
            if (changeEvent.getPropertyName() == null) {
                throw new IllegalArgumentException("PropertyChangeEvent property names must be specified");
            }
            m.put(changeEvent.getPropertyName(), changeEvent);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList setAttributes(AttributeList attrsIn, Map<String, Object> oldValues) {
        oldValues.clear();
        Map amxAttrs = JMXUtil.attributeListToStringMap((AttributeList)attrsIn);
        HashMap xmlAttrs = new HashMap();
        for (String amxAttrName : amxAttrs.keySet()) {
            String xmlName = this.getXMLName(amxAttrName);
            if (xmlName == null) continue;
            xmlAttrs.put(xmlName, amxAttrs.get(amxAttrName));
        }
        HashMap changes = new HashMap();
        changes.put(this.mConfigBean, xmlAttrs);
        DelegateToConfigBeanDelegate.debug("DelegateToConfigBeanDelegate.setAttributes(): " + attrsIn.size() + " attributes: {" + CollectionUtil.toString(amxAttrs.keySet()) + "} mapped to xml names {" + CollectionUtil.toString(xmlAttrs.keySet()) + "}");
        MyTransactionListener myListener = new MyTransactionListener();
        Transactions.get().addTransactionsListener((TransactionListener)myListener);
        AttributeList successfulAttrs = new AttributeList();
        try {
            ConfigSupport.apply(changes);
            successfulAttrs.addAll(attrsIn);
        }
        catch (TransactionFailure tf) {
            DelegateToConfigBeanDelegate.debug(ExceptionUtil.toString((Throwable)tf));
        }
        finally {
            Transactions.get().waitForDrain();
            Transactions.get().removeTransactionsListener((TransactionListener)myListener);
        }
        if (successfulAttrs.size() != 0) {
            List<PropertyChangeEvent> changeEvents = myListener.getChangeEvents();
            if (successfulAttrs.size() != changeEvents.size()) {
                throw new IllegalStateException("List<PropertyChangeEvent> does not match the number of Attributes");
            }
            Map<String, PropertyChangeEvent> eventsMap = this.makePropertyChangeEventMap(changeEvents);
            Map attrsS = JMXUtil.attributeListToStringMap((AttributeList)successfulAttrs);
            for (String amxAttrName : attrsS.keySet()) {
                PropertyChangeEvent changeEvent = eventsMap.get(this.getXMLName(amxAttrName));
                oldValues.put(amxAttrName, changeEvent.getOldValue());
            }
        }
        return successfulAttrs;
    }

    public MBeanInfo getMBeanInfo() {
        return null;
    }

    private void delegateFailed(Throwable t) {
        if (this.getOwner() != null) {
            this.getOwner().delegateFailed(t);
        }
    }

    @Override
    public final Object invoke(String operationName, Object[] args, String[] types) {
        throw new RuntimeException("invoke() not yet implemented");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MyTransactionListener
    implements TransactionListener {
        private static final List<PropertyChangeEvent> EMPTY = Collections.emptyList();
        private volatile List<PropertyChangeEvent> mChangeEvents = EMPTY;

        MyTransactionListener() {
        }

        public void transactionCommited(List<PropertyChangeEvent> changes) {
            if (this.mChangeEvents != EMPTY) {
                throw new IllegalStateException("can commit only once!");
            }
            this.mChangeEvents = changes;
        }

        List<PropertyChangeEvent> getChangeEvents() {
            return this.mChangeEvents;
        }
    }
}

