/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.support;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.mbean.SystemInfoImpl;

final class SystemInfoIniter {
    private final SystemInfoImpl mSystemInfo;
    private final MBeanServer mServer;

    SystemInfoIniter(MBeanServer mbeanServer, SystemInfoImpl systemInfo) {
        this.mServer = mbeanServer;
        this.mSystemInfo = systemInfo;
    }

    public void init() {
        boolean supportsClusters = this.supportsClusters();
        this.mSystemInfo.addFeature("SupportsClusters", supportsClusters);
        this.mSystemInfo.addFeature("SupportsMultipleServers", supportsClusters);
        this.mSystemInfo.addFeature("RunningInDomainAdminServer", this.isRunningInDomainAdminServer());
    }

    private final boolean supportsClusters() {
        ObjectName serversObjectName = this.getOldServersMBeanObjectName();
        boolean supportsClusters = false;
        if (serversObjectName != null) {
            try {
                MBeanInfo info = this.mServer.getMBeanInfo(serversObjectName);
                String operationName = "listUnclusteredServerInstancesAsString";
                Set operations = JMXUtil.findInfoByName((MBeanFeatureInfo[])info.getOperations(), (String)"listUnclusteredServerInstancesAsString");
                supportsClusters = operations.size() != 0;
            }
            catch (JMException e) {
                throw new RuntimeException("problem with 'servers' MBean: " + serversObjectName, e);
            }
        } else {
            supportsClusters = true;
        }
        return supportsClusters;
    }

    private ObjectName getOldServersMBeanObjectName() {
        ObjectName pattern = Util.newObjectName((String)"com.sun.appserv", (String)"category=config,type=servers");
        Set serversSet = JMXUtil.queryNames((MBeanServer)this.mServer, (ObjectName)pattern, null);
        ObjectName objectName = serversSet.size() == 0 ? null : (ObjectName)GSetUtil.getSingleton((Set)serversSet);
        return objectName;
    }

    private boolean isRunningInDomainAdminServer() {
        return this.getOldServersMBeanObjectName() != null;
    }
}

