/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class ObjectNames {
    private final String mJMXDomain;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String MISSING_PARENT_NAME = "null";

    private ObjectNames(String jmxDomain) {
        this.mJMXDomain = jmxDomain;
    }

    private void debug(Object o) {
        AMXDebug.getInstance().getOutput("org.glassfish.admin.amx.support.ObjectNames").println(o);
    }

    public static ObjectNames getInstance(String jmxDomain) {
        return new ObjectNames(jmxDomain);
    }

    public static ObjectNames getInstance() {
        return new ObjectNames("amx");
    }

    public String getJMXDomain() {
        return this.mJMXDomain;
    }

    public static String getJ2EEType(Class theInterface) {
        return (String)ClassUtil.getFieldValue((Class)theInterface, (String)"J2EE_TYPE");
    }

    private ObjectName newObjectName(String props) {
        return Util.newObjectName((String)this.getJMXDomain(), (String)props);
    }

    public static String makeWild(String props) {
        return Util.concatenateProps((String)props, (String)",*");
    }

    public ObjectName buildContaineeObjectName(ObjectName parentObjectName, String parentFullType, String childJ2EEType, String childName, boolean isSubType) {
        String domain = parentObjectName.getDomain();
        String props = "";
        if (isSubType) {
            String parentProp = Util.getSelfProp((ObjectName)parentObjectName);
            Object[] parentFullTypes = Util.getTypeArray((String)parentFullType);
            Set ancestorKeys = GSetUtil.newSet((Object[])parentFullTypes, (int)0, (int)(parentFullTypes.length - 1));
            String ancestorProps = JMXUtil.getProps((ObjectName)parentObjectName, (Set)ancestorKeys, (boolean)true);
            props = Util.concatenateProps((String)parentProp, (String)ancestorProps);
        }
        String requiredProps = Util.makeRequiredProps((String)childJ2EEType, (String)childName);
        String allProps = Util.concatenateProps((String)requiredProps, (String)props);
        return Util.newObjectName((String)domain, (String)allProps);
    }

    public ObjectName buildContaineeObjectName(ObjectName parentObjectName, String parentFullType, String childJ2EEType) {
        String name = ObjectNames.getSingletonName(childJ2EEType);
        return this.buildContaineeObjectName(parentObjectName, parentFullType, childJ2EEType, name, false);
    }

    public ObjectName getDomainRootObjectName() {
        return this.newObjectName(Util.makeRequiredProps((String)"X-DomainRoot", (String)this.getJMXDomain()));
    }

    public ObjectName getSingletonObjectName(String j2eeType) {
        String props = Util.makeRequiredProps((String)j2eeType, (String)ObjectNames.getSingletonName(j2eeType));
        return this.newObjectName(props);
    }

    public static String getSingletonName(String j2eeType) {
        assert (!"na".equals(MISSING_PARENT_NAME));
        return "na";
    }

    private static String getFullType(MBeanServer server, ObjectName objectName) {
        try {
            String fullType = (String)server.getAttribute(objectName, "FullType");
            return fullType;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String toString(Object o) {
        return SmartStringifier.toString((Object)o);
    }
}

