/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiMap<K, V> {
    private final Map<K, List<V>> store;
    private static final MultiMap EMPTY = new MultiMap(Collections.emptyMap());

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        String newline = System.getProperty("line.separator");
        builder.append("{");
        for (K key : this.store.keySet()) {
            builder.append(key + ": {");
            for (V value : this.store.get(key)) {
                builder.append(value.toString() + ",");
            }
            builder.append("}" + newline);
        }
        builder.append("}");
        return builder.toString();
    }

    public MultiMap() {
        this.store = new HashMap<K, List<V>>();
    }

    private MultiMap(Map<K, List<V>> store) {
        this.store = store;
    }

    public final void add(K k, V v) {
        List<V> l = this.store.get(k);
        if (l == null) {
            l = new ArrayList<V>();
            this.store.put(k, l);
        }
        l.add(v);
    }

    public void set(K k, List<V> v) {
        this.store.put(k, new ArrayList<V>(v));
    }

    public final List<V> get(K k) {
        List<V> l = this.store.get(k);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    public boolean containsKey(K key) {
        return !this.get(key).isEmpty();
    }

    public final V getOne(K k) {
        List<V> lst = this.store.get(k);
        if (lst == null) {
            return null;
        }
        if (lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.store.entrySet();
    }

    public String toCommaSeparatedString() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<K, List<V>> e : this.entrySet()) {
            for (V v : e.getValue()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(e.getKey()).append('=').append(v);
            }
        }
        return buf.toString();
    }

    public MultiMap<K, V> clone() {
        MultiMap<K, V> m = new MultiMap<K, V>();
        for (Map.Entry<K, List<V>> e : this.store.entrySet()) {
            m.store.put(e.getKey(), new ArrayList(e.getValue()));
        }
        return m;
    }

    public static <K, V> MultiMap<K, V> emptyMap() {
        return EMPTY;
    }
}

