/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.mail.Session;
import javax.sql.DataSource;
import javax.xml.ws.WebServiceContext;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA_2_3.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ResourceHandler
extends AbstractResourceHandler {
    private static final Map<Class, Class> envEntryTypes = new HashMap<Class, Class>();

    public Class<? extends Annotation> getAnnotationType() {
        return Resource.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Resource resourceAn = (Resource)ainfo.getAnnotation();
        return this.processResource(ainfo, rcContexts, resourceAn);
    }

    protected HandlerProcessingResult processResource(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts, Resource resourceAn) throws AnnotationProcessorException {
        block8: {
            block9: {
                block7: {
                    Object resourceRefs = null;
                    if (!ElementType.FIELD.equals((Object)ainfo.getElementType())) break block7;
                    Field f = (Field)ainfo.getAnnotatedElement();
                    String targetClassName = f.getDeclaringClass().getName();
                    String logicalName = resourceAn.name();
                    if (logicalName.equals("")) {
                        logicalName = targetClassName + "/" + f.getName();
                    }
                    Class resourceType = resourceAn.type() == Object.class ? f.getType() : resourceAn.type();
                    DescriptorInfo descriptorInfo = this.getDescriptors(resourceType, logicalName, rcContexts);
                    InjectionTarget target = new InjectionTarget();
                    target.setFieldName(f.getName());
                    target.setClassName(targetClassName);
                    for (EnvironmentProperty desc : descriptorInfo.descriptors) {
                        desc.addInjectionTarget(target);
                        if (desc.getName().length() == 0) {
                            this.processNewAnnotation(desc, descriptorInfo.dependencyType, descriptorInfo.resourceType, logicalName, resourceAn);
                            continue;
                        }
                        if (desc.getInjectResourceType() != null) continue;
                        desc.setInjectResourceType(descriptorInfo.resourceType.getName());
                    }
                    break block8;
                }
                if (!ElementType.METHOD.equals((Object)ainfo.getElementType())) break block9;
                Method m = (Method)ainfo.getAnnotatedElement();
                String targetClassName = m.getDeclaringClass().getName();
                String logicalName = resourceAn.name();
                if (logicalName.equals("")) {
                    String propertyName = this.getInjectionMethodPropertyName(m, ainfo);
                    logicalName = targetClassName + "/" + propertyName;
                }
                this.validateInjectionMethod(m, ainfo);
                Class<?>[] params = m.getParameterTypes();
                Class<?> resourceType = resourceAn.type() == Object.class ? params[0] : resourceAn.type();
                DescriptorInfo descriptorInfo = this.getDescriptors(resourceType, logicalName, rcContexts);
                InjectionTarget target = new InjectionTarget();
                target.setMethodName(m.getName());
                target.setClassName(targetClassName);
                for (EnvironmentProperty desc : descriptorInfo.descriptors) {
                    desc.addInjectionTarget(target);
                    if (desc.getName().length() != 0) continue;
                    this.processNewAnnotation(desc, descriptorInfo.dependencyType, descriptorInfo.resourceType, logicalName, resourceAn);
                }
                break block8;
            }
            if (!ElementType.TYPE.equals((Object)ainfo.getElementType())) break block8;
            String logicalName = resourceAn.name();
            Class resourceType = resourceAn.type();
            if ("".equals(logicalName) || resourceType == Object.class) {
                Class c = (Class)ainfo.getAnnotatedElement();
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidtypelevelresource", "Invalid TYPE-level @Resource with name() = [{0}] and type = [{1}] in {2}. Each TYPE-level @Resource must specify both name() and type().", new Object[]{logicalName, resourceType, c}));
                return this.getDefaultFailedResult();
            }
            DescriptorInfo descriptorInfo = this.getDescriptors(resourceType, logicalName, rcContexts);
            for (EnvironmentProperty desc : descriptorInfo.descriptors) {
                if (desc.getName().length() != 0) continue;
                this.processNewAnnotation(desc, descriptorInfo.dependencyType, descriptorInfo.resourceType, logicalName, resourceAn);
            }
        }
        return this.getDefaultProcessedResult();
    }

    private DescriptorInfo getDescriptors(Class resourceType, String logicalName, ResourceContainerContext[] rcContexts) {
        DescriptorInfo descriptorInfo = new DescriptorInfo();
        descriptorInfo.dependencyType = DependencyType.RESOURCE_REF;
        descriptorInfo.resourceType = resourceType;
        if (resourceType == Queue.class || resourceType == Topic.class) {
            descriptorInfo.descriptors = this.getMessageDestinationReferenceDescriptors(logicalName, rcContexts);
            descriptorInfo.dependencyType = DependencyType.MESSAGE_DESTINATION_REF;
        } else if (resourceType == DataSource.class || resourceType == ConnectionFactory.class || resourceType == QueueConnectionFactory.class || resourceType == TopicConnectionFactory.class || resourceType == WebServiceContext.class || resourceType == Session.class || resourceType == URL.class || resourceType == javax.resource.cci.ConnectionFactory.class || resourceType == ORB.class || resourceType == org.omg.CORBA.ORB.class || resourceType == XAConnectionFactory.class || resourceType == XAQueueConnectionFactory.class || resourceType == XATopicConnectionFactory.class) {
            descriptorInfo.descriptors = this.getResourceReferenceDescriptors(logicalName, rcContexts);
            descriptorInfo.dependencyType = DependencyType.RESOURCE_REF;
        } else if (envEntryTypes.containsKey(resourceType)) {
            descriptorInfo.descriptors = this.getEnvironmentPropertyDescriptors(logicalName, rcContexts);
            descriptorInfo.dependencyType = DependencyType.ENV_ENTRY;
            descriptorInfo.resourceType = envEntryTypes.get(resourceType);
        } else {
            descriptorInfo.descriptors = this.getJmsDestinationReferenceDescriptors(logicalName, rcContexts);
            descriptorInfo.dependencyType = DependencyType.RESOURCE_ENV_REF;
        }
        return descriptorInfo;
    }

    private ResourceReferenceDescriptor[] getResourceReferenceDescriptors(String logicalName, ResourceContainerContext[] rcContexts) {
        ResourceReferenceDescriptor[] resourceRefs = new ResourceReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            ResourceReferenceDescriptor resourceRef = rcContexts[i].getResourceReference(logicalName);
            if (resourceRef == null) {
                resourceRef = new ResourceReferenceDescriptor();
                rcContexts[i].addResourceReferenceDescriptor(resourceRef);
            }
            resourceRefs[i] = resourceRef;
        }
        return resourceRefs;
    }

    private MessageDestinationReferenceDescriptor[] getMessageDestinationReferenceDescriptors(String logicName, ResourceContainerContext[] rcContexts) {
        MessageDestinationReferenceDescriptor[] msgDestRefs = new MessageDestinationReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            MessageDestinationReferenceDescriptor msgDestRef = rcContexts[i].getMessageDestinationReference(logicName);
            if (msgDestRef == null) {
                msgDestRef = new MessageDestinationReferenceDescriptor();
                rcContexts[i].addMessageDestinationReferenceDescriptor(msgDestRef);
            }
            msgDestRefs[i] = msgDestRef;
        }
        return msgDestRefs;
    }

    private JmsDestinationReferenceDescriptor[] getJmsDestinationReferenceDescriptors(String logicName, ResourceContainerContext[] rcContexts) {
        JmsDestinationReferenceDescriptor[] jmsDestRefs = new JmsDestinationReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            JmsDestinationReferenceDescriptor jmsDestRef = rcContexts[i].getJmsDestinationReference(logicName);
            if (jmsDestRef == null) {
                jmsDestRef = new JmsDestinationReferenceDescriptor();
                rcContexts[i].addJmsDestinationReferenceDescriptor(jmsDestRef);
            }
            jmsDestRefs[i] = jmsDestRef;
        }
        return jmsDestRefs;
    }

    private EnvironmentProperty[] getEnvironmentPropertyDescriptors(String logicalName, ResourceContainerContext[] rcContexts) {
        HashSet<EnvironmentProperty> envEntriesSet = new HashSet<EnvironmentProperty>();
        for (int i = 0; i < rcContexts.length; ++i) {
            EnvironmentProperty envEntry = rcContexts[i].getEnvEntry(logicalName);
            if (envEntry == null || !envEntry.hasAValue()) continue;
            envEntriesSet.add(envEntry);
        }
        return envEntriesSet.toArray(new EnvironmentProperty[0]);
    }

    private void processNewAnnotation(EnvironmentProperty desc, DependencyType dependencyType, Class resourceType, String logicalName, Resource annotation) {
        desc.setName(logicalName);
        desc.setDescription(annotation.description());
        if (dependencyType == DependencyType.ENV_ENTRY) {
            desc.setType(resourceType.getName());
            desc.setMappedName(annotation.mappedName());
        } else if (dependencyType == DependencyType.MESSAGE_DESTINATION_REF) {
            MessageDestinationReferenceDescriptor msgDestRef = (MessageDestinationReferenceDescriptor)desc;
            msgDestRef.setDestinationType(resourceType.getName());
            msgDestRef.setMappedName(annotation.mappedName());
        } else if (dependencyType == DependencyType.RESOURCE_ENV_REF) {
            JmsDestinationReferenceDescriptor jmsDestRef = (JmsDestinationReferenceDescriptor)desc;
            jmsDestRef.setRefType(resourceType.getName());
            jmsDestRef.setMappedName(annotation.mappedName());
        } else if (dependencyType == DependencyType.RESOURCE_REF) {
            desc.setType(resourceType.getName());
            ResourceReferenceDescriptor resRef = (ResourceReferenceDescriptor)desc;
            String authType = annotation.authenticationType() == Resource.AuthenticationType.CONTAINER ? "Container" : "Application";
            resRef.setAuthorization(authType);
            String sharable = annotation.shareable() ? "Shareable" : "Unshareable";
            resRef.setSharingScope(sharable);
            resRef.setMappedName(annotation.mappedName());
        }
    }

    static {
        envEntryTypes.put(String.class, String.class);
        envEntryTypes.put(Character.class, Character.class);
        envEntryTypes.put(Character.TYPE, Character.class);
        envEntryTypes.put(Character.TYPE, Character.class);
        envEntryTypes.put(Byte.class, Byte.class);
        envEntryTypes.put(Byte.TYPE, Byte.class);
        envEntryTypes.put(Byte.TYPE, Byte.class);
        envEntryTypes.put(Short.class, Short.class);
        envEntryTypes.put(Short.TYPE, Short.class);
        envEntryTypes.put(Short.TYPE, Short.class);
        envEntryTypes.put(Integer.class, Integer.class);
        envEntryTypes.put(Integer.TYPE, Integer.class);
        envEntryTypes.put(Integer.TYPE, Integer.class);
        envEntryTypes.put(Long.class, Long.class);
        envEntryTypes.put(Long.TYPE, Long.class);
        envEntryTypes.put(Long.TYPE, Long.class);
        envEntryTypes.put(Boolean.class, Boolean.class);
        envEntryTypes.put(Boolean.TYPE, Boolean.class);
        envEntryTypes.put(Boolean.TYPE, Boolean.class);
        envEntryTypes.put(Double.class, Double.class);
        envEntryTypes.put(Double.TYPE, Double.class);
        envEntryTypes.put(Double.TYPE, Double.class);
        envEntryTypes.put(Float.class, Float.class);
        envEntryTypes.put(Float.TYPE, Float.class);
        envEntryTypes.put(Float.TYPE, Float.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DependencyType {
        ENV_ENTRY,
        RESOURCE_REF,
        MESSAGE_DESTINATION_REF,
        RESOURCE_ENV_REF;

    }

    private class DescriptorInfo {
        public EnvironmentProperty[] descriptors;
        public DependencyType dependencyType;
        public Class resourceType;

        private DescriptorInfo() {
        }
    }
}

