/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.comet.CometTask;
import com.sun.grizzly.http.SelectorThread;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CometSelector {
    protected CometEngine cometEngine;
    private Selector selector;
    private Logger logger = SelectorThread.logger();
    private ConcurrentHashMap<SelectionKey, CometTask> keysToRegister = new ConcurrentHashMap();

    public CometSelector(CometEngine cometEngine) {
        this.cometEngine = cometEngine;
    }

    public void start() {
        new Thread("CometSelector"){
            {
                this.setDaemon(true);
            }

            public void run() {
                try {
                    CometSelector.this.selector = Selector.open();
                }
                catch (IOException ex) {
                    CometSelector.this.logger.log(Level.SEVERE, "CometSelector.open()", ex);
                    return;
                }
                while (true) {
                    SelectionKey key = null;
                    int selectorState = 0;
                    try {
                        CometTask cometTask;
                        selectorState = 0;
                        try {
                            selectorState = CometSelector.this.selector.select(1000L);
                        }
                        catch (CancelledKeyException ex) {
                            // empty catch block
                        }
                        Set<SelectionKey> readyKeys = CometSelector.this.selector.selectedKeys();
                        Iterator<SelectionKey> iterator = readyKeys.iterator();
                        while (iterator.hasNext()) {
                            key = iterator.next();
                            iterator.remove();
                            if (key.isValid()) {
                                cometTask = (CometTask)((Object)key.attachment());
                                if (key.isReadable()) {
                                    key.interestOps(key.interestOps() & 0xFFFFFFFE);
                                    cometTask.upcoming_op = CometTask.OP_EVENT.READ;
                                }
                                if (key.isWritable()) {
                                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                                    cometTask.upcoming_op = CometTask.OP_EVENT.WRITE;
                                }
                                if (cometTask != null && cometTask.getSelectionKey() != null && cometTask.getSelectionKey().attachment() == null) {
                                    cometTask.execute();
                                    continue;
                                }
                                key.cancel();
                                continue;
                            }
                            CometSelector.this.cancelKey(key);
                        }
                        Iterator keys = CometSelector.this.keysToRegister.keySet().iterator();
                        while (keys.hasNext()) {
                            SelectionKey mainKey = (SelectionKey)keys.next();
                            SocketChannel channel = (SocketChannel)mainKey.channel();
                            if (!mainKey.isValid() || !channel.isOpen()) continue;
                            key = channel.register(CometSelector.this.selector, 1);
                            cometTask = (CometTask)((Object)CometSelector.this.keysToRegister.remove(mainKey));
                            cometTask.setCometKey(key);
                            key.attach((Object)cometTask);
                            keys.remove();
                        }
                        CometSelector.this.expireIdleKeys();
                        if (selectorState > 0) continue;
                        CometSelector.this.selector.selectedKeys().clear();
                        continue;
                    }
                    catch (Throwable t) {
                        if (key != null) {
                            try {
                                CometSelector.this.cancelKey(key);
                            }
                            catch (Throwable t2) {
                                CometSelector.this.logger.log(Level.SEVERE, "CometSelector", t2);
                            }
                        }
                        if (selectorState <= 0) {
                            CometSelector.this.selector.selectedKeys().clear();
                        }
                        CometSelector.this.logger.log(Level.SEVERE, "CometSelector", t);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    protected void expireIdleKeys() {
        Set<SelectionKey> readyKeys = this.selector.keys();
        if (readyKeys.isEmpty()) {
            return;
        }
        long current = System.currentTimeMillis();
        for (SelectionKey key : readyKeys) {
            CometTask cometTask = (CometTask)((Object)key.attachment());
            if (cometTask == null) {
                return;
            }
            long expire = cometTask.getExpireTime();
            if (current - expire >= cometTask.getExpirationDelay()) {
                this.cancelKey(key);
            }
            if (cometTask.getSelectionKey() == null || !(cometTask.getSelectionKey().attachment() instanceof Long)) continue;
            key.cancel();
            this.cometEngine.interrupt(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void cancelKey(SelectionKey key) {
        if (!key.isValid()) {
            return;
        }
        try {
            CometTask cometTask = (CometTask)((Object)key.attachment());
            if (cometTask != null) {
                SelectorThread st = cometTask.getSelectorThread();
                SelectionKey mainKey = cometTask.getSelectionKey();
                if (cometTask.getCometContext() != null) {
                    cometTask.getCometContext().interrupt(mainKey);
                }
                this.cometEngine.interrupt(key);
                st.cancelKey(mainKey);
            } else {
                this.cometEngine.interrupt(key);
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "CometSelector", t);
        }
        finally {
            key.attach(null);
        }
        key.cancel();
    }

    public void registerKey(SelectionKey key, CometTask cometTask) {
        cometTask.setExpireTime(System.currentTimeMillis());
        this.keysToRegister.put(key, cometTask);
        this.selector.wakeup();
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    public SelectionKey cometKeyFor(SelectableChannel channel) {
        return channel.keyFor(this.selector);
    }
}

