/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.container;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.container.GrizzletCometHandler;
import com.sun.grizzly.container.GrizzletRequest;
import com.sun.grizzly.container.GrizzletResponse;
import com.sun.grizzly.grizzlet.AlreadyPausedException;
import com.sun.grizzly.grizzlet.AsyncConnection;
import com.sun.grizzly.grizzlet.Grizzlet;
import com.sun.grizzly.grizzlet.NotYetPausedException;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AsyncConnectionImpl
implements AsyncConnection {
    private GrizzletRequest cometRequest;
    private GrizzletResponse cometResponse;
    public String message;
    private boolean isPaused = false;
    private CometContext cometContext;
    private static ConcurrentLinkedQueue<CometHandler> handlers;
    private Grizzlet grizzlet;
    private boolean isResuming = false;
    private boolean hasPushEvent = false;

    public AsyncConnectionImpl() {
        handlers = new ConcurrentLinkedQueue();
    }

    public void setCometContext(CometContext cometContext) {
        this.cometContext = cometContext;
    }

    public GrizzletRequest getRequest() {
        return this.cometRequest;
    }

    protected void setRequest(GrizzletRequest cometRequest) {
        this.cometRequest = cometRequest;
    }

    public GrizzletResponse getResponse() {
        return this.cometResponse;
    }

    protected void setResponse(GrizzletResponse cometResponse) {
        this.cometResponse = cometResponse;
    }

    public boolean isSuspended() {
        return this.isPaused;
    }

    public void suspend() throws AlreadyPausedException {
        if (this.isPaused) {
            throw new AlreadyPausedException();
        }
        this.isPaused = true;
        CometEvent event = new CometEvent();
        GrizzletCometHandler cometHandler = new GrizzletCometHandler();
        cometHandler.setGrizzlet(this.grizzlet);
        cometHandler.attach(this.cometRequest);
        this.cometContext.addCometHandler(cometHandler);
        handlers.add(cometHandler);
    }

    public void resume() throws NotYetPausedException {
        Iterator<CometHandler> i = handlers.iterator();
        while (i.hasNext()) {
            this.cometContext.removeCometHandler(i.next());
            i.remove();
        }
        this.isPaused = false;
    }

    public boolean isResuming() {
        return this.isResuming;
    }

    public void setIsResuming(boolean isResuming) {
        this.isResuming = isResuming;
    }

    public void push(String message) throws IOException {
        this.message = message;
        this.hasPushEvent = true;
        this.cometContext.notify(this);
        this.hasPushEvent = false;
    }

    public void sethasPushEvent(boolean hasPushEvent) {
        this.hasPushEvent = hasPushEvent;
    }

    public boolean hasPushEvent() {
        return this.hasPushEvent;
    }

    public String getPushEvent() {
        return this.message;
    }

    public boolean isGet() {
        return this.cometRequest.getRequest().method().equals("GET");
    }

    public boolean isPost() {
        return this.cometRequest.getRequest().method().equals("POST");
    }

    public void setGrizzlet(Grizzlet grizzlet) {
        this.grizzlet = grizzlet;
    }

    public void recycle() {
        this.grizzlet = null;
        this.isPaused = false;
        this.isResuming = false;
        this.cometRequest = null;
        this.cometResponse = null;
        this.message = null;
        this.hasPushEvent = false;
    }
}

