/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.base.NotificationServiceMgr;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.admin.amx.mbean.NotificationServiceImpl;
import org.glassfish.admin.amx.support.UniqueIDGenerator;
import org.glassfish.admin.amx.util.ObjectNames;

public class NotificationServiceMgrImpl
extends AMXNonConfigImplBase
implements NotificationListener {
    private final Map<ObjectName, NotificationServiceImpl> mServices = Collections.synchronizedMap(new HashMap());
    private final UniqueIDGenerator mUniqueIDs = new UniqueIDGenerator("notif-service-");

    public NotificationServiceMgrImpl() {
        super("X-NotificationServiceMgr", "X-NotificationServiceMgr", ObjectNames.getInstance().getDomainRootObjectName(), NotificationServiceMgr.class, null);
    }

    public void handleNotification(Notification notifIn, Object handback) {
        MBeanServerNotification notif;
        ObjectName objectName;
        String type = notifIn.getType();
        if (type.equals("JMX.mbean.unregistered") && Util.getJ2EEType((ObjectName)(objectName = (notif = (MBeanServerNotification)notifIn).getMBeanName())).equals("X-NotificationService")) {
            this.mServices.remove(objectName);
        }
    }

    public String getGroup() {
        return "utility";
    }

    public void preRegisterDone() throws Exception {
        JMXUtil.listenToMBeanServerDelegate((MBeanServerConnection)this.getMBeanServer(), (NotificationListener)this, null, null);
    }

    public ObjectName createNotificationService(Object userData, int bufferSize) {
        NotificationServiceImpl service = new NotificationServiceImpl(userData, bufferSize);
        ObjectName self = this.getObjectName();
        String domain = self.getDomain();
        String childName = this.mUniqueIDs.createID().toString();
        String requiredProps = Util.makeRequiredProps((String)"X-NotificationService", (String)childName);
        ObjectName tempName = JMXUtil.newObjectName((String)domain, (String)requiredProps);
        ObjectName objectName = null;
        try {
            objectName = this.registerMBean(service, tempName);
            this.mServices.put(objectName, service);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return objectName;
    }

    public ObjectName getNotificationServiceObjectName(String name) {
        return this.getContainerSupport().getContaineeObjectName("X-NotificationService", name);
    }

    public synchronized void removeNotificationService(String name) throws InstanceNotFoundException {
        ObjectName objectName = this.getNotificationServiceObjectName(name);
        if (objectName == null) {
            throw new IllegalArgumentException(name);
        }
        if (!this.mServices.containsKey(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        try {
            this.getMBeanServer().unregisterMBean(objectName);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e);
        }
        this.mServices.remove(objectName);
    }
}

