/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.base.Singleton;
import com.sun.appserv.management.base.UploadDownloadMgr;
import com.sun.appserv.management.base.Utility;
import com.sun.appserv.management.util.misc.GSetUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.admin.amx.support.DownloadInfo;
import org.glassfish.admin.amx.support.UniqueIDGenerator;
import org.glassfish.admin.amx.support.UploadInfo;
import org.glassfish.admin.amx.util.ObjectNames;

public final class UploadDownloadMgrImpl
extends AMXNonConfigImplBase
implements Utility,
Singleton,
UploadDownloadMgr {
    private final Map<Object, UploadInfo> mUploadInfos = Collections.synchronizedMap(new HashMap());
    private final Map<Object, DownloadInfo> mDownloadInfos = Collections.synchronizedMap(new HashMap());
    private final UniqueIDGenerator mUploadIDs = new UniqueIDGenerator("upload-");
    private final UniqueIDGenerator mDownloadIDs = new UniqueIDGenerator("download-");
    private static final long SECOND_MILLIS = 60000L;
    private static final long UPLOAD_KEEP_ALIVE_MILLIS = 3600000L;
    private static final long DOWNLOAD_KEEP_ALIVE_MILLIS = 10800000L;

    public UploadDownloadMgrImpl() {
        super("X-UploadDownloadMgr", "X-UploadDownloadMgr", ObjectNames.getInstance().getDomainRootObjectName(), UploadDownloadMgr.class, null);
    }

    public final String getGroup() {
        return "utility";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void staleUploadCheck() throws IOException {
        String[] keys = null;
        Object object = this.mUploadInfos;
        synchronized (object) {
            keys = GSetUtil.toStringArray(this.mUploadInfos.keySet());
        }
        object = this;
        synchronized (object) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                UploadInfo info = this.mUploadInfos.get(key);
                if (info == null || info.getMillisSinceLastAccess() <= 3600000L) continue;
                this.trace("Cleaning up stale upload: " + info.getID());
                this.mUploadInfos.remove(key);
                info.cleanup();
            }
        }
    }

    private String mangleUploadName(String name) {
        String result = name;
        if (result != null) {
            result = result.replaceAll("/", "_");
            result = result.replaceAll("\\\\", "_");
            result = result.replaceAll(":", "_");
        }
        return result;
    }

    public Object initiateUpload(String name, long totalSize) throws IOException {
        this.staleUploadCheck();
        String actualName = this.mangleUploadName(name);
        UploadInfo info = new UploadInfo(this.mUploadIDs.createID(), actualName, totalSize);
        this.mUploadInfos.put(info.getID(), info);
        return info.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadBytes(Object uploadID, byte[] bytes) throws IOException {
        UploadInfo info = this.mUploadInfos.get(uploadID);
        if (info == null) {
            throw new IllegalArgumentException("" + uploadID);
        }
        boolean done = false;
        UploadInfo uploadInfo = info;
        synchronized (uploadInfo) {
            done = info.write(bytes);
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File takeUpload(Object uploadID) {
        UploadInfo info = this.mUploadInfos.get(uploadID);
        if (info == null) {
            throw new IllegalArgumentException("" + uploadID);
        }
        UploadInfo uploadInfo = info;
        synchronized (uploadInfo) {
            if (!info.isDone()) {
                throw new IllegalArgumentException("not done:" + uploadID);
            }
            this.mUploadInfos.remove(uploadID);
        }
        return info.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void staleDownloadCheck() throws IOException {
        String[] keys = null;
        Object object = this.mDownloadInfos;
        synchronized (object) {
            keys = GSetUtil.toStringArray(this.mDownloadInfos.keySet());
        }
        object = this;
        synchronized (object) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                DownloadInfo info = this.mDownloadInfos.get(key);
                if (info == null || !info.isDone()) continue;
                this.mDownloadInfos.remove(key);
                this.trace("Cleaning up stale download: " + info.getID() + "length was " + info.getLength());
                info.cleanup();
            }
        }
    }

    public Object initiateDownload(File theFile, boolean deleteWhenDone) throws IOException {
        this.staleDownloadCheck();
        DownloadInfo info = new DownloadInfo(this.mDownloadIDs.createID(), theFile, deleteWhenDone);
        this.trace("Created download info: " + info.getID());
        this.mDownloadInfos.put(info.getID(), info);
        return info.getID();
    }

    private DownloadInfo getDownloadInfo(Object downloadID) {
        DownloadInfo info = this.mDownloadInfos.get(downloadID);
        if (info == null) {
            throw new IllegalArgumentException("" + downloadID);
        }
        return info;
    }

    public long getDownloadLength(Object downloadID) {
        try {
            DownloadInfo info = this.getDownloadInfo(downloadID);
            return info.getLength();
        }
        catch (Exception e) {
            e.printStackTrace();
            assert (false);
            return 0L;
        }
    }

    public int getMaxDownloadChunkSize() {
        return 0x500000;
    }

    public byte[] downloadBytes(Object downloadID, int requestSize) throws IOException {
        if (requestSize > this.getMaxDownloadChunkSize()) {
            this.trace("Request too large: " + requestSize);
            throw new IllegalArgumentException("request too large: " + requestSize);
        }
        DownloadInfo info = this.getDownloadInfo(downloadID);
        byte[] bytes = info.read(requestSize);
        if (info.isDone()) {
            this.trace("download done: " + info.getID());
            this.staleDownloadCheck();
        }
        return bytes;
    }
}

