/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.support;

import com.sun.appserv.management.base.AMXLoggerBase;
import com.sun.appserv.management.base.Util;
import java.util.HashMap;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.glassfish.admin.amx.util.ObjectNames;

public final class AMXMBeanLogger
extends AMXLoggerBase {
    private final ObjectName mObjectName;
    private static final String TYPE_NAME_DELIM = ":";
    public static final String OBJECT_NAME_KEY = "ObjectName";

    private static String mangle(String s) {
        return s.replaceAll("\\.", "_");
    }

    private static String formTypeName(String j2eeType, String name) {
        String result = null;
        if (j2eeType == null) {
            result = name;
        } else {
            String pair = AMXMBeanLogger.mangle(j2eeType);
            if (!name.equals(ObjectNames.getSingletonName(j2eeType))) {
                pair = pair + TYPE_NAME_DELIM + AMXMBeanLogger.mangle(name);
            }
            result = pair;
        }
        return result;
    }

    private static String createLoggerName(ObjectName objectName) {
        String j2eeType = Util.getJ2EEType((ObjectName)objectName);
        String name = Util.getName((ObjectName)objectName);
        return "AMX_MBEAN_LOGGER_" + j2eeType + "_" + name;
    }

    private AMXMBeanLogger(ObjectName objectName) {
        this(objectName, null);
        throw new IllegalArgumentException();
    }

    private AMXMBeanLogger(ObjectName objectName, String resourceBundleName) {
        super(AMXMBeanLogger.createLoggerName(objectName), resourceBundleName);
        this.mObjectName = objectName;
        throw new IllegalArgumentException();
    }

    public static Logger createNew(ObjectName objectName) {
        String loggerName = AMXMBeanLogger.createLoggerName(objectName);
        return Logger.getLogger(loggerName);
    }

    public void log(LogRecord record) {
        Object[] existing = record.getParameters();
        int numExisting = existing == null ? 0 : existing.length;
        Object[] params = new Object[1 + numExisting];
        if (existing != null) {
            System.arraycopy(existing, 0, params, 0, existing.length);
        }
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        m.put(OBJECT_NAME_KEY, this.mObjectName);
        params[params.length - 1] = m;
        record.setParameters(params);
        super.log(record);
    }
}

