/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.support;

import com.sun.appserv.management.base.Util;
import javax.management.ObjectName;
import org.glassfish.admin.amx.support.AMXMBeanRootLogger;
import org.glassfish.admin.amx.support.AMXServerLogger;
import org.glassfish.admin.amx.util.Issues;

public final class BootUtil {
    private final String mAppserverDomainName;
    private final String mAMX_JMXDomain;
    private static BootUtil INSTANCE = null;
    private boolean mAMXReady;
    private final boolean mOfflineAMX;

    private BootUtil(String appserverDomainName, boolean offline) {
        AMXServerLogger.getInstance();
        AMXMBeanRootLogger.getInstance();
        this.mAppserverDomainName = appserverDomainName;
        this.mAMX_JMXDomain = appserverDomainName;
        this.mAMXReady = false;
        this.mOfflineAMX = offline;
    }

    public String getServerName() {
        Issues.getAMXIssues().notDone("BootUtil.getServerName()");
        return "server";
    }

    public static synchronized void init(boolean offline) {
        INSTANCE = new BootUtil("amx", offline);
    }

    public boolean getOffline() {
        return this.mOfflineAMX;
    }

    public static synchronized BootUtil getInstance() {
        if (INSTANCE == null) {
            throw new IllegalArgumentException("must call init() first");
        }
        return INSTANCE;
    }

    public boolean getAMXReady() {
        return this.mAMXReady;
    }

    public void setAMXReady(boolean ready) {
        if (this.mAMXReady && !ready) {
            throw new IllegalArgumentException();
        }
        this.mAMXReady = ready;
    }

    private ObjectName getObjectName(String props) {
        String domain = this.getAMXSupportJMXDomain();
        return Util.newObjectName((String)domain, (String)props);
    }

    public String getAMXSupportJMXDomain() {
        return this.getAMXJMXDomainName() + "-support";
    }

    public String getAppserverDomainName() {
        return this.mAppserverDomainName;
    }

    public String getAMXJMXDomainName() {
        return this.mAMX_JMXDomain;
    }
}

