/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.appserv.connectors.spi.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.module.ModuleDefinition;
import java.util.Collection;
import java.util.Set;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.ClassTransformer;
import javax.sql.DataSource;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DummyApplication;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.persistence.jpa.JPAContainer;
import org.glassfish.persistence.jpa.PersistenceUnitLoader;
import org.glassfish.persistence.jpa.PersistenceUnitLoaderImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class JPADeployer
extends SimpleDeployer<JPAContainer, DummyApplication> {
    @Inject
    ConnectorRuntime connectorRuntime;

    public MetaData getMetaData() {
        MetaData javaEEDeployerMetaData = super.getMetaData();
        ModuleDefinition[] publicAPIsForJavaEE = javaEEDeployerMetaData.getPublicAPIs();
        return new MetaData(true, publicAPIsForJavaEE, null, new Class[]{Application.class});
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected RootDeploymentDescriptor getDefaultBundleDescriptor() {
        return null;
    }

    protected String getModuleType() {
        return "JPA-MODULE";
    }

    public boolean prepare(DeploymentContext dc) {
        boolean prepared = super.prepare(dc);
        if (prepared) {
            Application application = (Application)dc.getModuleMetaData(Application.class);
            Set bundles = application.getBundleDescriptors();
            for (BundleDescriptor bundle : bundles) {
                ApplicationInfoImpl applicationInfo = new ApplicationInfoImpl(bundle, dc, this.connectorRuntime);
                new PersistenceUnitLoaderImpl(applicationInfo).load();
            }
        }
        return true;
    }

    public DummyApplication load(JPAContainer container, DeploymentContext context) {
        return new DummyApplication();
    }

    public void unload(DummyApplication appContainer, DeploymentContext context) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ApplicationInfoImpl
    implements PersistenceUnitLoader.ApplicationInfo {
        private BundleDescriptor bd;
        private DeploymentContext deploymentContext;
        private ConnectorRuntime connectorRuntime;

        public ApplicationInfoImpl(BundleDescriptor bd, DeploymentContext deploymentContext, ConnectorRuntime connectorRuntime) {
            this.bd = bd;
            this.deploymentContext = deploymentContext;
            this.connectorRuntime = connectorRuntime;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.deploymentContext.getClassLoader();
        }

        @Override
        public ClassLoader getTempClassloader() {
            return this.deploymentContext.getClassLoader();
        }

        @Override
        public void addTransformer(ClassTransformer transformer) {
        }

        @Override
        public String getApplicationLocation() {
            return this.deploymentContext.getSourceDir().getAbsolutePath();
        }

        @Override
        public Collection<? extends PersistenceUnitDescriptor> getReferencedPUs() {
            return this.bd.findReferencedPUs();
        }

        @Override
        public Collection<? extends EntityManagerFactory> getEntityManagerFactories() {
            return this.bd.getEntityManagerFactories();
        }

        @Override
        public DataSource lookupDataSource(String dataSourceName) throws NamingException {
            return (DataSource)DataSource.class.cast(this.connectorRuntime.lookupPMResource(dataSourceName, false));
        }

        @Override
        public DataSource lookupNonTxDataSource(String dataSourceName) throws NamingException {
            return (DataSource)DataSource.class.cast(this.connectorRuntime.lookupNonTxResource(dataSourceName, false));
        }
    }
}

