/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.cometd.BayeuxCometHandlerBase;
import com.sun.grizzly.cometd.CometdContext;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.DataHandler;
import com.sun.grizzly.cometd.bayeux.Advice;
import com.sun.grizzly.cometd.bayeux.ConnectRequest;
import com.sun.grizzly.cometd.bayeux.ConnectResponse;
import com.sun.grizzly.cometd.bayeux.Data;
import com.sun.grizzly.cometd.bayeux.DeliverResponse;
import com.sun.grizzly.cometd.bayeux.DisconnectRequest;
import com.sun.grizzly.cometd.bayeux.DisconnectResponse;
import com.sun.grizzly.cometd.bayeux.HandshakeRequest;
import com.sun.grizzly.cometd.bayeux.HandshakeResponse;
import com.sun.grizzly.cometd.bayeux.PublishRequest;
import com.sun.grizzly.cometd.bayeux.PublishResponse;
import com.sun.grizzly.cometd.bayeux.ReconnectRequest;
import com.sun.grizzly.cometd.bayeux.ReconnectResponse;
import com.sun.grizzly.cometd.bayeux.SubscribeRequest;
import com.sun.grizzly.cometd.bayeux.SubscribeResponse;
import com.sun.grizzly.cometd.bayeux.UnsubscribeRequest;
import com.sun.grizzly.cometd.bayeux.UnsubscribeResponse;
import com.sun.grizzly.cometd.bayeux.Verb;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class BayeuxCometHandler
extends BayeuxCometHandlerBase {
    public static final String DEFAULT_CONTENT_TYPE = "application/json-comment-filtered";
    public static final String BAYEUX_COMET_HANDLER = "bayeuxCometHandler";
    private ConcurrentHashMap<String, String> activeChannels = new ConcurrentHashMap();
    private Random random = new Random();
    private ConcurrentHashMap<String, DataHandler> activeCometHandlers = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandshake(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        HandshakeRequest handshakeReq = (HandshakeRequest)cometdContext.getVerb();
        HandshakeResponse handshakeRes = new HandshakeResponse(handshakeReq);
        handshakeRes.setAdvice(new Advice());
        if (handshakeReq.isValid()) {
            String clientId = null;
            Random random = this.random;
            synchronized (random) {
                clientId = String.valueOf(Long.toHexString(this.random.nextLong()));
            }
            handshakeRes.setClientId(clientId);
        } else {
            handshakeRes.setSuccessful(false);
            handshakeRes.setError("501::invalid handshake");
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(handshakeRes.toJSON());
        res.flush();
    }

    public void onConnect(CometEvent event) throws IOException {
        String subscribedChannel;
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        ConnectRequest connectReq = (ConnectRequest)cometdContext.getVerb();
        ConnectResponse connectRes = new ConnectResponse(connectReq);
        connectRes.setAdvice(new Advice());
        if (!connectReq.isValid()) {
            connectRes.setError("501::invalid connect");
        }
        if ((subscribedChannel = this.activeChannels.get(connectReq.getClientId())) != null) {
            CometContext cometContext = event.getCometContext();
            DataHandler dataHandler = new DataHandler();
            dataHandler.attach(new Object[]{req, res});
            dataHandler.setChannel(subscribedChannel);
            dataHandler.setClientId(connectReq.getClientId());
            this.activeCometHandlers.put(connectReq.getClientId(), dataHandler);
            event.getCometContext().addCometHandler((CometHandler)dataHandler);
            connectRes.setAdvice(null);
        }
        String jsonMessage = subscribedChannel != null ? connectRes.toLongPolledJSON() : connectRes.toJSON();
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(jsonMessage);
        res.flush();
    }

    public void onDisconnect(CometEvent event) throws IOException {
        DataHandler dataHandler;
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        DisconnectRequest disconnectReq = (DisconnectRequest)cometdContext.getVerb();
        DisconnectResponse disconnectRes = new DisconnectResponse(disconnectReq);
        if (!disconnectReq.isValid()) {
            disconnectRes.setError("501::invalid disonnect");
        }
        if ((dataHandler = this.activeCometHandlers.remove(disconnectReq.getClientId())) != null) {
            event.getCometContext().notify((Object)"disconnecting", 3, dataHandler.hashCode());
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(disconnectRes.toJSON());
        res.flush();
    }

    public void onReconnect(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        ReconnectRequest reconnectReq = (ReconnectRequest)cometdContext.getVerb();
        ReconnectResponse reconnectRes = new ReconnectResponse(reconnectReq);
        if (!reconnectReq.isValid()) {
            reconnectRes.setError("501::invalid reconnect");
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(reconnectRes.toJSON());
        res.flush();
    }

    public void onSubscribe(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        SubscribeRequest subscribeReq = (SubscribeRequest)cometdContext.getVerb();
        SubscribeResponse subscribeRes = new SubscribeResponse(subscribeReq);
        if (!subscribeReq.isValid()) {
            subscribeRes.setError("501::invalid subscribe");
        }
        this.activeChannels.put(subscribeReq.getClientId(), subscribeReq.getSubscription());
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(subscribeRes.toJSON());
        res.flush();
    }

    public void onUnsubscribe(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        UnsubscribeRequest unsubscribeReq = (UnsubscribeRequest)cometdContext.getVerb();
        UnsubscribeResponse unsubscribeRes = new UnsubscribeResponse(unsubscribeReq);
        if (!unsubscribeReq.isValid()) {
            unsubscribeRes.setError("501::invalid unsubscribe");
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(unsubscribeRes.toJSON());
        res.flush();
    }

    public void onPublish(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        PublishRequest publishReq = (PublishRequest)cometdContext.getVerb();
        PublishResponse publishRes = new PublishResponse(publishReq);
        DeliverResponse deliverRes = null;
        if (publishReq.isValid()) {
            publishRes.setSuccessful(true);
            Data data = publishReq.getData();
            if (data != null) {
                deliverRes = new DeliverResponse(publishReq);
                if (publishReq.isFirst()) {
                    deliverRes.setFirst(false);
                    deliverRes.setFollow(true);
                }
                if (publishReq.isLast()) {
                    publishRes.setLast(false);
                    deliverRes.setFollow(true);
                    deliverRes.setLast(true);
                }
            }
        } else {
            publishRes.setSuccessful(false);
            publishRes.setError("501:: invalid publish");
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(publishRes.toJSON());
        if (deliverRes != null) {
            res.write(deliverRes.toJSON());
        }
        res.flush();
        if (deliverRes != null) {
            event.getCometContext().notify((Object)deliverRes);
        }
    }

    public static final CometdContext newCometdContext(final CometdRequest req, final CometdResponse res, final Verb verb) {
        return new CometdContext(){

            public Verb getVerb() {
                return verb;
            }

            public CometdRequest getRequest() {
                return req;
            }

            public CometdResponse getResponse() {
                return res;
            }
        };
    }

    public void onTerminate(CometEvent event) throws IOException {
        this.onInterrupt(event);
    }

    public void onInterrupt(CometEvent event) throws IOException {
    }

    public void onPing(CometEvent event) throws IOException {
    }

    public void onStatus(CometEvent event) throws IOException {
    }

    public String getChannel() {
        return BAYEUX_COMET_HANDLER;
    }

    public void setChannel(String channel) {
    }
}

