/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.glassfish.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GFDomainLauncher
extends GFLauncher {
    private static final String MAIN_CLASS = "com.sun.enterprise.glassfish.bootstrap.Main";
    private static final String BOOTSTRAP_JAR_RELATIVE_PATH = "modules/glassfish-10.0-SNAPSHOT.jar";

    GFDomainLauncher(GFLauncherInfo info) {
        super(info);
    }

    @Override
    void internalLaunch() throws GFLauncherException {
        try {
            if (this.getInfo().isEmbedded()) {
                this.launchEmbedded();
            } else {
                this.launchExternal();
            }
        }
        catch (GFLauncherException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GFLauncherException(ex);
        }
    }

    private void launchEmbedded() throws GFLauncherException, BootException {
        Main main = new Main();
        main.start(this.getInfo().getArgsAsStringArray());
        GFLauncherLogger.info("finishedEmbedded", this.getInfo().getDomainName());
    }

    private void launchExternal() throws GFLauncherException, MiniXmlParserException {
        Process p;
        List<String> cmds = this.getCommandLine();
        ProcessBuilder pb = new ProcessBuilder(cmds);
        System.out.println("****************************************************");
        System.out.println("************ TP2 Launcher  *******************");
        System.out.println("** The commandline below is temporarily here for your info.  When logging is setup it will go to the log file.");
        System.out.println("**   jvm command line  **");
        System.out.println("---------------------------------------------------");
        for (String s : cmds) {
            System.out.println(s);
        }
        System.out.println("****************************************************");
        try {
            p = pb.start();
            if (this.getInfo().isVerbose()) {
                ProcessStreamDrainer.redirect((String)this.getInfo().getDomainName(), (Process)p);
            } else {
                ProcessStreamDrainer.drain((String)this.getInfo().getDomainName(), (Process)p);
            }
        }
        catch (IOException e) {
            throw new GFLauncherException("jvmfailure", (Throwable)e, e);
        }
        long endTime = System.currentTimeMillis();
        GFLauncherLogger.info("launchTime", endTime - this.getStartTime());
        try {
            if (this.getInfo().isVerbose()) {
                p.waitFor();
            }
        }
        catch (InterruptedException ex) {
            throw new GFLauncherException("verboseInterruption", (Throwable)ex, ex);
        }
    }

    @Override
    List<File> getMainClasspath() throws GFLauncherException {
        ArrayList<File> list = new ArrayList<File>();
        File f = new File(this.getEnvProps().get("com.sun.aas.installRoot"));
        if (!(f = new File(f, BOOTSTRAP_JAR_RELATIVE_PATH)).exists()) {
            throw new GFLauncherException("nobootjar", f.getPath());
        }
        list.add(GFLauncherUtils.absolutize((File)f));
        return list;
    }

    @Override
    String getMainClass() throws GFLauncherException {
        return MAIN_CLASS;
    }
}

