/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.loader;

import com.sun.appserv.management.annotation.AMXConfigInfo;
import com.sun.appserv.management.annotation.AMXMBeanMetadata;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.RunnableBase;
import java.util.concurrent.LinkedBlockingQueue;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.glassfish.admin.amx.loader.AMXConfigVoid;
import org.glassfish.admin.amx.mbean.AMXConfigImplBase;
import org.glassfish.admin.amx.mbean.DelegateToConfigBeanDelegate;
import org.glassfish.admin.amx.util.ObjectNames;
import org.jvnet.hk2.config.ConfigBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AMXConfigLoader {
    private volatile MBeanServer mMBeanServer;
    private final LinkedBlockingQueue<ConfigBean> mPendingConfigBeans = new LinkedBlockingQueue();
    private AMXConfigLoaderThread mLoaderThread = null;

    private static void debug(String s) {
        System.out.println(s);
    }

    protected void handleConfigBean(ConfigBean cb) {
        this.mPendingConfigBeans.add(cb);
    }

    private static ConfigBean getActualParent(ConfigBean configBean) {
        ConfigBean parent = AMXConfigLoader.asConfigBean(configBean.parent());
        if (parent != null) {
            ObjectName parentObjectName = parent.getObjectName();
            if (parentObjectName == null) {
                Class parentClass = parent.getProxyType();
                AMXConfigInfo amxConfigInfo = parentClass.getAnnotation(AMXConfigInfo.class);
                if (amxConfigInfo == null) {
                    throw new IllegalArgumentException("ConfigBean has no @AMXConfigInfo: " + parentClass.getName());
                }
                if (amxConfigInfo.amxInterface() == AMXConfigVoid.class) {
                    parent = AMXConfigLoader.getActualParent(parent);
                }
            }
        } else if (!configBean.getProxyType().getName().endsWith("Domain")) {
            AMXConfigLoader.debug("WARNING: parent is null for " + configBean.getProxyType().getName() + " (bug in ConfigBeans)");
        }
        return parent;
    }

    private static ObjectName getActualParentObjectName(ConfigBean configBean) {
        ObjectName parentObjectName = null;
        ConfigBean parent = AMXConfigLoader.getActualParent(configBean);
        if (parent != null) {
            parentObjectName = parent.getObjectName();
        }
        return parentObjectName;
    }

    static ConfigBean asConfigBean(Object o) {
        return o instanceof ConfigBean ? (ConfigBean)o : null;
    }

    public synchronized void start(MBeanServer server) {
        if (this.mLoaderThread == null) {
            this.mMBeanServer = server;
            this.mLoaderThread = new AMXConfigLoaderThread(this.mPendingConfigBeans);
            this.mLoaderThread.submit(RunnableBase.HowToRun.RUN_IN_SEPARATE_THREAD);
        }
        try {
            new AMXConfigImplBase(null, null, null, AMXConfig.class, null, null);
            throw new Error("AMXConfigLoader: AMXConfigImplBase did not throw an exception for a null j2eeType!!!");
        }
        catch (Exception exception) {
            return;
        }
    }

    private void registerConfigBeanAsMBean(ConfigBean cb) {
        if (this.getAMXConfigInfo(cb) != null) {
            ConfigBean parentCB = AMXConfigLoader.getActualParent(cb);
            if (parentCB != null && parentCB.getObjectName() == null) {
                this.registerConfigBeanAsMBean(parentCB);
            }
            ObjectName objectName = this._registerConfigBeanAsMBean(cb, parentCB);
            assert (cb.getObjectName() != null);
        } else {
            AMXConfigLoader.debug("NOTE: ConfigBean has no @AMXConfigInfo: " + cb.getProxyType().getName() + " (IGNORING)");
        }
    }

    private AMXConfigInfo getAMXConfigInfo(ConfigBean cb) {
        Class cbClass = cb.getProxyType();
        AMXConfigInfo amxConfigInfo = cbClass.getAnnotation(AMXConfigInfo.class);
        return amxConfigInfo;
    }

    private AMXMBeanMetadata getAMXMBeanMetadata(ConfigBean cb) {
        Class cbClass = cb.getProxyType();
        AMXMBeanMetadata metadata = cbClass.getAnnotation(AMXMBeanMetadata.class);
        if (metadata == null) {
            metadata = AMXConfigInfo.class.getAnnotation(AMXMBeanMetadata.class);
        }
        return metadata;
    }

    private ObjectName _registerConfigBeanAsMBean(ConfigBean cb, ConfigBean parentCB) {
        Class cbClass = cb.getProxyType();
        ObjectName objectName = cb.getObjectName();
        if (objectName != null) {
            throw new IllegalArgumentException("ConfigBean " + cbClass.getName() + " already registered as " + objectName);
        }
        if (parentCB != null && parentCB.getObjectName() == null) {
            throw new IllegalArgumentException("ConfigBean parent " + parentCB.getProxyType().getName() + " must be registered first before child = " + cbClass.getName());
        }
        AMXConfigInfo amxConfigInfo = this.getAMXConfigInfo(cb);
        if (amxConfigInfo == null) {
            throw new IllegalArgumentException("ConfigBean has no @AMXConfigInfo: " + cbClass.getName());
        }
        if (amxConfigInfo.amxInterface() != AMXConfigVoid.class) {
            boolean autoInterface;
            Class amxInterface = amxConfigInfo.amxInterface();
            boolean bl = autoInterface = amxInterface == AMXConfig.class;
            Class supplementaryIntf = autoInterface ? (cbClass.isInterface() ? cbClass : null) : null;
            AMXMBeanMetadata metadata = this.getAMXMBeanMetadata(cb);
            objectName = this.buildObjectName(cb, amxConfigInfo);
            objectName = this.createAndRegister(cb, amxInterface, supplementaryIntf, objectName);
        }
        return objectName;
    }

    protected static String getFullType(ConfigBean cb, ObjectName proposedObjectName) {
        String fullType = "";
        if (cb != null) {
            ObjectName objectName = proposedObjectName != null ? proposedObjectName : cb.getObjectName();
            String j2eeType = objectName.getKeyProperty("j2eeType");
            ConfigBean parent = AMXConfigLoader.getActualParent(cb);
            fullType = parent == null ? j2eeType : AMXConfigLoader.getFullType(parent, null) + "." + j2eeType;
        }
        return fullType;
    }

    private ObjectName createAndRegister(ConfigBean cb, Class<? extends AMXConfig> amxInterface, Class<?> supplementaryIntf, ObjectName objectNameIn) {
        ObjectName objectName = objectNameIn;
        String j2eeType = objectNameIn.getKeyProperty("j2eeType");
        String fullType = AMXConfigLoader.getFullType(cb, objectName);
        DelegateToConfigBeanDelegate delegate = new DelegateToConfigBeanDelegate(cb);
        ObjectName parentObjectName = AMXConfigLoader.getActualParentObjectName(cb);
        if (parentObjectName == null) {
            if (amxInterface == DomainConfig.class) {
                parentObjectName = ObjectNames.getInstance().getDomainRootObjectName();
            } else {
                throw new IllegalArgumentException("All AMXConfig MBeans must have a parent!  No parent for " + cb.getProxyType().getName());
            }
        }
        AMXConfigImplBase impl = new AMXConfigImplBase(j2eeType, fullType, parentObjectName, amxInterface, supplementaryIntf, delegate);
        try {
            ObjectInstance instance = this.mMBeanServer.registerMBean(impl, objectNameIn);
            objectName = instance.getObjectName();
            cb.setObjectName(objectName);
        }
        catch (JMException e) {
            AMXConfigLoader.debug(ExceptionUtil.toString((Throwable)e));
            objectName = null;
        }
        return objectName;
    }

    private String getJ2EETypeField(Class<? extends AMXConfig> amxInterface) {
        String j2eeType = null;
        try {
            j2eeType = (String)ClassUtil.getFieldValue(amxInterface, (String)"J2EE_TYPE");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return j2eeType;
    }

    private String getJ2EEType(ConfigBean cb, AMXConfigInfo info) {
        Class amxInterface = info.amxInterface();
        String j2eeType = null;
        if (amxInterface != AMXConfig.class) {
            j2eeType = this.getJ2EETypeField(amxInterface);
        }
        if (j2eeType == null && (j2eeType = info.j2eeType()).length() == 0) {
            String configInterfaceName = cb.getProxyType().getName().replace(".", "_");
            j2eeType = "X-CFG-" + configInterfaceName;
            AMXConfigLoader.debug("Using DERIVED j2eeType of " + j2eeType + " for " + configInterfaceName);
        }
        assert (j2eeType != null && j2eeType.startsWith("X-"));
        if (j2eeType == null) {
            throw new RuntimeException("AMXConfigLoader.getJ2EEType: j2eeType is null");
        }
        if (!j2eeType.startsWith("X-")) {
            throw new RuntimeException("AMXConfigLoader.getJ2EEType: j2eeType just start with X-");
        }
        return j2eeType;
    }

    private String getName(ConfigBean cb, AMXConfigInfo info) {
        String name;
        String string = name = info.singleton() ? "na" : cb.rawAttribute(info.nameHint());
        if (name == null) {
            name = "BUG_NO_NAME_AVAILABLE";
        }
        return name;
    }

    private ObjectName buildObjectName(ConfigBean cb, AMXConfigInfo info) {
        ObjectName parentObjectName;
        String j2eeType = this.getJ2EEType(cb, info);
        String name = this.getName(cb, info);
        String parentProps = "";
        String domain = "amx";
        ConfigBean parent = AMXConfigLoader.getActualParent(cb);
        if (parent != null && (parentObjectName = parent.getObjectName()) != null) {
            domain = parentObjectName.getDomain();
            String ancestorProps = Util.getAdditionalProps((ObjectName)parentObjectName);
            String parentProp = info.omitAsAncestorInChildObjectName() ? "" : Util.getSelfProp((ObjectName)parentObjectName);
            parentProps = Util.concatenateProps((String)parentProp, (String)ancestorProps);
        }
        String requiredProps = Util.makeRequiredProps((String)j2eeType, (String)name);
        String allProps = Util.concatenateProps((String)requiredProps, (String)parentProps);
        ObjectName objectName = Util.newObjectName((String)domain, (String)allProps);
        return objectName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AMXConfigLoaderThread
    extends RunnableBase {
        private final LinkedBlockingQueue<ConfigBean> mQueue;
        volatile boolean mQuit;

        AMXConfigLoaderThread(LinkedBlockingQueue<ConfigBean> queue) {
            super("AMXConfigLoader.AMXConfigLoaderThread", null);
            this.mQuit = false;
            this.mQueue = queue;
        }

        void quit() {
            this.mQuit = true;
        }

        protected void doRun() throws Exception {
            while (!this.mQuit) {
                ConfigBean cb = this.mQueue.take();
                try {
                    if (cb.getObjectName() != null) continue;
                    AMXConfigLoader.this.registerConfigBeanAsMBean(cb);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

