/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.http.SelectorThread;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyObjectPool {
    private static long DEFAULT_TIMEOUT = 360L;
    private String jrubyLib = null;
    private int numberOfRuntime = 5;
    private BlockingQueue<Ruby> queue = new LinkedBlockingQueue<Ruby>();
    private String railsRoot = null;
    private boolean asyncEnabled = false;

    public Ruby borrowRuntime() {
        if (this.isAsyncEnabled()) {
            try {
                return this.queue.poll(DEFAULT_TIMEOUT, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return (Ruby)this.queue.poll();
    }

    public void returnRuntime(Ruby runtime) {
        this.queue.offer(runtime);
    }

    public void setJrubyLib(String jrubyLib) {
        this.jrubyLib = jrubyLib;
    }

    public void setNumberOfRuntime(int numberOfRuntime) {
        this.numberOfRuntime = numberOfRuntime;
    }

    public void setRailsRoot(String railsRoot) {
        this.railsRoot = railsRoot;
    }

    public void start() {
        try {
            if (this.jrubyLib == null || this.railsRoot == null) {
                throw new IllegalStateException("jrubyLib or railsRoot can not be null.");
            }
            int pnum = Runtime.getRuntime().availableProcessors();
            ExecutorService exec = Executors.newFixedThreadPool(pnum + 1);
            for (int i = 0; i < this.numberOfRuntime; ++i) {
                exec.execute(new Runnable(){

                    public void run() {
                        long startTime = System.currentTimeMillis();
                        Ruby runtime = RubyObjectPool.this.createRubyRuntimeInstance();
                        SelectorThread.logger().log(Level.INFO, "Rails instance instantiation took : " + (System.currentTimeMillis() - startTime) + "ms");
                        RubyObjectPool.this.queue.offer(runtime);
                    }
                });
            }
            exec.shutdown();
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void stop() {
        for (Ruby ruby : this.queue) {
            ruby.tearDown();
        }
        this.queue.clear();
    }

    private Ruby createRubyRuntimeInstance() {
        Ruby runtime = this.initializeRubyRuntime();
        this.loadRubyLibraries(runtime);
        IRubyObject responder = JavaEmbedUtils.newRuntimeAdapter().eval(runtime, this.getDispatcherString());
        runtime.defineReadonlyVariable("$responder", responder);
        return runtime;
    }

    protected Ruby initializeRubyRuntime() {
        ArrayList<String> libs = new ArrayList<String>();
        libs.add("META-INF/jruby.home/lib/ruby/site_ruby/1.8");
        return JavaEmbedUtils.initialize(libs);
    }

    protected void loadRubyLibraries(Ruby runtime) {
        LoadService loadService = runtime.getLoadService();
        loadService.require(this.railsRoot + "/config/environment");
        loadService.require("cgi/force_nph");
        loadService.require("dispatcher");
    }

    public String getJrubyLib() {
        return this.jrubyLib;
    }

    public int getNumberOfRuntime() {
        return this.numberOfRuntime;
    }

    public String getRailsRoot() {
        return this.railsRoot;
    }

    protected BlockingQueue<Ruby> getRubyRuntimeQueue() {
        return this.queue;
    }

    public boolean isAsyncEnabled() {
        return this.asyncEnabled;
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
        this.asyncEnabled = asyncEnabled;
    }

    private String getDispatcherString() {
        StringBuffer completeText = new StringBuffer();
        try {
            InputStream is = this.getClass().getResourceAsStream("/dispatch.rb");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String str = br.readLine();
            while (str != null) {
                completeText.append(str);
                completeText.append("\n");
                str = br.readLine();
            }
        }
        catch (Exception e) {
            SelectorThread.logger().log(Level.WARNING, "Exception when trying to read the dispatch.rb script", e);
        }
        return completeText.toString();
    }
}

