/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.beanutils.locale;

import com.sun.org.apache.commons.beanutils.BeanUtils;
import com.sun.org.apache.commons.beanutils.ConvertUtils;
import com.sun.org.apache.commons.beanutils.DynaBean;
import com.sun.org.apache.commons.beanutils.DynaClass;
import com.sun.org.apache.commons.beanutils.DynaProperty;
import com.sun.org.apache.commons.beanutils.MappedPropertyDescriptor;
import com.sun.org.apache.commons.beanutils.PropertyUtils;
import com.sun.org.apache.commons.beanutils.locale.LocaleConvertUtils;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;

public class LocaleBeanUtils
extends BeanUtils {
    private static Log log = LogFactory.getLog(LocaleBeanUtils.class);

    public static Locale getDefaultLocale() {
        return LocaleConvertUtils.getDefaultLocale();
    }

    public static void setDefaultLocale(Locale locale) {
        LocaleConvertUtils.setDefaultLocale(locale);
    }

    public static boolean getApplyLocalized() {
        return LocaleConvertUtils.getApplyLocalized();
    }

    public static void setApplyLocalized(boolean newApplyLocalized) {
        LocaleConvertUtils.setApplyLocalized(newApplyLocalized);
    }

    public static String getIndexedProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getIndexedProperty(bean, name);
        return LocaleConvertUtils.convert(value, pattern);
    }

    public static String getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return LocaleBeanUtils.getIndexedProperty(bean, name, null);
    }

    public static String getIndexedProperty(Object bean, String name, int index, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getIndexedProperty(bean, name, index);
        return LocaleConvertUtils.convert(value, pattern);
    }

    public static String getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return LocaleBeanUtils.getIndexedProperty(bean, name, index, null);
    }

    public static String getSimpleProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getSimpleProperty(bean, name);
        return LocaleConvertUtils.convert(value, pattern);
    }

    public static String getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return LocaleBeanUtils.getSimpleProperty(bean, name, null);
    }

    public static String getMappedProperty(Object bean, String name, String key, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getMappedProperty(bean, name, key);
        return LocaleConvertUtils.convert(value, pattern);
    }

    public static String getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return LocaleBeanUtils.getMappedProperty(bean, name, key, null);
    }

    public static String getMappedPropertyLocale(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getMappedProperty(bean, name);
        return LocaleConvertUtils.convert(value, pattern);
    }

    public static String getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return LocaleBeanUtils.getMappedPropertyLocale(bean, name, null);
    }

    public static String getNestedProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getNestedProperty(bean, name);
        return LocaleConvertUtils.convert(value, pattern);
    }

    public static String getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return LocaleBeanUtils.getNestedProperty(bean, name, null);
    }

    public static String getProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return LocaleBeanUtils.getNestedProperty(bean, name, pattern);
    }

    public static String getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return LocaleBeanUtils.getNestedProperty(bean, name);
    }

    public static void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        LocaleBeanUtils.setProperty(bean, name, value, null);
    }

    public static void setProperty(Object bean, String name, Object value, String pattern) throws IllegalAccessException, InvocationTargetException {
        Class type;
        Descriptor propInfo;
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer("  setProperty(");
            sb.append(bean);
            sb.append(", ");
            sb.append(name);
            sb.append(", ");
            if (value == null) {
                sb.append("<NULL>");
            } else if (value instanceof String) {
                sb.append((String)value);
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                sb.append('[');
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(values[i]);
                }
                sb.append(']');
            } else {
                sb.append(value.toString());
            }
            sb.append(')');
            log.trace((Object)sb.toString());
        }
        if ((propInfo = LocaleBeanUtils.calculate(bean, name)) != null && (type = LocaleBeanUtils.definePropertyType(propInfo.getTarget(), name, propInfo.getPropName())) != null) {
            Object newValue = LocaleBeanUtils.convert(type, propInfo.getIndex(), value, pattern);
            LocaleBeanUtils.invokeSetter(propInfo.getTarget(), propInfo.getPropName(), propInfo.getKey(), propInfo.getIndex(), newValue);
        }
    }

    protected static Class definePropertyType(Object target, String name, String propName) throws IllegalAccessException, InvocationTargetException {
        Class<Object> type = null;
        if (target instanceof DynaBean) {
            DynaClass dynaClass = ((DynaBean)target).getDynaClass();
            DynaProperty dynaProperty = dynaClass.getDynaProperty(propName);
            if (dynaProperty == null) {
                return null;
            }
            type = dynaProperty.getType();
        } else {
            PropertyDescriptor descriptor = null;
            try {
                descriptor = PropertyUtils.getPropertyDescriptor(target, name);
                if (descriptor == null) {
                    return null;
                }
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            type = descriptor instanceof MappedPropertyDescriptor ? ((MappedPropertyDescriptor)descriptor).getMappedPropertyType() : (descriptor instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType() : descriptor.getPropertyType());
        }
        return type;
    }

    protected static Object convert(Class type, int index, Object value, String pattern) {
        Object newValue = null;
        if (type.isArray() && index < 0) {
            if (value instanceof String) {
                String[] values = new String[]{(String)value};
                newValue = LocaleConvertUtils.convert(values, type, pattern);
            } else {
                newValue = value instanceof String[] ? LocaleConvertUtils.convert((String[])value, type, pattern) : value;
            }
        } else {
            newValue = type.isArray() ? (value instanceof String ? LocaleConvertUtils.convert((String)value, type.getComponentType(), pattern) : (value instanceof String[] ? LocaleConvertUtils.convert(((String[])value)[0], type.getComponentType(), pattern) : value)) : (value instanceof String ? LocaleConvertUtils.convert((String)value, type, pattern) : (value instanceof String[] ? LocaleConvertUtils.convert(((String[])value)[0], type, pattern) : value));
        }
        return newValue;
    }

    protected static Object convert(Class type, int index, Object value) {
        Object newValue = null;
        if (type.isArray() && index < 0) {
            if (value instanceof String) {
                String[] values = new String[]{(String)value};
                newValue = ConvertUtils.convert(values, type);
            } else {
                newValue = value instanceof String[] ? ConvertUtils.convert((String[])value, type) : value;
            }
        } else {
            newValue = type.isArray() ? (value instanceof String ? ConvertUtils.convert((String)value, type.getComponentType()) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], type.getComponentType()) : value)) : (value instanceof String ? ConvertUtils.convert((String)value, type) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], type) : value));
        }
        return newValue;
    }

    protected static void invokeSetter(Object target, String propName, String key, int index, Object newValue) throws IllegalAccessException, InvocationTargetException {
        try {
            if (index >= 0) {
                PropertyUtils.setIndexedProperty(target, propName, index, newValue);
            } else if (key != null) {
                PropertyUtils.setMappedProperty(target, propName, key, newValue);
            } else {
                PropertyUtils.setProperty(target, propName, newValue);
            }
        }
        catch (NoSuchMethodException e) {
            throw new InvocationTargetException(e, "Cannot set " + propName);
        }
    }

    protected static Descriptor calculate(Object bean, String name) throws IllegalAccessException, InvocationTargetException {
        int j;
        int i;
        String propName = null;
        int index = -1;
        String key = null;
        Object target = bean;
        int delim = name.lastIndexOf(46);
        if (delim >= 0) {
            try {
                target = PropertyUtils.getProperty(bean, name.substring(0, delim));
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            name = name.substring(delim + 1);
            if (log.isTraceEnabled()) {
                log.trace((Object)("    Target bean = " + target));
                log.trace((Object)("    Target name = " + name));
            }
        }
        if ((i = (propName = name).indexOf(91)) >= 0) {
            int k = propName.indexOf(93);
            try {
                index = Integer.parseInt(propName.substring(i + 1, k));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            propName = propName.substring(0, i);
        }
        if ((j = propName.indexOf(40)) >= 0) {
            int k = propName.indexOf(41);
            try {
                key = propName.substring(j + 1, k);
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            propName = propName.substring(0, j);
        }
        return new Descriptor(target, name, propName, key, index);
    }

    protected static class Descriptor {
        private int index = -1;
        private String name;
        private String propName;
        private String key;
        private Object target;

        public Descriptor(Object target, String name, String propName, String key, int index) {
            this.setTarget(target);
            this.setName(name);
            this.setPropName(propName);
            this.setKey(key);
            this.setIndex(index);
        }

        public Object getTarget() {
            return this.target;
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPropName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }
    }
}

