/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.container.common.spi.JavaEETransactionManager;
import com.sun.enterprise.transaction.JavaEETransaction;
import com.sun.enterprise.util.i18n.StringManager;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry {
    @Inject
    private transient JavaEETransactionManager transactionManager;
    private static StringManager sm = StringManager.getManager(TransactionSynchronizationRegistryImpl.class);

    public Object getTransactionKey() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException ex) {
            return null;
        }
    }

    public void putResource(Object key, Object value) {
        try {
            JavaEETransaction tran = (JavaEETransaction)this.transactionManager.getTransaction();
            if (tran == null) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
            }
            tran.putUserResource(key, value);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public Object getResource(Object key) {
        try {
            JavaEETransaction tran = (JavaEETransaction)this.transactionManager.getTransaction();
            if (tran == null) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
            }
            return tran.getUserResource(key);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        try {
            JavaEETransaction tran = (JavaEETransaction)this.transactionManager.getTransaction();
            if (tran == null) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
            }
            tran.registerInterposedSynchronization(sync);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public int getTransactionStatus() {
        try {
            return this.transactionManager.getStatus();
        }
        catch (SystemException ex) {
            return 6;
        }
    }

    public void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public boolean getRollbackOnly() {
        int status = this.getTransactionStatus();
        if (status == 6) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
        return status == 1 || status == 9;
    }
}

