/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.bootstrap;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import com.sun.enterprise.module.impl.HK2Factory;
import com.sun.enterprise.module.impl.Utils;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.KeyValuePairParser;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

public class Main {
    public static void main(String[] args) {
        new Main().run(args);
    }

    public Main() {
        HK2Factory.initialize();
    }

    public void run(final String[] args) {
        try {
            final Main main = this;
            Thread thread = new Thread(){

                public void run() {
                    try {
                        main.start(args);
                    }
                    catch (BootException e) {
                        e.printStackTrace();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected File getBootstrapFile() throws BootException {
        String resourceName = this.getClass().getName().replace(".", "/") + ".class";
        URL resource = this.getClass().getClassLoader().getResource(resourceName);
        if (resource == null) {
            throw new BootException("Cannot get bootstrap path from " + resourceName + " class location, aborting");
        }
        if (resource.getProtocol().equals("jar")) {
            try {
                JarURLConnection c = (JarURLConnection)resource.openConnection();
                URL jarFile = c.getJarFileURL();
                File f = new File(jarFile.toURI());
                return f;
            }
            catch (IOException e) {
                throw new BootException("Cannot open bootstrap jar file", e);
            }
            catch (URISyntaxException e) {
                throw new BootException("Incorrect bootstrap class URI", e);
            }
        }
        throw new BootException("Don't support packaging " + resource + " , please contribute !");
    }

    public void start(String[] args) throws BootException {
        Manifest mf;
        File bootstrap = this.getBootstrapFile();
        File root = bootstrap.getAbsoluteFile().getParentFile();
        if (root == null) {
            throw new BootException("Cannot find root installation from " + bootstrap);
        }
        String targetModule = this.findMainModuleName(bootstrap);
        ModulesRegistry mr = AbstractFactory.getInstance().createModulesRegistry();
        try {
            mf = new JarFile(bootstrap).getManifest();
        }
        catch (IOException e) {
            throw new BootException("Failed to read manifest from " + bootstrap);
        }
        this.createRepository(root, bootstrap, mf, mr);
        StartupContext context = new StartupContext(root, args);
        this.launch(mr, targetModule, context);
    }

    protected void setParentClassLoader(StartupContext context, ModulesRegistry mr) throws BootException {
        mr.setParentClassLoader(this.getClass().getClassLoader());
    }

    protected void createRepository(File root, File bootstrapJar, Manifest mf, ModulesRegistry mr) throws BootException {
        String repos = mf.getMainAttributes().getValue("HK2-Repositories");
        if (repos != null) {
            StringTokenizer st = new StringTokenizer(repos);
            while (st.hasMoreTokens()) {
                String repoInfo;
                String repoId = st.nextToken();
                String repoKey = "HK2-Repository-" + repoId;
                try {
                    repoInfo = mf.getMainAttributes().getValue(repoKey);
                }
                catch (Exception e) {
                    throw new BootException("Invalid repository id " + repoId + " in " + bootstrapJar, e);
                }
                if (repoInfo == null) continue;
                this.addRepo(root, repoId, repoInfo, mr);
            }
        } else {
            this.addRepo(root, "lib", "uri=. type=directory", mr);
        }
    }

    private void addRepo(File root, String repoId, String repoInfo, ModulesRegistry mr) throws BootException {
        StringTokenizer st = new StringTokenizer(repoInfo);
        Properties props = new Properties();
        Pattern p = Pattern.compile("([^=]*)=(.*)");
        while (st.hasMoreTokens()) {
            Matcher m = p.matcher(st.nextToken());
            if (!m.matches()) continue;
            props.put(m.group(1), m.group(2));
        }
        String uri = props.getProperty("uri");
        if (uri == null) {
            uri = ".";
        }
        String type = props.getProperty("type");
        String weight = props.getProperty("weight");
        if ("directory".equalsIgnoreCase(type)) {
            File location = new File(uri);
            if (!location.isAbsolute()) {
                location = new File(root, uri);
            }
            if (!location.exists()) {
                throw new BootException("Non-existent directory: " + location);
            }
            try {
                DirectoryBasedRepository repo = new DirectoryBasedRepository(repoId, location);
                this.addRepo(repo, mr, weight);
            }
            catch (IOException e) {
                throw new BootException("Exception while adding " + repoId + " repository", e);
            }
        } else {
            throw new BootException("Invalid attributes for modules repository " + repoId + " : " + repoInfo);
        }
    }

    protected void addRepo(Repository repo, ModulesRegistry mr, String weight) throws IOException {
        repo.initialize();
        int iWeight = 50;
        if (weight != null) {
            try {
                iWeight = Integer.parseInt(weight);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        repo.initialize();
        mr.addRepository(repo, iWeight);
    }

    public void launch(ModulesRegistry registry, StartupContext context) throws BootException {
        this.launch(registry, null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(ModulesRegistry registry, String mainModuleName, StartupContext context) throws BootException {
        ModuleStartup startupCode;
        Module mainModule;
        String habitatName = "default";
        this.setParentClassLoader(context, registry);
        Habitat mgr = registry.newHabitat();
        mgr.add((Inhabitant)new ExistingSingletonInhabitant((Object)context));
        mgr.add((Inhabitant)new ExistingSingletonInhabitant((Object)Logger.global));
        mgr.add((Inhabitant)new ExistingSingletonInhabitant(ModulesRegistry.class, (Object)registry));
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            registry.createHabitat("default", mgr);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        if (mainModuleName != null) {
            mainModule = registry.makeModuleFor(mainModuleName, null);
            if (mainModule == null) {
                if (registry.getModules().isEmpty()) {
                    throw new BootException("Registry has no module at all");
                }
                throw new BootException("Cannot find main module " + mainModuleName + " : no such module");
            }
            String targetClassName = this.findModuleStartup(mainModule, "default");
            if (targetClassName == null) {
                throw new BootException("Cannot find a ModuleStartup implementation in the META-INF/services/com.sun.enterprise.v3.ModuleStartup file, aborting");
            }
            Class<ModuleStartup> targetClass = null;
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(mainModule.getClassLoader());
            try {
                targetClass = mainModule.getClassLoader().loadClass(targetClassName).asSubclass(ModuleStartup.class);
                startupCode = (ModuleStartup)mgr.getComponent(targetClass);
            }
            catch (ClassNotFoundException e) {
                throw new BootException("Unable to load " + targetClassName, e);
            }
            catch (ComponentException e) {
                throw new BootException("Unable to load " + targetClass, e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCL);
            }
        } else {
            Collection startups = mgr.getAllByContract(ModuleStartup.class);
            if (startups.isEmpty()) {
                throw new BootException("No module has ModuleStartup");
            }
            if (startups.size() > 1) {
                Iterator itr = startups.iterator();
                ModuleStartup a = (ModuleStartup)itr.next();
                ModuleStartup b = (ModuleStartup)itr.next();
                Module am = registry.find(a.getClass());
                Module bm = registry.find(b.getClass());
                throw new BootException(String.format("Multiple ModuleStartup found: %s from %s and %s from %s", a, am, b, bm));
            }
            startupCode = (ModuleStartup)startups.iterator().next();
            mainModule = registry.find(startupCode.getClass());
        }
        mainModule.setSticky(true);
        this.launch(startupCode, context, mainModule);
    }

    protected String findMainModuleName(File bootstrap) throws BootException {
        String targetModule;
        try {
            JarFile jarFile = new JarFile(bootstrap);
            Manifest manifest = jarFile.getManifest();
            Attributes attr = manifest.getMainAttributes();
            targetModule = attr.getValue("HK2-Main-Bundle");
            if (targetModule == null) {
                Utils.getDefaultLogger().warning("No Main-Bundle module found in manifest of " + bootstrap.getAbsoluteFile());
            }
        }
        catch (IOException ioe) {
            throw new BootException("Cannot get manifest from " + bootstrap.getAbsolutePath(), ioe);
        }
        return targetModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launch(ModuleStartup startupCode, StartupContext context, Module mainModule) throws BootException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            startupCode.setStartupContext(context);
            Thread.currentThread().setContextClassLoader(mainModule.getClassLoader());
            startupCode.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    protected String findModuleStartup(Module mainModule, String habitatName) throws BootException {
        for (ModuleMetadata.InhabitantsDescriptor d : mainModule.getMetadata().getHabitats(habitatName)) {
            try {
                for (KeyValuePairParser kvpp : d.createScanner()) {
                    for (String v : kvpp.findAll("index")) {
                        if (!v.equals(ModuleStartup.class.getName())) continue;
                        kvpp.rewind();
                        return kvpp.find("class");
                    }
                }
            }
            catch (IOException e) {
                throw new BootException("Failed to parse " + d.systemId, e);
            }
        }
        throw new BootException("No " + ModuleStartup.class.getName() + " in " + mainModule);
    }
}

