/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.container;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.container.AsyncConnectionImpl;
import com.sun.grizzly.container.GrizzletRequest;
import com.sun.grizzly.container.GrizzletResponse;
import com.sun.grizzly.grizzlet.Grizzlet;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;

public class GrizzletAdapter
extends StaticResourcesAdapter
implements Adapter {
    public static final int ADAPTER_NOTES = 1;
    public static final int POST = 6312;
    public static final int GRIZZLET = 2;
    private String cometContextName = "/comet";
    private ReentrantLock initializedLock = new ReentrantLock();
    private Grizzlet grizzlet;

    public GrizzletAdapter() {
    }

    public GrizzletAdapter(String cometContextName) {
        this.cometContextName = cometContextName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, Response res) throws Exception {
        MessageBytes mb = req.requestURI();
        ByteChunk requestURI = mb.getByteChunk();
        String uri = req.requestURI().toString();
        File file = new File(this.getRootFolder(), uri);
        if (file.isDirectory()) {
            uri = uri + "index.html";
            file = new File(file, uri);
        }
        if (file.canRead()) {
            super.service(req, res);
            return;
        }
        CometEngine cometEngine = CometEngine.getEngine();
        CometContext cometContext = cometEngine.getCometContext(this.cometContextName);
        this.initializedLock.lock();
        try {
            if (cometContext == null) {
                cometContext = cometEngine.register(this.cometContextName);
                cometContext.setExpirationDelay(-1L);
                cometContext.setBlockingNotification(true);
            }
        }
        finally {
            this.initializedLock.unlock();
        }
        GrizzletRequest cometReq = (GrizzletRequest)((Object)req.getNote(1));
        GrizzletResponse cometRes = (GrizzletResponse)((Object)res.getNote(1));
        AsyncConnectionImpl asyncConnection = (AsyncConnectionImpl)req.getNote(2);
        if (cometReq == null) {
            cometReq = new GrizzletRequest(req);
            cometRes = new GrizzletResponse(res);
            cometReq.setGrizzletResponse(cometRes);
            asyncConnection = new AsyncConnectionImpl();
            req.setNote(1, (Object)cometReq);
            req.setNote(2, (Object)asyncConnection);
            res.setNote(1, (Object)cometRes);
        } else {
            cometReq.setRequest(req);
            cometRes.setResponse(res);
        }
        asyncConnection.setCometContext(cometContext);
        asyncConnection.setRequest(cometReq);
        asyncConnection.setResponse(cometRes);
        asyncConnection.setGrizzlet(this.grizzlet);
        try {
            this.grizzlet.onRequest(asyncConnection);
        }
        finally {
            cometReq.recycle();
            cometRes.recycle();
            asyncConnection.recycle();
        }
    }

    public void afterService(Request req, Response res) throws Exception {
        try {
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        res.finish();
        super.afterService(req, res);
    }

    public Grizzlet getGrizzlet() {
        return this.grizzlet;
    }

    public void setGrizzlet(Grizzlet grizzlet) {
        this.grizzlet = grizzlet;
    }

    public String getCometContextName() {
        return this.cometContextName;
    }

    public void setCometContextName(String cometContextName) {
        this.cometContextName = cometContextName;
    }
}

