/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.container.GrizzletAdapter;
import com.sun.grizzly.grizzlet.Grizzlet;
import com.sun.grizzly.http.AsyncFilter;
import com.sun.grizzly.http.AsyncHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.ExpandJar;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public class GrizzletContainer {
    private static final String SELECTOR_THREAD = "com.sun.grizzly.selectorThread";
    private static final String ADAPTER = "com.sun.grizzly.adapterClass";
    private static int port = 8080;
    private static String folder = ".";
    private static String grizzletClassName;
    private static String applicationLoc;

    public static void main(String[] args) throws Exception {
        GrizzletContainer main = new GrizzletContainer();
        GrizzletContainer.start(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start(String[] args) throws Exception {
        long t1 = System.currentTimeMillis();
        if (args.length == 0) {
            GrizzletContainer.printHelpAndExit();
        }
        for (int i = 0; i < args.length - 1; ++i) {
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                GrizzletContainer.printHelpAndExit();
                continue;
            }
            if ("-a".equals(arg)) {
                applicationLoc = args[++i];
                continue;
            }
            if (arg.startsWith("--application=")) {
                applicationLoc = arg.substring("--application=".length(), arg.length());
                continue;
            }
            if ("-p".equals(arg)) {
                GrizzletContainer.setPort(args[++i]);
                continue;
            }
            if (!arg.startsWith("--port=")) continue;
            String num = arg.substring("--port=".length(), arg.length());
            GrizzletContainer.setPort(num);
        }
        grizzletClassName = args[args.length - 1];
        if (grizzletClassName == null) {
            System.err.println("Illegal Grizzlet name.");
            GrizzletContainer.printHelpAndExit();
        }
        if (new File("lib").exists()) {
            Thread.currentThread().setContextClassLoader(ClassLoaderUtil.createClassloader((File)new File("lib"), (ClassLoader)GrizzletContainer.class.getClassLoader()));
        }
        if (applicationLoc.endsWith(".war") || applicationLoc.endsWith(".jar")) {
            File file = new File(applicationLoc);
            URL url = new URL("jar:file:" + file.getCanonicalPath() + "!/");
            folder = ExpandJar.expand((URL)url);
        } else {
            folder = applicationLoc;
        }
        System.out.println("Running Grizzlet from: " + folder);
        URL classesURL = new URL("file://" + folder + "/WEB-INF/classes/");
        URL[] urls = new URL[]{classesURL};
        URLClassLoader urlClassloader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(urlClassloader);
        final SelectorThread selectorThread = new SelectorThread();
        selectorThread.setAlgorithmClassName(StaticStreamAlgorithm.class.getName());
        selectorThread.setPort(port);
        SelectorThread.setWebAppRootPath((String)folder);
        selectorThread.setMaxThreads(5);
        selectorThread.setDisplayConfiguration(false);
        selectorThread.setEnableAsyncExecution(true);
        selectorThread.setBufferResponse(false);
        selectorThread.setFileCacheIsEnabled(false);
        selectorThread.setLargeFileCacheEnabled(false);
        DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
        asyncHandler.addAsyncFilter((AsyncFilter)new CometAsyncFilter());
        selectorThread.setAsyncHandler((AsyncHandler)asyncHandler);
        GrizzletAdapter adapter = new GrizzletAdapter("/comet");
        adapter.setRootFolder(folder);
        selectorThread.setAdapter((Adapter)adapter);
        Grizzlet grizzlet = (Grizzlet)GrizzletContainer.loadInstance(grizzletClassName);
        if (grizzlet == null) {
            throw new IllegalStateException("Invalid Grizzlet ClassName");
        }
        System.out.println("Launching Grizzlet: " + grizzlet.getClass().getName());
        adapter.setGrizzlet(grizzlet);
        selectorThread.initEndpoint();
        new Thread(){

            public void run() {
                try {
                    selectorThread.startEndpoint();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }.start();
        System.out.println("Server startup in " + (System.currentTimeMillis() - t1) + " ms");
        SelectorThread selectorThread2 = selectorThread;
        synchronized (selectorThread2) {
            try {
                selectorThread.wait();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static void setPort(String num) {
        try {
            port = Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal port number -- " + num);
            GrizzletContainer.printHelpAndExit();
        }
    }

    private static void printHelpAndExit() {
        System.err.println("Usage: " + GrizzletContainer.class.getCanonicalName() + " [options] GRIZZLET_NAME");
        System.err.println();
        System.err.println("    -p, --port=port                  Runs GrizzletContainer on the specified port.");
        System.err.println("                                     Default: 8080");
        System.err.println("    -a, --apps=application path      The Grizzlet folder or jar or war location.");
        System.err.println("                                     Default: .");
        System.err.println("    -h, --help                       Show this help message.");
        System.exit(1);
    }

    private static Object loadInstance(String clazzName) {
        Class<?> className = null;
        try {
            className = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            return className.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

