/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.connectors.PoolMetaData;
import java.io.Serializable;

public class ResourceSpec
implements Serializable {
    private String resourceId;
    private int resourceIdType;
    private boolean pmResource;
    private boolean nonTxResource;
    private boolean isXA_;
    private String connectionPoolName;
    public static final int JDBC_URL = 0;
    public static final int JNDI_NAME = 1;
    public static final int JMS = 2;

    public ResourceSpec(String resourceId, int resourceIdType) {
        if (resourceId == null) {
            throw new NullPointerException();
        }
        this.resourceId = resourceId;
        this.resourceIdType = resourceIdType;
        if (resourceId.endsWith("__nontx")) {
            this.nonTxResource = true;
        }
        if (resourceId.endsWith("__pm")) {
            this.pmResource = true;
        }
    }

    public ResourceSpec(String resourceId, int resourceIdType, PoolMetaData pmd) {
        this(resourceId, resourceIdType);
        if (pmd.isPM()) {
            this.pmResource = true;
        }
        if (pmd.isNonTx()) {
            this.nonTxResource = true;
        }
    }

    public String getConnectionPoolName() {
        return this.connectionPoolName;
    }

    public void setConnectionPoolName(String name) {
        this.connectionPoolName = name;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ResourceSpec) {
            ResourceSpec obj = (ResourceSpec)other;
            if (this.connectionPoolName == null) {
                return this.resourceId.equals(obj.resourceId) && this.resourceIdType == obj.resourceIdType;
            }
            return this.connectionPoolName.equals(obj.connectionPoolName);
        }
        return false;
    }

    public int hashCode() {
        if (this.connectionPoolName == null) {
            return this.resourceId.hashCode() + this.resourceIdType;
        }
        return this.connectionPoolName.hashCode();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public boolean isPM() {
        return this.pmResource;
    }

    public boolean isNonTx() {
        return this.nonTxResource;
    }

    public boolean isXA() {
        return this.isXA_;
    }

    public void markAsXA() {
        this.isXA_ = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ResourceSpec :- ");
        sb.append("\nconnectionPoolName : ").append(this.connectionPoolName);
        sb.append("\nisXA_ : ").append(this.isXA_);
        sb.append("\nresoureId : ").append(this.resourceId);
        sb.append("\nresoureIdType : ").append(this.resourceIdType);
        sb.append("\npmResource : ").append(this.pmResource);
        sb.append("\nnonTxResource : ").append(this.nonTxResource);
        return sb.toString();
    }
}

