/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.spi.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class JdbcResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager(JdbcResourceDeployer.class);
    private static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core");

    public synchronized void deployResource(Object resource) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        String jndiName = jdbcRes.getJndiName();
        String poolName = jdbcRes.getPoolName();
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        runtime.createConnectorResource(jndiName, poolName, null);
        if (ConnectorsUtil.getValidSuffix((String)jndiName) == null) {
            runtime.createConnectorResource(ConnectorsUtil.getPMJndiName((String)jndiName), poolName, null);
        }
        _logger.finest("deployed resource " + jndiName);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        String jndiName = jdbcRes.getJndiName();
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        runtime.deleteConnectorResource(jndiName);
        if (ConnectorsUtil.getValidSuffix((String)jndiName) == null) {
            runtime.deleteConnectorResource(ConnectorsUtil.getPMJndiName((String)jndiName));
        }
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }
}

