/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.server.Globals;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.VirtualServerPipeline;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.web.stats.PWCRequestStatsImpl;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualServer
extends StandardHost {
    public static final String ADMIN_VS = "__asadmin";
    static final String STATE = "state";
    static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    static final String DISABLED = "disabled";
    static final String OFF = "off";
    static final String ON = "on";
    private VirtualServerPipeline vsPipeline;
    private Pipeline origPipeline = this.pipeline;
    private String _id = null;
    protected static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle _rb = _logger.getResourceBundle();
    protected boolean _debug = false;
    private static final String _info = "com.sun.enterprise.web.VirtualServer/1.0";
    private com.sun.enterprise.config.serverbeans.VirtualServer vsBean;
    private MimeMap mimeMap;
    private boolean allowLinking = false;
    private String defaultContextXmlLocation;
    private String defaultWebXmlLocation;
    private String[] cacheControls;
    private boolean isActive;
    private PWCRequestStatsImpl pwcRequestStatsImpl;
    private String authRealmName;
    private PEAccessLogValve accessLogValve;
    private HashMap<String, String> alternateDocBasesMap = null;

    public VirtualServer() {
        this.vsPipeline = new VirtualServerPipeline(this);
        this.accessLogValve = new PEAccessLogValve();
        this._debug = _logger.isLoggable(Level.FINE);
    }

    public String getID() {
        return this._id;
    }

    public void setID(String id) {
        this._id = id;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
        if (isActive) {
            this.vsPipeline.setIsDisabled(false);
            this.vsPipeline.setIsOff(false);
            if (this.pipeline == this.vsPipeline && !this.vsPipeline.hasRedirects()) {
                this.setPipeline(this.origPipeline);
            }
        }
    }

    public String getDefaultContextXmlLocation() {
        return this.defaultContextXmlLocation;
    }

    public void setDefaultContextXmlLocation(String defaultContextXmlLocation) {
        this.defaultContextXmlLocation = defaultContextXmlLocation;
    }

    public String getDefaultWebXmlLocation() {
        return this.defaultWebXmlLocation;
    }

    public void setDefaultWebXmlLocation(String defaultWebXmlLocation) {
        this.defaultWebXmlLocation = defaultWebXmlLocation;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public com.sun.enterprise.config.serverbeans.VirtualServer getBean() {
        return this.vsBean;
    }

    public void setBean(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.vsBean = vsBean;
    }

    public MimeMap getMimeMap() {
        return this.mimeMap;
    }

    public void setMimeMap(MimeMap mimeMap) {
        this.mimeMap = mimeMap;
    }

    public String[] getCacheControls() {
        return this.cacheControls;
    }

    public void setCacheControls(String[] cacheControls) {
        this.cacheControls = cacheControls;
    }

    @Override
    public String getInfo() {
        return _info;
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        super.stop();
    }

    @Override
    public synchronized void addValve(Valve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    @Override
    public synchronized void removeValve(Valve valve) {
        super.removeValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.removeValve(valve);
        } else {
            this.vsPipeline.removeValve(valve);
        }
    }

    protected String getDefaultContextPath(Server serverBean) {
        String contextRoot = null;
        Domain domain = (Domain)Globals.getDefaultHabitat().getComponent(Domain.class);
        Applications appsBean = domain.getApplications();
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null) {
            WebModule wm;
            WebModuleConfig wmInfo = this.findWebModuleInJ2eeApp(appsBean, wmID);
            if (wmInfo == null) {
                wm = (WebModule)ConfigBeansUtilities.getModule(WebModule.class, (Applications)appsBean, (String)wmID);
                if (wm != null) {
                    if (this.isActive(wm, false)) {
                        contextRoot = wm.getContextRoot();
                    } else {
                        Object[] params = new Object[]{wmID, this.getID()};
                        _logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", params);
                    }
                }
            } else {
                wm = wmInfo.getBean();
                contextRoot = wm.getContextRoot();
            }
            if (contextRoot == null) {
                Object[] params = new Object[]{wmID, this.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", params);
            }
        }
        return contextRoot;
    }

    protected WebModuleConfig createSystemDefaultWebModuleIfNecessary() {
        WebModuleConfig wmInfo = null;
        return wmInfo;
    }

    protected WebModuleConfig loadWebModuleConfig(WebModule wm) {
        WebModuleConfig wmInfo = new WebModuleConfig();
        wmInfo.setBean(wm);
        String wmID = wm.getName();
        String location = wm.getLocation();
        return wmInfo;
    }

    private boolean isActive(WebModule wm) {
        return this.isActive(wm, true);
    }

    protected boolean isActive(WebModule wm, boolean matchVSID) {
        String vsID = this.getID();
        boolean active = vsID != null && vsID.length() > 0;
        if (active &= wm != null) {
            List vsList;
            active &= Boolean.getBoolean(wm.getEnabled());
            String vsIDs = this.getVirtualServers(wm.getName());
            if (this.getID().equals(ADMIN_VS) && matchVSID && (vsIDs == null || vsIDs.length() == 0)) {
                return false;
            }
            active = matchVSID && vsIDs != null && vsIDs.length() > 0 ? ((vsList = StringUtils.parseStringList((String)vsIDs, (String)" ,")) != null ? (active &= vsList.contains(vsID.trim())) : (active &= true)) : (active &= true);
        }
        return active;
    }

    protected String getDefaultWebModuleID() {
        String wmID = null;
        if (this.vsBean != null) {
            wmID = this.vsBean.getDefaultWebModule();
            if (wmID != null && this._debug) {
                Object[] params = new Object[]{wmID, this._id};
                _logger.log(Level.FINE, "vs.defaultWebModule", params);
            }
        } else {
            _logger.log(Level.SEVERE, "vs.configError", this._id);
        }
        return wmID;
    }

    protected WebModuleConfig findWebModuleInJ2eeApp(Applications appsBean, String id) {
        WebModuleConfig wmInfo = null;
        return wmInfo;
    }

    private String getVirtualServers(String appName) {
        String ret = null;
        Server server = (Server)Globals.getDefaultHabitat().getComponent(Server.class);
        for (ApplicationRef appRef : server.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            return appRef.getVirtualServers();
        }
        return ret;
    }

    public void clearAliases() {
        this.aliases = new String[0];
    }

    private void setIsDisabled(boolean isDisabled) {
        this.vsPipeline.setIsDisabled(isDisabled);
        this.vsPipeline.setIsOff(false);
        if (isDisabled && this.pipeline != this.vsPipeline) {
            this.setPipeline(this.vsPipeline);
        }
    }

    private void setIsOff(boolean isOff) {
        this.vsPipeline.setIsOff(isOff);
        this.vsPipeline.setIsDisabled(false);
        if (isOff && this.pipeline != this.vsPipeline) {
            this.setPipeline(this.vsPipeline);
        }
    }

    List<Property> getProperties() {
        if (this.vsBean != null) {
            return this.vsBean.getProperty();
        }
        return null;
    }

    public void setPWCRequestStatsImpl(PWCRequestStatsImpl pwcRequestStatsImpl) {
        this.pwcRequestStatsImpl = pwcRequestStatsImpl;
    }

    public PWCRequestStatsImpl getPWCRequestStatsImpl() {
        return this.pwcRequestStatsImpl;
    }

    protected void configureCatalinaProperties() {
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullWebModuleProperty", this.getName());
            }
            if (propName.startsWith("valve_")) {
                this.addValve(propValue);
                continue;
            }
            if (propName.startsWith("listener_")) {
                this.addListener(propValue);
                continue;
            }
            if (!propName.equals("securePagesWithPragma")) continue;
            this.setSecurePagesWithPragma(Boolean.valueOf(propValue));
        }
    }

    void configureAliases() {
        List hosts = StringUtils.parseStringList((String)this.vsBean.getHosts(), (String)",");
        for (int i = 0; i < hosts.size(); ++i) {
            String alias = hosts.get(i).toString();
            if (alias.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(alias);
        }
    }

    void configureAuthRealm(SecurityService securityService) {
    }

    String getAuthRealmName() {
        return this.authRealmName;
    }

    protected void addValve(String valveName) {
        Valve valve = (Valve)this.loadInstance(valveName);
        if (valve == null) {
            return;
        }
        super.addValve(valve);
    }

    protected void addListener(String listenerName) {
        Object listener = this.loadInstance(listenerName);
        if (listener == null) {
            return;
        }
        if (listener instanceof ContainerListener) {
            this.addContainerListener((ContainerListener)listener);
        } else if (listener instanceof LifecycleListener) {
            this.addLifecycleListener((LifecycleListener)listener);
        } else {
            _logger.log(Level.SEVERE, "webcontainer.invalidListener" + listenerName);
        }
    }

    private Object loadInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "webcontainer.unableToLoadExtension", ex);
            return null;
        }
    }

    void configureAlternateDocBases() {
        if (this.vsBean == null) {
            return;
        }
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
            }
            if (!propName.startsWith("alternatedocroot_")) continue;
            String urlPattern = null;
            String docBase = null;
            String[] alternateDocBaseParams = propValue.split(" ");
            for (int j = 0; j < alternateDocBaseParams.length; ++j) {
                if (alternateDocBaseParams[j].startsWith("from=") && !this.validateURLPattern(urlPattern = alternateDocBaseParams[j].substring("from=".length()))) {
                    _logger.log(Level.SEVERE, "webcontainer.alternateDocBase.illegalUrlPattern", urlPattern);
                }
                if (!alternateDocBaseParams[j].startsWith("dir=")) continue;
                docBase = alternateDocBaseParams[j].substring("dir=".length());
            }
            this.addAlternateDocBase(urlPattern, docBase);
        }
    }

    private boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.indexOf(10) >= 0 || urlPattern.indexOf(13) >= 0) {
            _logger.log(Level.WARNING, "webcontainer.alternateDocBase.crlfInUrlPattern", urlPattern);
        }
        if (urlPattern.startsWith("*.")) {
            return urlPattern.indexOf(47) < 0;
        }
        return urlPattern.startsWith("/") && urlPattern.indexOf("*.") < 0;
    }

    void addAlternateDocBase(String urlPattern, String docBase) {
        if (urlPattern == null || docBase == null) {
            _logger.log(Level.SEVERE, "webcontainer.alternateDocBase.missingPathOrUrlPattern");
        }
        if (this.alternateDocBasesMap == null) {
            this.alternateDocBasesMap = new HashMap();
        }
        this.alternateDocBasesMap.put(urlPattern, docBase);
    }

    public HashMap<String, String> getAlternateDocBasesMap() {
        return this.alternateDocBasesMap;
    }

    void configureErrorPage() {
        ErrorPage errorPage = null;
        if (this.vsBean == null) {
            return;
        }
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
                continue;
            }
            if (!propName.startsWith("send-error_")) continue;
            String path = null;
            String reason = null;
            String status = null;
            String[] errorParams = propValue.split(" ");
            for (int j = 0; j < errorParams.length; ++j) {
                if (errorParams[j].startsWith("path=")) {
                    if (path != null) {
                        _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "path"});
                    }
                    path = errorParams[j].substring("path=".length());
                }
                if (errorParams[j].startsWith("reason=")) {
                    if (reason != null) {
                        _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "reason"});
                    }
                    reason = errorParams[j].substring("reason=".length());
                }
                if (!errorParams[j].startsWith("code=")) continue;
                if (status != null) {
                    _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "code"});
                }
                status = errorParams[j].substring("code=".length());
            }
            if (path == null || path.length() == 0) {
                _logger.log(Level.WARNING, "webcontainer.sendErrorMissingPath", propValue);
            }
            errorPage = new ErrorPage();
            errorPage.setLocation(path);
            errorPage.setErrorCode(status);
            errorPage.setReason(reason);
            this.addErrorPage(errorPage);
        }
    }

    void configureRedirect() {
        this.vsPipeline.clearRedirects();
        if (this.vsBean == null) {
            return;
        }
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
                continue;
            }
            if (!propName.startsWith("redirect_")) continue;
            String from = null;
            String url = null;
            String urlPrefix = null;
            String escape = null;
            String[] redirectParams = propValue.split(" ");
            for (int j = 0; j < redirectParams.length; ++j) {
                if (redirectParams[j].startsWith("from=")) {
                    if (from != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "from"});
                    }
                    from = redirectParams[j].substring("from=".length());
                }
                if (redirectParams[j].startsWith("url=")) {
                    if (url != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "url"});
                    }
                    url = redirectParams[j].substring("url=".length());
                }
                if (redirectParams[j].startsWith("url-prefix=")) {
                    if (urlPrefix != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "url-prefix"});
                    }
                    urlPrefix = redirectParams[j].substring("url-prefix=".length());
                }
                if (!redirectParams[j].startsWith("escape=")) continue;
                if (escape != null) {
                    _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "escape"});
                }
                escape = redirectParams[j].substring("escape=".length());
            }
            if (from == null || from.length() == 0) {
                _logger.log(Level.WARNING, "webcontainer.redirectMissingFrom", propValue);
            }
            if (!(url != null && url.length() != 0 || urlPrefix != null && urlPrefix.length() != 0)) {
                _logger.log(Level.WARNING, "webcontainer.redirectMissingUrlOrUrlPrefix", propValue);
            }
            if (url != null && url.length() > 0 && urlPrefix != null && urlPrefix.length() > 0) {
                _logger.log(Level.WARNING, "webcontainer.redirectBothUrlAndUrlPrefix", propValue);
            }
            boolean escapeURI = true;
            if (escape != null) {
                if ("yes".equalsIgnoreCase(escape)) {
                    escapeURI = true;
                } else if ("no".equalsIgnoreCase(escape)) {
                    escapeURI = false;
                } else {
                    _logger.log(Level.WARNING, "webcontainer.redirectInvalidEscape", propValue);
                }
            }
            this.vsPipeline.addRedirect(from, url, urlPrefix, escapeURI);
        }
        if (this.vsPipeline.hasRedirects()) {
            if (this.pipeline != this.vsPipeline) {
                this.setPipeline(this.vsPipeline);
            }
        } else if (this.isActive && this.pipeline != this.origPipeline) {
            this.setPipeline(this.origPipeline);
        }
    }

    void configureSSOValve(boolean globalSSOEnabled, WebContainerFeatureFactory webContainerFeatureFactory) {
        if (this.vsBean == null) {
            return;
        }
        if (!this.isSSOEnabled(globalSSOEnabled)) {
            Object[] params = new Object[]{this.getID()};
            _logger.log(Level.INFO, "webcontainer.ssodisabled", params);
            Valve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.removeValve(valves[i]);
                break;
            }
        } else {
            try {
                Property expireTime;
                SSOFactory ssoFactory = webContainerFeatureFactory.getSSOFactory();
                String vsName = this.getName();
                SingleSignOn sso = ssoFactory.createSingleSignOnValve(vsName);
                Property idle = this.getPropertyByName(SSO_MAX_IDLE);
                if (idle != null && idle.getValue() != null) {
                    _logger.fine("SSO entry max idle time set to: " + idle.getValue());
                    int i = Integer.parseInt(idle.getValue());
                    sso.setMaxInactive(i);
                }
                if ((expireTime = this.getPropertyByName(SSO_REAP_INTERVAL)) != null && expireTime.getValue() != null) {
                    _logger.fine("SSO expire thread interval set to : " + expireTime.getValue());
                    int i = Integer.parseInt(expireTime.getValue());
                    sso.setReapInterval(i);
                }
                Valve[] valves = this.getValves();
                for (int i = 0; valves != null && i < valves.length; ++i) {
                    if (!(valves[i] instanceof SingleSignOn)) continue;
                    this.removeValve(valves[i]);
                    break;
                }
                this.addValve(sso);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "webcontainer.ssobadconfig", e);
                _logger.log(Level.WARNING, "webcontainer.ssodisabled", this.getID());
            }
        }
    }

    private Property getPropertyByName(String name) {
        for (Property prop : this.vsBean.getProperty()) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    void configureVirtualServerState() {
        String stateValue = ON;
        if (this.vsBean != null) {
            stateValue = this.vsBean.getState();
        }
        if (!stateValue.equalsIgnoreCase(ON) && this.getName().equalsIgnoreCase(ADMIN_VS)) {
            throw new IllegalArgumentException("virtual-server __asadmin state property cannot be modified");
        }
        if (stateValue.equalsIgnoreCase(DISABLED)) {
            this.setIsDisabled(true);
        } else if (!Boolean.getBoolean(stateValue)) {
            this.setIsOff(true);
        } else {
            this.setIsActive(true);
        }
    }

    void configureRemoteAddressFilterValve() {
        RemoteAddrValve remoteAddrValve = null;
        if (this.vsBean == null) {
            return;
        }
        Property allow = this.getPropertyByName("allowRemoteAddress");
        Property deny = this.getPropertyByName("denyRemoteAddress");
        if (allow != null && allow.getValue() != null || deny != null && deny.getValue() != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allow != null && allow.getValue() != null) {
            _logger.fine("Allowing access to " + this.getID() + " from " + allow.getValue());
            remoteAddrValve.setAllow(allow.getValue());
        }
        if (deny != null && deny.getValue() != null) {
            _logger.fine("Denying access to " + this.getID() + " from " + deny.getValue());
            remoteAddrValve.setDeny(deny.getValue());
        }
        if (remoteAddrValve != null) {
            Valve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteAddrValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve(remoteAddrValve);
        }
    }

    void configureRemoteHostFilterValve(HttpProtocol httpProtocol) {
        RemoteHostValve remoteHostValve = null;
        if (this.vsBean == null) {
            return;
        }
        Property allow = this.getPropertyByName("allowRemoteHost");
        Property deny = this.getPropertyByName("denyRemoteHost");
        if (allow != null && allow.getValue() != null || deny != null && deny.getValue() != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allow != null && allow.getValue() != null) {
            _logger.fine("Allowing access to " + this.getID() + " from " + allow.getValue());
            if (httpProtocol == null || !Boolean.getBoolean(httpProtocol.getDnsLookupEnabled())) {
                _logger.log(Level.WARNING, "webcontainer.allowRemoteHost.dnsLookupDisabled", this.getID());
            }
            remoteHostValve.setAllow(allow.getValue());
        }
        if (deny != null && deny.getValue() != null) {
            _logger.fine("Denying access to " + this.getID() + " from " + deny.getValue());
            if (httpProtocol == null || !Boolean.getBoolean(httpProtocol.getDnsLookupEnabled())) {
                _logger.log(Level.WARNING, "webcontainer.denyRemoteHost.dnsLookupDisabled", this.getID());
            }
            remoteHostValve.setDeny(deny.getValue());
        }
        if (remoteHostValve != null) {
            Valve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteHostValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve(remoteHostValve);
        }
    }

    void reconfigureAccessLog(String globalAccessLogBufferSize, String globalAccessLogWriteInterval, Habitat habitat, Domain domain, boolean globalAccessLoggingEnabled) {
        try {
            boolean start;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
            }
            if ((start = this.accessLogValve.updateVirtualServerProperties(this.vsBean.getId(), this.vsBean, domain, habitat, globalAccessLogBufferSize, globalAccessLogWriteInterval)) && this.isAccessLoggingEnabled(globalAccessLoggingEnabled)) {
                this.enableAccessLogging();
            } else {
                this.disableAccessLogging();
            }
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
        }
    }

    void reconfigureAccessLog(HttpService httpService, WebContainerFeatureFactory webcontainerFeatureFactory) {
        try {
            boolean restart = false;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
                restart = true;
            }
            this.accessLogValve.updateAccessLogAttributes(httpService, webcontainerFeatureFactory);
            if (restart) {
                this.accessLogValve.start();
            }
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
        }
    }

    PEAccessLogValve getAccessLogValve() {
        return this.accessLogValve;
    }

    void enableAccessLogging() {
        if (!this.isAccessLogValveActivated()) {
            this.addValve(this.accessLogValve);
        } else {
            try {
                if (this.accessLogValve.isStarted()) {
                    this.accessLogValve.stop();
                }
                this.accessLogValve.start();
            }
            catch (LifecycleException le) {
                _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
            }
        }
    }

    void disableAccessLogging() {
        this.removeValve(this.accessLogValve);
    }

    private boolean isAccessLogValveActivated() {
        Valve[] valves;
        Pipeline p = this.getPipeline();
        if (p != null && (valves = p.getValves()) != null) {
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof PEAccessLogValve)) continue;
                return true;
            }
        }
        return false;
    }

    void configureCacheControl(String cacheControl) {
        List values;
        if (cacheControl != null && (values = StringUtils.parseStringList((String)cacheControl, (String)",")) != null && !values.isEmpty()) {
            String[] cacheControls = new String[values.size()];
            this.setCacheControls(values.toArray(cacheControls));
        }
    }

    private boolean isSSOEnabled(boolean globalSSOEnabled) {
        Property ssoProperty = this.getPropertyByName("sso-enabled");
        if (ssoProperty == null || ssoProperty.getValue() == null) {
            return globalSSOEnabled;
        }
        return ConfigBeansUtilities.toBoolean((String)ssoProperty.getValue());
    }

    boolean isAccessLoggingEnabled(boolean globalAccessLoggingEnabled) {
        Property prop = ConfigBeansUtilities.getPropertyByName((Object)this.vsBean, (String)"accessLoggingEnabled");
        if (prop == null || prop.getValue() == null) {
            return globalAccessLoggingEnabled;
        }
        return ConfigBeansUtilities.toBoolean((String)prop.getValue());
    }
}

