/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.v3.contract.ApplicationMetaDataPersistence;
import com.sun.enterprise.v3.server.V3Environment;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class DefaultMetaDataPersistence
implements ApplicationMetaDataPersistence {
    @Inject
    V3Environment env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String name, Properties moduleProps) {
        File generatedAppRoot = new File(this.env.getApplicationStubPath(), name);
        OutputStream os = null;
        File propFile = null;
        try {
            if (!generatedAppRoot.exists()) {
                generatedAppRoot.mkdirs();
            }
            propFile = new File(generatedAppRoot, "glassfish.props");
            os = new BufferedOutputStream(new FileOutputStream(propFile));
            moduleProps.store(os, "GlassFish container properties");
        }
        catch (IOException ioe) {
            LogDomains.getLogger((String)"javax.enterprise.system.tools.deployment").severe("IOException while saving module properties : " + ioe.getMessage());
            try {
                if (os != null) {
                    os.close();
                }
                if (propFile.exists()) {
                    propFile.delete();
                }
                if (generatedAppRoot.exists()) {
                    generatedAppRoot.delete();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties load(String appName) {
        File appRoot = new File(this.env.getApplicationStubPath(), appName);
        File propertiesFile = new File(appRoot, "glassfish.props");
        if (propertiesFile.exists()) {
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(propertiesFile));
                props.load(is);
            }
            catch (IOException ioe) {
                LogDomains.getLogger((String)"javax.enterprise.system.tools.deployment").log(Level.SEVERE, "Cannot load appserver meta information about " + appRoot.getName(), ioe);
                Properties properties = null;
                return properties;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
            return props;
        }
        return null;
    }
}

