/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.Tokenizer;
import com.sun.enterprise.module.impl.ClassLoaderProxy;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.data.ApplicationInfo;
import com.sun.enterprise.v3.data.ApplicationRegistry;
import com.sun.enterprise.v3.data.ContainerInfo;
import com.sun.enterprise.v3.data.ContainerRegistry;
import com.sun.enterprise.v3.data.ModuleInfo;
import com.sun.enterprise.v3.deployment.DeploymentContextImpl;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.server.ProgressTracker;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.grizzly.tcp.Adapter;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationLifecycle {
    @Inject
    protected Sniffer[] sniffers;
    @Inject
    protected ArchiveHandler[] archiveHandlers;
    @Inject
    protected Habitat habitat;
    @Inject
    protected ContainerRegistry containerRegistry;
    @Inject
    protected ApplicationRegistry appRegistry;
    @Inject
    protected ModulesRegistry modulesRegistry;
    @Inject
    GrizzlyService adapter;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Applications applications;
    @Inject
    Server server;
    protected Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.deployment");

    protected <T extends Container, U extends ApplicationContainer> Deployer<T, U> getDeployer(ContainerInfo<T, U> containerInfo) {
        return containerInfo.getDeployer();
    }

    public Sniffer getSniffer(String appType) {
        assert (appType != null);
        for (Sniffer sniffer : this.sniffers) {
            if (!appType.equalsIgnoreCase(sniffer.getModuleType())) continue;
            return sniffer;
        }
        return null;
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive) {
        for (ArchiveHandler handler : this.archiveHandlers) {
            if (!handler.handles(archive)) continue;
            return handler;
        }
        return null;
    }

    protected ClassLoader createApplicationParentCL(ClassLoader parent, ReadableArchive source, Collection<Deployer> deployers) throws ResolveError {
        String importedBundles;
        Manifest m;
        ArrayList<ModuleDefinition> defs;
        block5: {
            defs = new ArrayList<ModuleDefinition>();
            for (Deployer deployer : deployers) {
                ModuleDefinition[] moduleDefs;
                MetaData deployMetadata = deployer.getMetaData();
                if (deployMetadata == null || (moduleDefs = deployMetadata.getPublicAPIs()) == null) continue;
                defs.addAll(Arrays.asList(moduleDefs));
            }
            m = null;
            try {
                m = source.getManifest();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Cannot load application's manifest file :", e.getMessage());
                if (!this.logger.isLoggable(Level.FINE)) break block5;
                this.logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (m != null && (importedBundles = m.getMainAttributes().getValue("HK2-Import-Bundles")) != null) {
            for (String token : new Tokenizer(importedBundles, ",")) {
                com.sun.enterprise.module.Module module = this.modulesRegistry.makeModuleFor(token, null);
                if (module == null) continue;
                defs.add(module.getModuleDefinition());
            }
        }
        return this.modulesRegistry.getModulesClassLoader(parent, defs);
    }

    protected ClassLoader createSnifferParentCL(ClassLoader parent, Collection<Sniffer> sniffers) {
        ClassLoaderProxy cl = new ClassLoaderProxy(new URL[0], parent);
        for (Sniffer sniffer : sniffers) {
            cl.addDelegate(sniffer.getClass().getClassLoader());
        }
        return cl;
    }

    public Collection<Sniffer> getSniffers(ReadableArchive archive, ClassLoader cloader) {
        ArrayList<Sniffer> appSniffers = new ArrayList<Sniffer>();
        for (Sniffer sniffer : this.sniffers) {
            if (!sniffer.handles(archive, cloader)) continue;
            appSniffers.add(sniffer);
        }
        return appSniffers;
    }

    public ApplicationInfo deploy(Iterable<Sniffer> sniffers, final DeploymentContextImpl context, ActionReport report) {
        final ApplicationLifecycle myself = this;
        ProgressTracker tracker = new ProgressTracker(){

            public void actOn(Logger logger) {
                myself.stopModules(this.get("started", ModuleInfo.class), logger);
                myself.unload(this.get(ModuleInfo.class), context);
                myself.clean(this.get(Deployer.class), context);
                ApplicationLifecycle.this.stopContainers(this.get(ContainerInfo.class), logger);
            }
        };
        try {
            LinkedList<ContainerInfo> sortedContainerInfos = this.setupContainerInfos(sniffers, context, report, tracker);
            ApplicationInfo appInfo = this.prepare(sortedContainerInfos, context, report, tracker);
            appInfo = this.load(sortedContainerInfos, appInfo, context, report, tracker);
            if (appInfo == null) {
                this.failure(this.logger, "Exception while loading the app", null, report);
                tracker.actOn(this.logger);
            }
            if (Boolean.valueOf(context.getCommandParameters().getProperty("enabled")).booleanValue()) {
                this.startModules(appInfo, context, report, tracker);
            }
            return appInfo;
        }
        catch (Exception e) {
            this.failure(this.logger, "Exception while deploying the app", e, report);
            tracker.actOn(this.logger);
            return null;
        }
    }

    public ApplicationInfo enable(Iterable<Sniffer> sniffers, DeploymentContextImpl context, ActionReport report) {
        final ApplicationLifecycle myself = this;
        String appName = context.getCommandParameters().getProperty("component");
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            ProgressTracker tracker = new ProgressTracker(){

                public void actOn(Logger logger) {
                    myself.stopModules(this.get("started", ModuleInfo.class), logger);
                }
            };
            try {
                return this.startModules(appInfo, context, report, tracker);
            }
            catch (Exception e) {
                this.failure(this.logger, "Exception while enabling the app", e, report);
                tracker.actOn(this.logger);
                return null;
            }
        }
        return this.deploy(sniffers, context, report);
    }

    public void disable(String appName, ActionReport report) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            this.stopModules(Arrays.asList(appInfo.getModuleInfos()), this.logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedList<ContainerInfo> setupContainerInfos(Iterable<Sniffer> sniffers, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        for (Sniffer sniffer : sniffers) {
            if (sniffer.getContainersNames() == null || sniffer.getContainersNames().length == 0) {
                this.failure(this.logger, "no container associated with application of type : " + sniffer.getModuleType(), null, report);
                return null;
            }
            String resourceName = sniffer.getClass().getName().replace(".", "/") + ".class";
            URL resource = sniffer.getClass().getClassLoader().getResource(resourceName);
            if (resource == null) {
                this.failure(this.logger, "cannot find container module from service implementation " + sniffer.getClass(), null, report);
                return null;
            }
            String resourceID = resource.toString();
            String manifest = resourceID.substring(0, resourceID.length() - resourceName.length()) + "META-INF/MANIFEST.MF";
            Manifest m = null;
            InputStream is = null;
            try {
                URL manifestURL = new URL(manifest);
                is = manifestURL.openStream();
                if (is != null) {
                    m = new Manifest(is);
                }
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        this.logger.finer("cannot close manifest file input stream");
                    }
                }
            }
            com.sun.enterprise.module.Module snifferModule = null;
            if (m != null) {
                String bundleName = m.getMainAttributes().getValue("HK2-Bundle-Name");
                snifferModule = this.modulesRegistry.makeModuleFor(bundleName, null);
            }
            if (snifferModule == null) {
                this.failure(this.logger, "cannot find container module from service implementation " + sniffer.getClass(), null, report);
                return null;
            }
            ContainerInfo containerInfo = this.containerRegistry.getContainer(sniffer.getContainersNames()[0]);
            if (containerInfo != null) continue;
            Collection<ContainerInfo> containersInfo = this.setupContainer(sniffer, snifferModule, this.logger, report);
            if (containersInfo == null || containersInfo.size() == 0) {
                String msg = "Cannot start container(s) associated to application of type : " + sniffer.getModuleType();
                this.failure(this.logger, msg, null, report);
                throw new Exception(msg);
            }
            tracker.addAll(ContainerInfo.class, containersInfo);
        }
        if (!this.startContainers(tracker.get(ContainerInfo.class), this.logger, report)) {
            String msg = "Failed to start containers";
            this.failure(this.logger, msg, null, report);
            throw new Exception(msg);
        }
        LinkedList<ContainerInfo> sortedContainerInfos = new LinkedList<ContainerInfo>();
        HashMap metaDataProvided = new HashMap();
        HashMap metaDataRequired = new HashMap();
        HashMap containerInfosByDeployers = new HashMap();
        for (Sniffer sniffer : sniffers) {
            for (String containerName : sniffer.getContainersNames()) {
                ContainerInfo containerInfo = this.containerRegistry.getContainer(containerName);
                ClassLoader original = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(containerInfo.getMainModule().getClassLoader());
                    Deployer deployer = this.getDeployer(containerInfo);
                    containerInfosByDeployers.put(deployer, containerInfo);
                    MetaData metadata = deployer.getMetaData();
                    Class[] requires = metadata.requires();
                    Class[] provides = metadata.provides();
                    if (!(requires != null && requires.length != 0 || provides != null && provides.length != 0)) {
                        sortedContainerInfos.add(containerInfo);
                        continue;
                    }
                    for (Class metadataType : metadata.requires()) {
                        LinkedList requesters = (LinkedList)metaDataRequired.get(metadataType);
                        if (requesters == null) {
                            requesters = new LinkedList();
                            metaDataRequired.put(metadataType, requesters);
                        }
                        requesters.add(deployer);
                    }
                    for (Class metadataType : metadata.provides()) {
                        Deployer currentProvidindDeployer = (Deployer)metaDataProvided.get(metaDataProvided);
                        if (currentProvidindDeployer != null) {
                            this.failure(this.logger, "More than one deployer [" + currentProvidindDeployer + ", " + deployer + "] provide same metadata : " + metadataType, null, report);
                        }
                        metaDataProvided.put(metadataType, deployer);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(original);
                }
            }
        }
        for (Class required : metaDataRequired.keySet()) {
            if (metaDataProvided.containsKey(required)) {
                Deployer provider = (Deployer)metaDataProvided.get(required);
                sortedContainerInfos.addFirst((ContainerInfo)containerInfosByDeployers.get(provider));
                List requesters = (List)metaDataRequired.get(required);
                for (Deployer requester : requesters) {
                    sortedContainerInfos.add((ContainerInfo)containerInfosByDeployers.get(requester));
                }
                continue;
            }
            this.failure(this.logger, "Deployer " + metaDataRequired.get(required) + " requires " + required + " but no other deployer provides it", null, report);
            return null;
        }
        return sortedContainerInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationInfo prepare(LinkedList<ContainerInfo> sortedContainerInfos, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        ArrayList<Deployer> deployers = new ArrayList<Deployer>();
        for (ContainerInfo containerInfo : sortedContainerInfos) {
            Deployer deployer = containerInfo.getDeployer();
            deployers.add(deployer);
        }
        ClassLoader parentCL = this.createApplicationParentCL(null, context.getSource(), deployers);
        ArchiveHandler handler = this.getArchiveHandler(context.getSource());
        context.setClassLoader(handler.getClassLoader(parentCL, context.getSource()));
        boolean atLeastOne = false;
        for (ContainerInfo containerInfo : sortedContainerInfos) {
            Deployer deployer = containerInfo.getDeployer();
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(containerInfo.getContainer().getClass().getClassLoader());
                try {
                    deployer.prepare((DeploymentContext)context);
                    if (deployer.getMetaData().invalidatesClassLoader()) {
                        atLeastOne = true;
                    }
                    ModuleInfo moduleInfo = new ModuleInfo(containerInfo, null);
                    tracker.add(ModuleInfo.class, moduleInfo);
                    tracker.add(Deployer.class, deployer);
                }
                catch (Exception e) {
                    this.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e, report);
                    throw e;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCL);
            }
        }
        if (atLeastOne) {
            context.setClassLoader(handler.getClassLoader(parentCL, context.getSource()));
        }
        String appName = context.getCommandParameters().getProperty("name");
        ApplicationInfo appInfo = new ApplicationInfo(context.getSource(), appName, tracker.get(ModuleInfo.class).toArray(new ModuleInfo[tracker.get(ModuleInfo.class).size()]));
        this.appRegistry.add(appName, appInfo);
        return appInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationInfo load(LinkedList<ContainerInfo> sortedContainerInfos, ApplicationInfo appInfo, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        List<ModuleInfo> moduleInfos = tracker.get(ModuleInfo.class);
        block5: for (ContainerInfo containerInfo : sortedContainerInfos) {
            Deployer deployer = containerInfo.getDeployer();
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(containerInfo.getContainer().getClass().getClassLoader());
                try {
                    ApplicationContainer appCtr = deployer.load(containerInfo.getContainer(), (DeploymentContext)context);
                    if (appCtr == null) {
                        String msg = "Cannot load application in " + containerInfo.getContainer().getName() + " container";
                        this.failure(this.logger, msg, null, report);
                        throw new Exception(msg);
                    }
                    if (moduleInfos.isEmpty()) {
                        ModuleInfo moduleInfo = new ModuleInfo(containerInfo, appCtr);
                        tracker.add(ModuleInfo.class, moduleInfo);
                        continue;
                    }
                    for (ModuleInfo moduleInfo : moduleInfos) {
                        if (!moduleInfo.getContainerInfo().getContainer().getName().equals(containerInfo.getContainer().getName())) continue;
                        moduleInfo.setApplicationContainer(appCtr);
                        continue block5;
                    }
                }
                catch (Exception e) {
                    this.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e, report);
                    throw e;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCL);
            }
        }
        if (appInfo == null) {
            String appName = context.getCommandParameters().getProperty("name");
            appInfo = new ApplicationInfo(context.getSource(), appName, tracker.get(ModuleInfo.class).toArray(new ModuleInfo[tracker.get(ModuleInfo.class).size()]));
        }
        return appInfo;
    }

    public ApplicationInfo startModules(ApplicationInfo appInfo, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        for (ModuleInfo module : appInfo.getModuleInfos()) {
            try {
                module.getApplicationContainer().start();
                tracker.add("started", ModuleInfo.class, module);
                try {
                    org.glassfish.api.container.Adapter appAdapter = (org.glassfish.api.container.Adapter)org.glassfish.api.container.Adapter.class.cast(module.getApplicationContainer());
                    this.adapter.registerEndpoint(appAdapter.getContextRoot(), null, (Adapter)appAdapter, module.getApplicationContainer());
                }
                catch (ClassCastException e) {}
            }
            catch (Exception e) {
                this.failure(this.logger, "Exception while invoking " + module.getApplicationContainer().getClass() + " start method", e, report);
                throw e;
            }
        }
        return appInfo;
    }

    protected void stopModules(Iterable<ModuleInfo> modules, Logger logger) {
        for (ModuleInfo module : modules) {
            try {
                module.getApplicationContainer().stop();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot stop module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
    }

    protected void unload(Iterable<ModuleInfo> modules, DeploymentContext context) {
        for (ModuleInfo module : modules) {
            try {
                module.getContainerInfo().getDeployer().unload(module.getApplicationContainer(), context);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Failed to unload from container type : " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
    }

    protected void clean(Iterable<Deployer> deployers, DeploymentContext context) {
        for (Deployer deployer : deployers) {
            try {
                deployer.clean(context);
            }
            catch (Throwable e) {
                context.getLogger().log(Level.INFO, "Deployer.clean failed for " + deployer, e);
            }
        }
    }

    protected Collection<ContainerInfo> setupContainer(Sniffer sniffer, com.sun.enterprise.module.Module snifferModule, Logger logger, ActionReport report) {
        ContainerStarter starter = new ContainerStarter(this.modulesRegistry, this.habitat, logger);
        Collection<ContainerInfo> containersInfo = starter.startContainer(sniffer, snifferModule);
        if (containersInfo == null || containersInfo.size() == 0) {
            this.failure(logger, "Cannot start container(s) associated to application of type : " + sniffer.getModuleType(), null, report);
            return null;
        }
        return containersInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startContainers(Collection<ContainerInfo> containersInfo, Logger logger, ActionReport report) {
        for (ContainerInfo containerInfo : containersInfo) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Object container;
                Thread.currentThread().setContextClassLoader(containerInfo.getMainModule().getClassLoader());
                try {
                    container = containerInfo.getContainer();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Cannot start container from module " + containerInfo.getMainModule(), e);
                    boolean bl = false;
                    Thread.currentThread().setContextClassLoader(original);
                    return bl;
                }
                Class deployerClass = container.getDeployer();
                try {
                    Deployer deployer = (Deployer)this.habitat.getComponent(deployerClass);
                    containerInfo.setDeployer(deployer);
                }
                catch (ComponentException e) {
                    this.failure(logger, "Cannot instantiate or inject " + deployerClass, e, report);
                    this.stopContainer(logger, containerInfo);
                    boolean bl = false;
                    Thread.currentThread().setContextClassLoader(original);
                    return bl;
                }
                catch (ClassCastException e) {
                    this.stopContainer(logger, containerInfo);
                    this.failure(logger, deployerClass + " does not implement " + " the org.jvnet.glassfish.api.deployment.Deployer interface", e, report);
                    boolean bl = false;
                    Thread.currentThread().setContextClassLoader(original);
                    return bl;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        return true;
    }

    protected void stopContainers(Iterable<ContainerInfo> ctrInfos, Logger logger) {
        for (ContainerInfo ctrInfo : ctrInfos) {
            try {
                this.stopContainer(logger, ctrInfo);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Cannot release container " + ctrInfo.getSniffer().getModuleType(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopContainer(Logger logger, ContainerInfo info) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Inhabitant i;
            Thread.currentThread().setContextClassLoader(info.getContainer().getClass().getClassLoader());
            if (info.getDeployer() != null && (i = this.habitat.getInhabitantByType(info.getDeployer().getClass())) != null) {
                i.release();
            }
            if (info.getContainer() != null && (i = this.habitat.getInhabitantByType(info.getContainer().getClass())) != null) {
                i.release();
            }
            this.containerRegistry.removeContainer(info);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Container " + info.getContainer().getName() + " stopped");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected ApplicationInfo unload(String appName, DeploymentContext context, ActionReport report) {
        ApplicationInfo info = this.appRegistry.get(appName);
        if (info == null) {
            this.failure(context.getLogger(), "Application " + appName + " not registered", null, report);
            return null;
        }
        for (ModuleInfo moduleInfo : info.getModuleInfos()) {
            this.unloadModule(moduleInfo, info, context, report);
            if (moduleInfo.getContainerInfo().getApplications().iterator().hasNext()) continue;
            this.stopContainer(context.getLogger(), moduleInfo.getContainerInfo());
        }
        this.appRegistry.remove(appName);
        return info;
    }

    protected void undeploy(String appName, DeploymentContext context, ActionReport report) {
        ApplicationInfo info = this.unload(appName, context, report);
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            for (ModuleInfo moduleInfo : info.getModuleInfos()) {
                try {
                    moduleInfo.getContainerInfo().getDeployer().clean(context);
                }
                catch (Exception e) {
                    this.failure(context.getLogger(), "Exception while cleaning application artifacts", e, report);
                    return;
                }
            }
        }
    }

    protected void failure(Logger logger, String message, Throwable e, ActionReport report) {
        if (e != null) {
            logger.log(Level.SEVERE, message, e);
            report.setMessage(message + " : " + e.toString());
        } else {
            logger.log(Level.SEVERE, message);
            report.setMessage(message);
        }
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unloadModule(ModuleInfo module, ApplicationInfo info, DeploymentContext context, ActionReport report) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            if (module.getApplicationContainer().getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(module.getApplicationContainer().getClassLoader());
            } else {
                Thread.currentThread().setContextClassLoader(module.getContainerInfo().getContainer().getClass().getClassLoader());
            }
            try {
                org.glassfish.api.container.Adapter appAdapter = (org.glassfish.api.container.Adapter)org.glassfish.api.container.Adapter.class.cast(module.getApplicationContainer());
                this.adapter.unregisterEndpoint(appAdapter.getContextRoot(), module.getApplicationContainer());
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            try {
                if (!module.getApplicationContainer().stop()) {
                    this.logger.severe("Cannot stop application " + info.getName() + " in container " + module.getContainerInfo().getSniffer().getModuleType());
                }
            }
            catch (Exception e) {
                this.failure(context.getLogger(), "Exception while stopping the application", e, report);
                boolean bl = false;
                Thread.currentThread().setContextClassLoader(original);
                return bl;
            }
            Deployer deployer = module.getContainerInfo().getDeployer();
            try {
                deployer.unload(module.getApplicationContainer(), context);
            }
            catch (Exception e) {
                this.failure(context.getLogger(), "Exception while shutting down application container", e, report);
                boolean bl = false;
                Thread.currentThread().setContextClassLoader(original);
                return bl;
            }
            module.getContainerInfo().remove(info);
            boolean bl = true;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected void registerAppInDomainXML(final ApplicationInfo applicationInfo, DeploymentContext context) throws TransactionFailure {
        final Properties moduleProps = context.getProps();
        Boolean commit = (Boolean)ConfigSupport.apply((ConfigCode)new ConfigCode(){

            public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                Application app = (Application)ConfigSupport.createChildOf((Object)((Applications)params[0]), Application.class);
                ApplicationLifecycle.this.applications.getModules().add(app);
                app.setName(moduleProps.getProperty("name"));
                app.setLocation(moduleProps.getProperty("location"));
                app.setObjectType(moduleProps.getProperty("object-type"));
                app.setEnabled(String.valueOf(true));
                if (moduleProps.getProperty("context-root") != null) {
                    app.setContextRoot(moduleProps.getProperty("context-root"));
                }
                if (moduleProps.getProperty("libraries") != null) {
                    app.setContextRoot(moduleProps.getProperty("libraries"));
                }
                app.setDirectoryDeployed(moduleProps.getProperty("directory-deployed"));
                for (ModuleInfo moduleInfo : applicationInfo.getModuleInfos()) {
                    Engine engine = (Engine)ConfigSupport.createChildOf((Object)app, Engine.class);
                    app.getEngine().add(engine);
                    engine.setSniffer(moduleInfo.getContainerInfo().getSniffer().getModuleType());
                }
                for (String string : moduleProps.keySet()) {
                    if (string.equals("name") || string.equals("location") || string.equals("enabled") || string.equals("context-root") || string.equals("libraries") || string.equals("object-type") || string.equals("virtual-servers") || string.equals("directory-deployed")) continue;
                    Property prop = (Property)ConfigSupport.createChildOf((Object)app, Property.class);
                    app.getProperty().add(prop);
                    prop.setName(string);
                    prop.setValue(moduleProps.getProperty(string));
                }
                ApplicationRef appRef = (ApplicationRef)ConfigSupport.createChildOf((Object)((Server)params[1]), ApplicationRef.class);
                ApplicationLifecycle.this.server.getApplicationRef().add(appRef);
                appRef.setRef(moduleProps.getProperty("name"));
                if (moduleProps.getProperty("virtual-servers") != null) {
                    appRef.setVirtualServers(moduleProps.getProperty("virtual-servers"));
                }
                appRef.setEnabled(moduleProps.getProperty("enabled"));
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.applications, this.server});
    }

    protected void unregisterAppFromDomainXML(final String appName) throws TransactionFailure {
        ConfigSupport.apply((ConfigCode)new ConfigCode(){

            public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                for (ApplicationRef appRef : ApplicationLifecycle.this.server.getApplicationRef()) {
                    if (!appRef.getRef().equals(appName)) continue;
                    ((Server)params[1]).getApplicationRef().remove(appRef);
                    break;
                }
                for (Module module : ApplicationLifecycle.this.applications.getModules()) {
                    if (!module.getName().equals(appName)) continue;
                    ((Applications)params[0]).getModules().remove(module);
                    break;
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.applications, this.server});
    }

    protected void setEnableAttributeInDomainXML(String appName, final boolean newEnabledValue) throws Exception {
        ApplicationRef applicationRef = null;
        for (ApplicationRef appRef : this.server.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            applicationRef = appRef;
            if (!appRef.getEnabled().equals(newEnabledValue)) break;
            return;
        }
        if (applicationRef == null) {
            throw new Exception("Application Ref not found for " + appName + " in configuration");
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ApplicationRef>(){

            public Object run(ApplicationRef param) throws PropertyVetoException, TransactionFailure {
                param.setEnabled(String.valueOf(newEnabledValue));
                return null;
            }
        }, applicationRef);
    }

    protected Properties populateDeployParamsFromDomainXML(Application app) {
        Properties deploymentParams = new Properties();
        deploymentParams.setProperty("name", app.getName());
        deploymentParams.setProperty("location", app.getLocation());
        deploymentParams.setProperty("enabled", app.getEnabled());
        if (app.getContextRoot() != null) {
            deploymentParams.setProperty("contextroot", app.getContextRoot());
        }
        deploymentParams.setProperty("directorydeployed", app.getDirectoryDeployed());
        return deploymentParams;
    }

    protected Properties populateDeployPropsFromDomainXML(Application app) {
        Properties deploymentProps = new Properties();
        for (Property prop : app.getProperty()) {
            deploymentProps.put(prop.getName(), prop.getValue());
        }
        deploymentProps.setProperty("object-type", app.getObjectType());
        return deploymentProps;
    }

    protected boolean isRegistered(String appName) {
        for (Module module : this.applications.getModules()) {
            if (!module.getName().equals(appName)) continue;
            return true;
        }
        return false;
    }

    protected void deleteContainerMetaInfo(DeploymentContext context) {
        File generatedXmlRoot = context.getScratchDir("xml");
        FileUtils.whack((File)generatedXmlRoot);
        File generatedEjbRoot = context.getScratchDir("ejb");
        FileUtils.whack((File)generatedEjbRoot);
        File generatedJspRoot = context.getScratchDir("jsp");
        FileUtils.whack((File)generatedJspRoot);
    }
}

