/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Populator;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.v3.server.V3Environment;
import com.sun.enterprise.v3.server.XMLStreamReaderFilter;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.GlassFishDocument;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

@Service
public class DomainXml
implements Populator {
    @Inject
    StartupContext context;
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry registry;
    @Inject
    XMLInputFactory xif;
    private static final String DEFAULT_DOMAINS_DIR_PROPNAME = "AS_DEF_DOMAINS_PATH";
    private static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";
    private File domainRoot;

    public void run(ConfigParser parser) {
        if (this.context == null) {
            System.err.println("Startup context not provided, cannot continue");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Startup class : " + this.getClass().getName());
        }
        this.domainRoot = new File(System.getProperty(INSTANCE_ROOT_PROP_NAME));
        V3Environment env = new V3Environment(this.domainRoot.getPath(), this.context);
        this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(V3Environment.class, (Object)env));
        this.habitat.addComponent("parent-class-loader", (Object)new ExistingSingletonInhabitant(URLClassLoader.class, (Object)this.registry.getParentClassLoader()));
        File domainXml = new File(env.getConfigDirPath(), "domain.xml");
        String instanceName = (String)this.context.getArguments().get("-instancename");
        if (instanceName == null || instanceName.length() <= 0) {
            instanceName = "server";
        }
        this.parseDomainXml(parser, domainXml, instanceName);
    }

    private void parseDomainXml(ConfigParser parser, File domainXml, String serverName) {
        try {
            DomainXmlReader xsr = new DomainXmlReader(domainXml, serverName);
            parser.parse((XMLStreamReader)xsr, (DomDocument)new GlassFishDocument(this.habitat));
            xsr.close();
            if (!xsr.foundConfig) {
                throw new RuntimeException("No <config> seen for name=" + xsr.configName);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to parse " + domainXml, e);
        }
    }

    private class DomainXmlReader
    extends XMLStreamReaderFilter {
        private String configName;
        private final File domainXml;
        private final String serverName;
        private boolean foundConfig;
        private FileInputStream stream;

        public DomainXmlReader(File domainXml2, String serverName) throws XMLStreamException {
            try {
                this.stream = new FileInputStream(domainXml2);
            }
            catch (FileNotFoundException e) {
                throw new XMLStreamException(e);
            }
            this.setParent(DomainXml.this.xif.createXMLStreamReader(domainXml2.toURI().toString(), this.stream));
            this.domainXml = domainXml2;
            this.serverName = serverName;
        }

        public void close() throws XMLStreamException {
            super.close();
            try {
                this.stream.close();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        boolean filterOut() throws XMLStreamException {
            this.checkConfigRef(this.getParent());
            if (this.getLocalName().equals("config")) {
                if (this.configName == null) {
                    this.parse2ndTime();
                    assert (this.configName != null);
                }
                if (this.configName.equals(this.getAttributeValue(null, "name"))) {
                    this.foundConfig = true;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void parse2ndTime() throws XMLStreamException {
            DomainXml.this.logger.info("Forced to parse " + this.domainXml + " twice because we didn't see <server> before <config>");
            try {
                FileInputStream stream = new FileInputStream(this.domainXml);
                XMLStreamReader xsr = DomainXml.this.xif.createXMLStreamReader(this.domainXml.toURI().toString(), stream);
                while (this.configName == null) {
                    switch (xsr.next()) {
                        case 1: {
                            this.checkConfigRef(xsr);
                            break;
                        }
                    }
                }
                xsr.close();
                ((InputStream)stream).close();
                if (this.configName == null) {
                    throw new RuntimeException(this.domainXml + " contains no <server> element that matches " + this.serverName);
                }
            }
            catch (IOException e) {
                throw new XMLStreamException("Failed to parse " + this.domainXml, e);
            }
        }

        private void checkConfigRef(XMLStreamReader xsr) {
            String ln = xsr.getLocalName();
            if (this.configName == null && ln.equals("server") && this.serverName.equals(xsr.getAttributeValue(null, "name"))) {
                this.configName = xsr.getAttributeValue(null, "config-ref");
                if (this.configName == null) {
                    throw new RuntimeException("<server> element is missing @config-ref at " + this.formatLocation(xsr));
                }
            }
        }

        private String formatLocation(XMLStreamReader xsr) {
            return "line " + xsr.getLocation().getLineNumber() + " at " + xsr.getLocation().getSystemId();
        }
    }
}

