/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.util.net.NetUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.internal.api.Init;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class SystemTasks
implements Init,
PostConstruct {
    @Inject
    JavaConfig javaConfig;
    Logger _logger = Logger.getAnonymousLogger();

    public void postConstruct() {
        String hostname;
        block4: {
            System.setProperty("com.sun.aas.javaRoot", System.getProperty("java.home"));
            hostname = "localhost";
            try {
                hostname = NetUtils.getCanonicalHostName();
            }
            catch (Exception ex) {
                if (this._logger == null) break block4;
                this._logger.log(Level.SEVERE, "cannot determine host name, will use localhost exclusively", ex);
            }
        }
        if (this._logger != null) {
            System.setProperty("com.sun.aas.hostName", hostname);
        }
        Pattern p = Pattern.compile("-D([^=]*)=(.*)");
        for (String jvmOption : this.javaConfig.getJvmOptions()) {
            Matcher m = p.matcher(jvmOption);
            if (!m.matches()) continue;
            System.setProperty(m.group(1), TranslatedConfigView.getTranslatedValue((Object)m.group(2)).toString());
            if (!this._logger.isLoggable(Level.FINE)) continue;
            this._logger.fine("Setting " + m.group(1) + " = " + TranslatedConfigView.getTranslatedValue((Object)m.group(2)));
        }
    }
}

