/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttp;
import com.sun.enterprise.v3.services.impl.HttpUtils;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.DefaultProcessorTask;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.tcp.Adapter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextRootMapper {
    private static final String ROOT = "/";
    private GrizzlyEmbeddedHttp grizzlyEmbeddedHttp;
    private Map<String, ContextRootInfo> contextRootInfoMap = new HashMap<String, ContextRootInfo>();
    private Logger logger;

    public ContextRootMapper(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp) {
        this.grizzlyEmbeddedHttp = grizzlyEmbeddedHttp;
        this.logger = GrizzlyEmbeddedHttp.getLogger();
    }

    public void register(String contextRoot, Adapter adapter, ApplicationContainer container, List<ProtocolFilter> contextProtocolFilters) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAPPER(" + this + ") REGISTER contextRoot: " + contextRoot + " adapter: " + adapter + " container: " + container + " contextProtocolFilters: " + contextProtocolFilters);
        }
        this.contextRootInfoMap.put(contextRoot, new ContextRootInfo(adapter, container, contextProtocolFilters));
    }

    public void unregister(String contextRoot) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAPPER (" + this + ") UNREGISTER contextRoot: " + contextRoot);
        }
        this.contextRootInfoMap.remove(contextRoot);
    }

    public boolean map(GlassfishProtocolChain protocolChain, ByteBuffer byteBuffer, List<ProtocolFilter> defaultProtocolFilters, ContextRootInfo fallbackContextRootInfo) throws IOException {
        List<ProtocolFilter> fallbackProtocolFilters;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAP (" + this + ") defaultProtocolFilters: " + defaultProtocolFilters + " fallback: " + fallbackContextRootInfo + " CurrentMapState: " + this.contextRootInfoMap);
            this.logger.fine(ContextRootMapper.dump(byteBuffer));
        }
        String contextRoot = this.parseContextRoot(byteBuffer);
        ContextRootInfo contextRootInfo = this.lookupContextRootInfo(contextRoot);
        Adapter adapter = null;
        if (contextRootInfo != null) {
            adapter = contextRootInfo.getAdapter();
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAP (" + this + ") contextRoot: " + contextRoot + " info: " + contextRootInfo + " adapter: " + adapter);
        }
        if (adapter == null && fallbackContextRootInfo != null) {
            adapter = fallbackContextRootInfo.getAdapter();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Fallback adapter is taken: " + adapter);
            }
        }
        if (adapter == null) {
            return false;
        }
        this.bindAdapter(adapter);
        List<ProtocolFilter> filtersToInject = null;
        if (contextRootInfo != null && contextRootInfo.getContainer() != null) {
            List<ProtocolFilter> contextRootProtocolFilters = contextRootInfo.getProtocolFilters();
            List<ProtocolFilter> list = filtersToInject = contextRootProtocolFilters != null ? contextRootProtocolFilters : defaultProtocolFilters;
            if (filtersToInject != null) {
                protocolChain.setDynamicProtocolFilters(filtersToInject);
            }
        } else if (fallbackContextRootInfo != null && (fallbackProtocolFilters = fallbackContextRootInfo.getProtocolFilters()) != null && !fallbackProtocolFilters.isEmpty()) {
            protocolChain.setDynamicProtocolFilters(fallbackProtocolFilters);
        }
        return true;
    }

    private String parseContextRoot(ByteBuffer byteBuffer) throws IOException {
        return ROOT + HttpUtils.findContextRoot(byteBuffer);
    }

    private Adapter bindAdapter(Adapter adapter) {
        this.bindProcessorTask(adapter);
        return adapter;
    }

    private static final String dump(ByteBuffer byteBuffer) {
        ByteBuffer dd = byteBuffer.duplicate();
        dd.flip();
        int length = dd.limit();
        byte[] dump = new byte[length];
        dd.get(dump, 0, length);
        return new String(dump);
    }

    private void bindProcessorTask(Adapter adapter) {
        HttpWorkerThread workerThread = (HttpWorkerThread)Thread.currentThread();
        DefaultProcessorTask processorTask = (DefaultProcessorTask)workerThread.getProcessorTask();
        if (processorTask == null) {
            try {
                processorTask = (DefaultProcessorTask)this.grizzlyEmbeddedHttp.getProcessorTask();
            }
            catch (ClassCastException ex) {
                this.logger.log(Level.SEVERE, "Invalid ProcessorTask instance", ex);
            }
            workerThread.setProcessorTask((ProcessorTask)processorTask);
        }
        processorTask.setAdapter(adapter);
    }

    private ContextRootInfo lookupContextRootInfo(String contextRoot) {
        ContextRootInfo contextRootInfo = null;
        while (true) {
            int lastIndexOfRoot;
            if ((contextRootInfo = this.contextRootInfoMap.get(contextRoot)) != null) {
                Adapter adapter = contextRootInfo.getAdapter();
                ApplicationContainer container = contextRootInfo.getContainer();
                ClassLoader cl = null;
                if (container != null) {
                    cl = container.getClassLoader();
                }
                try {
                    if (cl == null) {
                        cl = adapter.getClass().getClassLoader();
                    }
                    Thread.currentThread().setContextClassLoader(cl);
                }
                catch (Exception e) {}
                break;
            }
            if (contextRoot.equals(ROOT) || (lastIndexOfRoot = contextRoot.lastIndexOf(ROOT)) == -1) break;
            if ((contextRoot = contextRoot.substring(0, lastIndexOfRoot)).length() != 0) continue;
            contextRoot = ROOT;
        }
        return contextRootInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextRootInfo {
        protected Adapter adapter;
        protected ApplicationContainer container;
        protected List<ProtocolFilter> protocolFilters;

        public ContextRootInfo() {
        }

        public ContextRootInfo(Adapter adapter, ApplicationContainer container, List<ProtocolFilter> protocolFilters) {
            this.adapter = adapter;
            this.container = container;
            this.protocolFilters = protocolFilters;
        }

        public Adapter getAdapter() {
            return this.adapter;
        }

        public void setAdapter(Adapter adapter) {
            this.adapter = adapter;
        }

        public ApplicationContainer getContainer() {
            return this.container;
        }

        public void setContainer(ApplicationContainer container) {
            this.container = container;
        }

        public List<ProtocolFilter> getProtocolFilters() {
            return this.protocolFilters;
        }

        public void setProtocolFilters(List<ProtocolFilter> protocolFilters) {
            this.protocolFilters = protocolFilters;
        }
    }
}

