/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.v3.services.impl.AbstractAdapter;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.VirtualHostMapper;
import com.sun.grizzly.Controller;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyAdapter
extends AbstractAdapter
implements NetworkProxy {
    final SelectorThread selectorThread;
    final Logger logger;
    final HttpListener httpListener;
    private Map<String, Adapter> endpoints = new HashMap<String, Adapter>();
    int portNumber;
    private VirtualHostMapper vsMapper;

    public GrizzlyAdapter(Logger logger, Habitat habitat, HttpListener listener, Controller controller) {
        this.logger = logger;
        this.httpListener = listener;
        Boolean state = Boolean.valueOf(listener.getSecurityEnabled());
        String port = listener.getPort();
        if (port == null) {
            logger.severe("Cannot find port information from domain.xml");
            throw new RuntimeException("Cannot find port information from domain configuration");
        }
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            this.portNumber = 8080;
            logger.severe("Cannot parse port value : " + port + ", using port 8080");
        }
        this.selectorThread = new SelectorThread();
        this.selectorThread.setPort(this.portNumber);
        this.selectorThread.setAlgorithmClassName(StaticStreamAlgorithm.class.getName());
        this.selectorThread.setBufferResponse(false);
    }

    @Override
    public void stop() {
        this.selectorThread.stopEndpoint();
    }

    public String toString() {
        return "Grizzly on port " + this.portNumber;
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        this.vsMapper.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) {
        this.vsMapper.unregisterEndpoint(contextRoot, app);
    }

    public Adapter getEndpoint(String contextRoot) {
        return this.endpoints.get(contextRoot);
    }

    public String getContextRoot() {
        return "/";
    }

    @Override
    public void start() {
        this.selectorThread.setAdapter((Adapter)this.vsMapper);
        Thread thread = new Thread(){

            public void run() {
                try {
                    GrizzlyAdapter.this.selectorThread.initEndpoint();
                    GrizzlyAdapter.this.selectorThread.startEndpoint();
                }
                catch (InstantiationException e) {
                    GrizzlyAdapter.this.logger.log(Level.SEVERE, "Cannot start grizzly selector", e);
                }
                catch (IOException e) {
                    GrizzlyAdapter.this.logger.log(Level.SEVERE, "Cannot start grizzly selector", e);
                }
                catch (RuntimeException e) {
                    GrizzlyAdapter.this.logger.log(Level.INFO, "Exception in grizzly thread", e);
                }
            }
        };
        thread.start();
        this.logger.info("Listening on port " + this.portNumber);
    }

    @Override
    public void setVsMapper(VirtualHostMapper vsMapper) {
        this.vsMapper = vsMapper;
    }

    @Override
    public VirtualHostMapper getVsMapper() {
        return this.vsMapper;
    }
}

