/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttp;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttps;
import com.sun.enterprise.v3.services.impl.GrizzlyServiceListener;
import com.sun.grizzly.Controller;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.http.AsyncFilter;
import com.sun.grizzly.http.AsyncHandler;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrizzlyEmbeddedHttpConfigurator {
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle _rb = logger.getResourceBundle();

    public static void configureEmbeddedHttp(GrizzlyServiceListener grizzlyListener, HttpService httpService, HttpListener httpListener, int port, Controller controller) {
        System.setProperty("product.name", "GlassFish/v3");
        grizzlyListener.setPort(port);
        GrizzlyEmbeddedHttp.setWebAppRootPath((String)(System.getProperty("com.sun.aas.instanceRoot") + "/docroot"));
        boolean isSecure = Boolean.parseBoolean(httpListener.getSecurityEnabled());
        grizzlyListener.initializeEmbeddedHttp(isSecure);
        grizzlyListener.setName("grizzly-v3-" + port);
        GrizzlyEmbeddedHttp grizzlyEmbeddedHttp = grizzlyListener.getEmbeddedHttp();
        if (isSecure) {
            GrizzlyEmbeddedHttpConfigurator.configureSSL(grizzlyEmbeddedHttp, httpService, httpListener);
        }
        GrizzlyEmbeddedHttp.setLogger((Logger)logger);
        GrizzlyEmbeddedHttpConfigurator.configureHttpServiceProperties(grizzlyEmbeddedHttp, httpService);
        GrizzlyEmbeddedHttpConfigurator.configureHttpListenerProperties(grizzlyEmbeddedHttp, httpListener);
        GrizzlyEmbeddedHttpConfigurator.configureKeepAlive(grizzlyEmbeddedHttp, httpService.getKeepAlive());
        GrizzlyEmbeddedHttpConfigurator.configureHttpProtocol(grizzlyEmbeddedHttp, httpService.getHttpProtocol());
        GrizzlyEmbeddedHttpConfigurator.configureRequestProcessing(grizzlyEmbeddedHttp, httpService.getRequestProcessing());
        GrizzlyEmbeddedHttpConfigurator.configureFileCache(grizzlyEmbeddedHttp, httpService.getHttpFileCache());
        String acceptorThreads = httpListener.getAcceptorThreads();
        if (acceptorThreads != null) {
            try {
                int readController = Integer.parseInt(acceptorThreads) - 1;
                if (readController > 0) {
                    grizzlyEmbeddedHttp.setSelectorReadThreadsCount(readController);
                }
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, httpListener.getId(), Integer.toString(grizzlyEmbeddedHttp.getMaxProcessorWorkerThreads())});
            }
        }
        if (Boolean.valueOf(System.getProperty("v3.grizzly.cometSupport", "false")).booleanValue() && !httpListener.getId().equalsIgnoreCase("admin-listener")) {
            GrizzlyEmbeddedHttpConfigurator.configureComet(grizzlyEmbeddedHttp);
        }
    }

    private static boolean configureSSL(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp, HttpService httpService, HttpListener httpListener) {
        String ssl2Ciphers;
        Ssl sslConfig = httpListener.getSsl();
        if (sslConfig == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "HTTP listener on port: " + httpListener.getPort() + " is secured, but SSL configuration is not found!");
            }
            return false;
        }
        GrizzlyEmbeddedHttps grizzlyEmbeddedHttps = (GrizzlyEmbeddedHttps)grizzlyEmbeddedHttp;
        if (Boolean.getBoolean(sslConfig.getClientAuthEnabled())) {
            grizzlyEmbeddedHttps.setNeedClientAuth(true);
        }
        LinkedList<String> tmpSSLArtifactsList = new LinkedList<String>();
        if (Boolean.getBoolean(sslConfig.getSsl2Enabled())) {
            tmpSSLArtifactsList.add("SSLv2");
        }
        if (Boolean.getBoolean(sslConfig.getSsl3Enabled())) {
            tmpSSLArtifactsList.add("SSLv3");
        }
        if (Boolean.getBoolean(sslConfig.getTlsEnabled())) {
            tmpSSLArtifactsList.add("TLSv1");
        }
        if (Boolean.getBoolean(sslConfig.getSsl3Enabled()) || Boolean.getBoolean(sslConfig.getTlsEnabled())) {
            tmpSSLArtifactsList.add("SSLv2Hello");
        }
        if (tmpSSLArtifactsList.isEmpty()) {
            logger.log(Level.WARNING, "pewebcontainer.all_ssl_protocols_disabled", httpListener.getId());
        } else {
            String[] enabledProtocols = new String[tmpSSLArtifactsList.size()];
            tmpSSLArtifactsList.toArray(enabledProtocols);
            grizzlyEmbeddedHttps.setEnabledProtocols(enabledProtocols);
        }
        String certNickname = sslConfig.getCertNickname();
        if (certNickname != null && certNickname.length() > 0) {
            grizzlyEmbeddedHttps.setCertNickname(certNickname);
        }
        tmpSSLArtifactsList.clear();
        String ssl3Ciphers = sslConfig.getSsl3TlsCiphers();
        if (ssl3Ciphers != null && ssl3Ciphers.length() > 0) {
            String[] ssl3CiphersArray;
            for (String cipher : ssl3CiphersArray = ssl3Ciphers.split(",")) {
                tmpSSLArtifactsList.add(cipher.trim());
            }
        }
        if ((ssl2Ciphers = sslConfig.getSsl2Ciphers()) != null && ssl2Ciphers.length() > 0) {
            String[] ssl2CiphersArray;
            for (String cipher : ssl2CiphersArray = ssl2Ciphers.split(",")) {
                tmpSSLArtifactsList.add(cipher.trim());
            }
        }
        if (tmpSSLArtifactsList.isEmpty()) {
            logger.log(Level.WARNING, "pewebcontainer.all_ssl_ciphers_disabled", httpListener.getId());
        } else {
            String[] enabledCiphers = new String[tmpSSLArtifactsList.size()];
            tmpSSLArtifactsList.toArray(enabledCiphers);
            grizzlyEmbeddedHttps.setEnabledCipherSuites(enabledCiphers);
        }
        try {
            grizzlyEmbeddedHttps.initializeSSL();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "SSL support could not be configured!", e);
            return false;
        }
    }

    private static void configureKeepAlive(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp, KeepAlive keepAlive) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        int threadCount = 1;
        if (keepAlive != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(keepAlive.getTimeoutInSeconds());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveTimeout");
                msg = MessageFormat.format(msg, keepAlive.getTimeoutInSeconds(), Integer.toString(timeoutInSeconds));
                logger.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(keepAlive.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveMaxConnections");
                msg = MessageFormat.format(msg, keepAlive.getMaxConnections(), Integer.toString(maxConnections));
                logger.log(Level.WARNING, msg, ex);
            }
            try {
                threadCount = Integer.parseInt(keepAlive.getThreadCount());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveThreadCount");
                msg = MessageFormat.format(msg, keepAlive.getThreadCount(), Integer.toString(threadCount));
                logger.log(Level.WARNING, msg, ex);
            }
        }
        grizzlyEmbeddedHttp.setKeepAliveTimeoutInSeconds(timeoutInSeconds);
        grizzlyEmbeddedHttp.setMaxKeepAliveRequests(maxConnections);
        grizzlyEmbeddedHttp.setKeepAliveThreadCount(threadCount);
    }

    private static void configureHttpProtocol(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp, HttpProtocol httpProtocol) {
        if (httpProtocol == null) {
            return;
        }
        grizzlyEmbeddedHttp.setForcedRequestType(httpProtocol.getForcedType());
        grizzlyEmbeddedHttp.setDefaultResponseType(httpProtocol.getDefaultType());
    }

    private static void configureFileCache(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp, HttpFileCache httpFileCache) {
        if (httpFileCache == null) {
            return;
        }
        grizzlyEmbeddedHttp.setFileCacheIsEnabled(true);
        grizzlyEmbeddedHttp.setLargeFileCacheEnabled(true);
        if (httpFileCache.getMaxAgeInSeconds() != null) {
            grizzlyEmbeddedHttp.setSecondsMaxAge(Integer.parseInt(httpFileCache.getMaxAgeInSeconds()));
        }
        if (httpFileCache.getMaxFilesCount() != null) {
            grizzlyEmbeddedHttp.setMaxCacheEntries(Integer.parseInt(httpFileCache.getMaxFilesCount()));
        }
        if (httpFileCache.getSmallFileSizeLimitInBytes() != null) {
            grizzlyEmbeddedHttp.setMinEntrySize(Integer.parseInt(httpFileCache.getSmallFileSizeLimitInBytes()));
        }
        if (httpFileCache.getMediumFileSizeLimitInBytes() != null) {
            grizzlyEmbeddedHttp.setMaxEntrySize(Integer.parseInt(httpFileCache.getMediumFileSizeLimitInBytes()));
        }
        if (httpFileCache.getMediumFileSpaceInBytes() != null) {
            grizzlyEmbeddedHttp.setMaxLargeCacheSize(Integer.parseInt(httpFileCache.getMediumFileSpaceInBytes()));
        }
        if (httpFileCache.getSmallFileSpaceInBytes() != null) {
            grizzlyEmbeddedHttp.setMaxSmallCacheSize(Integer.parseInt(httpFileCache.getSmallFileSpaceInBytes()));
        }
    }

    protected static void configureRequestProcessing(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp, RequestProcessing rp) {
        if (rp == null) {
            return;
        }
        try {
            grizzlyEmbeddedHttp.setMaxProcessorWorkerThreads(Integer.parseInt(rp.getThreadCount()));
            grizzlyEmbeddedHttp.setMinWorkerThreads(Integer.parseInt(rp.getInitialThreadCount()));
            grizzlyEmbeddedHttp.setThreadsTimeout(Integer.parseInt(rp.getRequestTimeoutInSeconds()));
            grizzlyEmbeddedHttp.setThreadsIncrement(Integer.parseInt(rp.getThreadIncrement()));
            grizzlyEmbeddedHttp.setMaxHttpHeaderSize(Integer.parseInt(rp.getHeaderBufferLengthInBytes()));
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, " Invalid request-processing attribute", ex);
        }
    }

    private static void configureHttpListenerProperties(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp, HttpListener httpListener) {
        for (Property httpListenerProp : httpListener.getProperty()) {
            String propValue;
            String propName = httpListenerProp.getName();
            if (GrizzlyEmbeddedHttpConfigurator.configureHttpListenerProperty(grizzlyEmbeddedHttp, propName, propValue = httpListenerProp.getValue())) continue;
            logger.log(Level.WARNING, "pewebcontainer.invalid_http_listener_property", propName);
        }
    }

    private static boolean configureHttpListenerProperty(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp, String propName, String propValue) throws NumberFormatException {
        if ("bufferSize".equals(propName)) {
            grizzlyEmbeddedHttp.setBufferSize(Integer.parseInt(propValue));
            return true;
        }
        if ("recycle-objects".equals(propName)) {
            grizzlyEmbeddedHttp.setRecycleTasks(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("use-nio-direct-bytebuffer".equals(propName)) {
            grizzlyEmbeddedHttp.setUseByteBufferView(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("maxKeepAliveRequests".equals(propName)) {
            grizzlyEmbeddedHttp.setMaxKeepAliveRequests(Integer.parseInt(propValue));
            return true;
        }
        if ("authPassthroughEnabled".equals(propName)) {
            grizzlyEmbeddedHttp.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("maxPostSize".equals(propName)) {
            grizzlyEmbeddedHttp.setMaxPostSize(Integer.parseInt(propValue));
            return true;
        }
        if ("compression".equals(propName)) {
            grizzlyEmbeddedHttp.setCompression(propValue);
            return true;
        }
        if ("compressableMimeType".equals(propName)) {
            grizzlyEmbeddedHttp.setCompressableMimeTypes(propValue);
            return true;
        }
        if ("noCompressionUserAgents".equals(propName)) {
            grizzlyEmbeddedHttp.setNoCompressionUserAgents(propValue);
            return true;
        }
        if ("compressionMinSize".equals(propName)) {
            grizzlyEmbeddedHttp.setCompressionMinSize(Integer.parseInt(propValue));
            return true;
        }
        if ("restrictedUserAgents".equals(propName)) {
            grizzlyEmbeddedHttp.setRestrictedUserAgents(propValue);
            return true;
        }
        if ("rcmSupport".equals(propName)) {
            grizzlyEmbeddedHttp.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("cometSupport".equals(propName)) {
            GrizzlyEmbeddedHttpConfigurator.configureComet(grizzlyEmbeddedHttp);
            return true;
        }
        if ("connectionUploadTimeout".equals(propName)) {
            grizzlyEmbeddedHttp.setUploadTimeout(Integer.parseInt(propValue));
            return true;
        }
        if ("disableUploadTimeout".equals(propName)) {
            grizzlyEmbeddedHttp.setDisableUploadTimeout(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("proxiedProtocols".equals(propName)) {
            grizzlyEmbeddedHttp.setProperty(propName, propValue);
            return true;
        }
        if ("chunkingDisabled".equals(propName) || "chunking-disabled".equals(propName)) {
            grizzlyEmbeddedHttp.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("crlFile".equals(propName)) {
            grizzlyEmbeddedHttp.setProperty(propName, propValue);
            return true;
        }
        if ("trustAlgorithm".equals(propName)) {
            grizzlyEmbeddedHttp.setProperty(propName, propValue);
            return true;
        }
        if ("trustMaxCertLength".equals(propName)) {
            grizzlyEmbeddedHttp.setProperty(propName, propValue);
            return true;
        }
        return false;
    }

    private static void configureHttpServiceProperties(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp, HttpService httpService) {
        List httpServiceProps = httpService.getProperty();
        if (httpServiceProps != null) {
            for (Property httpServiceProp : httpServiceProps) {
                String propValue;
                String propName = httpServiceProp.getName();
                if (GrizzlyEmbeddedHttpConfigurator.configureHttpListenerProperty(grizzlyEmbeddedHttp, propName, propValue = httpServiceProp.getValue())) continue;
                if ("connectionTimeout".equals(propName)) {
                    grizzlyEmbeddedHttp.setSoTimeout(Integer.parseInt(propValue));
                    continue;
                }
                if ("tcpNoDelay".equals(propName)) {
                    grizzlyEmbeddedHttp.setTcpNoDelay(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("traceEnabled".equals(propName)) {
                    grizzlyEmbeddedHttp.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "pewebcontainer.invalid_http_service_property", httpServiceProp.getName());
            }
        }
    }

    private static final void configureComet(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp) {
        grizzlyEmbeddedHttp.setEnableAsyncExecution(true);
        DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
        asyncHandler.addAsyncFilter((AsyncFilter)new CometAsyncFilter());
        grizzlyEmbeddedHttp.setAsyncHandler((AsyncHandler)asyncHandler);
    }
}

