/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.v3.services.impl.AbstractAdapter;
import com.sun.enterprise.v3.services.impl.VsAdapter;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHostMapper
extends AbstractAdapter
implements Adapter {
    final Logger logger;
    final HttpListener httpListener;
    private Map<String, Adapter> endpoints = new HashMap<String, Adapter>();
    int portNumber;
    Map<String, VsAdapter> vsAdapters = new HashMap<String, VsAdapter>();

    public VirtualHostMapper(Logger logger, HttpListener listener) {
        this.logger = logger;
        this.httpListener = listener;
        Boolean state = Boolean.valueOf(listener.getSecurityEnabled());
        String port = listener.getPort();
        if (port == null) {
            logger.severe("Cannot find port information from domain.xml");
            throw new RuntimeException("Cannot find port information from domain configuration");
        }
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            this.portNumber = 8080;
            logger.severe("Cannot parse port value : " + port + ", using port 8080");
        }
    }

    public void addVirtualServer(VirtualServer vs) {
        this.vsAdapters.put(vs.getId(), new VsAdapter(vs));
    }

    public void service(Request req, Response res) throws Exception {
        VsAdapter adapter;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Received something on " + req.requestURI());
        }
        String serverName = req.serverName().toString();
        for (VsAdapter adapter2 : this.vsAdapters.values()) {
            if (!adapter2.handles(serverName)) continue;
            adapter2.service(req, res);
            return;
        }
        if (this.httpListener.getDefaultVirtualServer() != null && (adapter = this.vsAdapters.get(this.httpListener.getDefaultVirtualServer())) != null) {
            adapter.service(req, res);
            return;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Invalid server name " + serverName + " for request " + req.requestURI().toString());
        }
        VirtualHostMapper.sendError(res, "Glassfish v3 Error : Server name Not Found : " + serverName);
    }

    public void registerEndpoint(String contextRoot, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        StringBuffer buffer = new StringBuffer("Endpoint registered at ").append(contextRoot);
        buffer.append(" on virtual server(s) : ");
        if (vsServers == null) {
            for (VsAdapter adapter : this.vsAdapters.values()) {
                adapter.registerEndpoint(contextRoot, endpointAdapter, container);
                buffer.append(adapter.getVirtualServer().getId()).append(" ");
            }
        } else {
            for (String vsId : vsServers) {
                VsAdapter vsAdapter = this.vsAdapters.get(vsId);
                if (vsAdapter == null) continue;
                vsAdapter.registerEndpoint(contextRoot, endpointAdapter, container);
                buffer.append(vsAdapter.getVirtualServer().getId()).append(" ");
            }
        }
        this.logger.fine(buffer.toString());
    }

    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) {
        for (VsAdapter adapter : this.vsAdapters.values()) {
            adapter.unregisterEndpoint(contextRoot, app);
        }
    }

    public Adapter getEndpoint(String contextRoot) {
        return this.endpoints.get(contextRoot);
    }

    public String getContextRoot() {
        return "/";
    }
}

