/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ContextRootMapper;
import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttp;
import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.DefaultProtocolFilter;
import com.sun.grizzly.http.HtmlHelper;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.portunif.ProtocolHandler;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProtocolHandler
implements ProtocolHandler {
    protected String[][] protocols = new String[][]{{"http"}, {"https"}, {"https", "http"}, {"sip"}, {"sip", "sip_tls"}};
    private Mode mode;
    private GrizzlyEmbeddedHttp grizzlyEmbeddedHttp;
    private volatile List<ProtocolFilter> defaultProtocolFilters;
    private ContextRootMapper.ContextRootInfo fallbackContextRootInfo;
    private Logger logger;

    public WebProtocolHandler(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp) {
        this(Mode.HTTP, grizzlyEmbeddedHttp);
    }

    public WebProtocolHandler(Mode mode, GrizzlyEmbeddedHttp grizzlyEmbeddedHttp) {
        this.mode = mode;
        this.grizzlyEmbeddedHttp = grizzlyEmbeddedHttp;
        this.logger = GrizzlyEmbeddedHttp.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Context context, PUProtocolRequest protocolRequest) throws IOException {
        this.initDefaultHttpArtifactsIfRequired();
        boolean wasMap = this.grizzlyEmbeddedHttp.getContextRootMapper().map((GlassfishProtocolChain)context.getProtocolChain(), protocolRequest.getByteBuffer(), this.defaultProtocolFilters, this.fallbackContextRootInfo);
        if (!wasMap) {
            try {
                ByteBuffer bb = HtmlHelper.getErrorPage((String)"Not Found", (String)"HTTP/1.1 404 Not Found\n");
                OutputWriter.flushChannel((SelectableChannel)protocolRequest.getChannel(), (ByteBuffer)bb);
            }
            catch (IOException ex) {
                this.logger.log(Level.FINE, "Send Error failed", ex);
            }
            finally {
                ((WorkerThread)Thread.currentThread()).getByteBuffer().clear();
            }
            return false;
        }
        protocolRequest.setExecuteFilterChain(true);
        return wasMap;
    }

    public String[] getProtocols() {
        return this.protocols[this.mode.ordinal()];
    }

    public boolean expireKey(SelectionKey key) {
        return true;
    }

    public List<ProtocolFilter> getDefaultProtocolFilters() {
        return this.defaultProtocolFilters;
    }

    public void setDefaultProtocolFilters(List<ProtocolFilter> defaultProtocolFilters) {
        this.defaultProtocolFilters = defaultProtocolFilters;
    }

    public List<ProtocolFilter> getFallbackProtocolFilters() {
        return this.fallbackContextRootInfo.getProtocolFilters();
    }

    public void setFallbackProtocolFilters(List<ProtocolFilter> fallbackProtocolFilters) {
        this.fallbackContextRootInfo.setProtocolFilters(fallbackProtocolFilters);
    }

    public void setFallbackAdapter(Adapter adapter) {
        this.fallbackContextRootInfo.setAdapter(adapter);
    }

    public Adapter getFallbackAdapter() {
        return this.fallbackContextRootInfo.getAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDefaultHttpArtifactsIfRequired() {
        if (this.defaultProtocolFilters == null) {
            WebProtocolHandler webProtocolHandler = this;
            synchronized (webProtocolHandler) {
                if (this.defaultProtocolFilters == null) {
                    this.grizzlyEmbeddedHttp.initAlgorithm();
                    ArrayList<ProtocolFilter> tmpProtocolFilters = new ArrayList<ProtocolFilter>(4);
                    tmpProtocolFilters.addAll(this.grizzlyEmbeddedHttp.getDefaultHttpProtocolFilters());
                    StaticResourcesAdapter adapter = new StaticResourcesAdapter();
                    adapter.setRootFolder(GrizzlyEmbeddedHttp.getWebAppRootPath());
                    this.fallbackContextRootInfo = new ContextRootMapper.ContextRootInfo((Adapter)adapter, null, Collections.singletonList(new DefaultProtocolFilter(StaticStreamAlgorithm.class, this.grizzlyEmbeddedHttp.getPort())));
                    this.defaultProtocolFilters = tmpProtocolFilters;
                }
            }
        }
    }

    public ByteBuffer getByteBuffer() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        HTTP,
        HTTPS,
        HTTP_HTTPS,
        SIP,
        SIP_TLS;

    }
}

