/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.cli.framework.Command;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public abstract class S1ASCommand
extends Command {
    public static final String JMX_PROTOCOL = "jmxmp";
    public static final String TERSE = "terse";
    public static final String INTERACTIVE = "interactive";
    public static final String PASSWORDFILE = "passwordfile";
    public static final String ECHO = "echo";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String SECURE = "secure";
    public static final String MAPPED_PASSWORD = "mappedpassword";
    public static final String OBJECT_NAME = "objectname";
    public static final String ARGUMENTS = "arguments";
    public static final String OPERATION = "operation";
    public static final String PARAMS = "params";
    public static final String PARAM_TYPES = "paramtypes";
    public static final String RETURN_TYPE = "returntype";
    public static final String DISPLAY_TYPE = "displaytype";
    public static final String PROPERTY = "property.";
    public static final String DOMAIN = "domain";
    protected static final String ASADMINPREFS = ".asadminprefs";
    private static final String ASADMINENV = "asadminenv.conf";
    protected static final String ENV_PREFIX = "AS_ADMIN_";
    protected static final String DEFAULT_NOT_DEPRECATED_PASSWORDFILE_OPTIONS = "password|adminpassword|userpassword|masterpassword|aliaspassword|mappedpassword";
    protected String NOT_DEPRECATED_PASSWORDFILE_OPTIONS = "password|adminpassword|userpassword|masterpassword|aliaspassword|mappedpassword";
    protected static final String COMMENT_PREFIX = "#";
    private String userValue = null;
    private boolean warningDisplayed = false;

    public boolean validateOptions() throws CommandValidationException {
        this.setLoggerLevel();
        if (this.getBooleanOption(ECHO)) {
            CLILogger.getInstance().printMessage(this.toString());
        }
        Map options = this.getOptions();
        for (String optionKey : options.keySet()) {
            if (!optionKey.matches(this.NOT_DEPRECATED_PASSWORDFILE_OPTIONS)) continue;
            this.validatePasswordOption(optionKey);
        }
        this.readAsadminEnvFile();
        return true;
    }

    private void validatePasswordOption(String passwordOptionName) throws CommandValidationException {
        if (this.getCLOption(passwordOptionName) != null) {
            throw new CommandValidationException(this.getLocalizedString("PasswordsNotAllowedOnCommandLine", new Object[]{passwordOptionName}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAsadminEnvFile() {
        String cr = System.getProperty("com.sun.aas.configRoot");
        File file = new File(cr, ASADMINENV);
        if (file.exists()) {
            CLILogger.getInstance().printDebugMessage("Reading asadminenv.conf file");
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                Properties prop = new Properties();
                prop.load(is);
                Enumeration<?> en = prop.propertyNames();
                while (en.hasMoreElements()) {
                    String optionName;
                    String entry = (String)en.nextElement();
                    if (!entry.startsWith(ENV_PREFIX) || this.getCLOption(optionName = entry.substring(ENV_PREFIX.length()).toLowerCase()) != null || this.getENVOption(optionName) != null) continue;
                    String optionValue = prop.getProperty(entry);
                    CLILogger.getInstance().printDebugMessage("asadminenv.conf: set the following options: " + optionName + "=" + optionValue);
                    this.setOption(optionName, optionValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CLILogger.getInstance().printDebugMessage(e.getLocalizedMessage());
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ignore) {}
            }
        }
    }

    protected void setLoggerLevel() {
        boolean terse = this.getBooleanOption(TERSE);
        if (terse) {
            CLILogger.getInstance().setOutputLevel(Level.INFO);
        } else {
            CLILogger.getInstance().setOutputLevel(Level.FINE);
        }
    }

    protected String getHost() {
        return this.getOption(HOST);
    }

    protected int getPort() throws CommandValidationException {
        String port = this.getOption(PORT);
        return this.validatePort(port);
    }

    protected String getUser() throws CommandValidationException {
        if (this.getOption(USER) == null && this.userValue == null) {
            this.userValue = this.getUserFromASADMINPASS();
            if (this.userValue != null) {
                return this.userValue;
            }
            this.userValue = this.getValuesFromASADMINPREFS(USER);
            if (this.userValue != null) {
                CLILogger.getInstance().printDebugMessage("user value read from .asadminprefs");
                return this.userValue;
            }
            if (this.getBooleanOption(INTERACTIVE)) {
                try {
                    InputsAndOutputs.getInstance().getUserOutput().print(this.getLocalizedString("AdminUserPrompt"));
                    return InputsAndOutputs.getInstance().getUserInput().getLine();
                }
                catch (IOException ioe) {
                    throw new CommandValidationException(this.getLocalizedString("CannotReadOption", new Object[]{USER}));
                }
            }
        } else {
            if (this.getOption(USER) != null) {
                return this.getOption(USER);
            }
            if (this.userValue != null) {
                return this.userValue;
            }
        }
        throw new CommandValidationException(this.getLocalizedString("OptionIsRequired", new Object[]{USER}));
    }

    protected String getUserFromASADMINPASS() {
        String userValue = null;
        String host = this.getHost();
        if (host == null) {
            return userValue;
        }
        try {
            int port = this.getPort();
        }
        catch (CommandValidationException cve) {
            return userValue;
        }
        return userValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getValuesFromASADMINPREFS(String nameOfValue) {
        String returnVal = null;
        File file = null;
        try {
            file = this.checkForFileExistence(System.getProperty("user.home"), ASADMINPREFS);
        }
        catch (Exception e) {
            CLILogger.getInstance().printDebugMessage(e.getLocalizedMessage());
            return returnVal;
        }
        InputStream is = null;
        String optionValue = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            Properties prop = new Properties();
            prop.load(is);
            Enumeration<?> en = prop.propertyNames();
            while (en.hasMoreElements()) {
                String optionName;
                String entry = (String)en.nextElement();
                if (!entry.startsWith(ENV_PREFIX) || !(optionName = entry.substring(ENV_PREFIX.length()).toLowerCase()).equals(nameOfValue)) continue;
                optionValue = prop.getProperty(entry);
                break;
            }
        }
        catch (Exception e) {
            CLILogger.getInstance().printDebugMessage(e.getLocalizedMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ignore) {}
        }
        return optionValue;
    }

    protected String getPassword() throws CommandValidationException, CommandException {
        return this.getPassword(PASSWORD, "AdminPasswordPrompt", "AdminPasswordConfirmationPrompt", true, true, false, false, null, null, true, false, false, true);
    }

    protected boolean isPasswordValid(String passwd) {
        return passwd.length() >= 8;
    }

    protected String getPassword(String optionName, boolean allowedOnCommandLine, boolean readPrefsFile, boolean readPasswordOptionFromPrefs, boolean readMasterPasswordFile, RepositoryManager mgr, RepositoryConfig config, boolean promptUser, boolean confirm, boolean validate, boolean displayWarning) throws CommandValidationException, CommandException {
        return this.getPassword(optionName, "InteractiveOptionPrompt", "InteractiveOptionConfirmationPrompt", allowedOnCommandLine, readPrefsFile, readPasswordOptionFromPrefs, readMasterPasswordFile, mgr, config, promptUser, confirm, validate, displayWarning);
    }

    protected String getPassword(String optionName, String promptMsg, String confirmationPromptMsg, boolean allowedOnCommandLine, boolean readPrefsFile, boolean readPasswordOptionFromPrefs, boolean readMasterPasswordFile, RepositoryManager mgr, RepositoryConfig config, boolean promptUser, boolean confirm, boolean validate, boolean displayWarning) throws CommandValidationException, CommandException {
        String passwordVal;
        if (this.getOption(PASSWORDFILE) != null) {
            this.loadPasswordFileOptions(optionName);
        }
        if ((passwordVal = this.getOtherOption(optionName)) == null) {
            if (readPrefsFile) {
                if (this.getOption(PORT) != null && this.getHost() != null) {
                    String host = this.getHost();
                    int port = this.getPort();
                }
                if (passwordVal == null && (passwordVal = this.getValuesFromASADMINPREFS(optionName)) != null) {
                    CLILogger.getInstance().printDebugMessage("password value read from .asadminprefs");
                }
            }
            if (passwordVal == null) {
                if (readPrefsFile && readPasswordOptionFromPrefs) {
                    passwordVal = this.getValuesFromASADMINPREFS(PASSWORD);
                }
                if (passwordVal == null) {
                    if (readMasterPasswordFile && mgr != null && config != null) {
                        try {
                            passwordVal = mgr.readMasterPasswordFile(config);
                        }
                        catch (RepositoryException ex) {
                            throw new CommandException(ex);
                        }
                    }
                    if (passwordVal == null && promptUser) {
                        passwordVal = confirm ? this.getInteractiveOptionWithConfirmation(optionName, promptMsg, confirmationPromptMsg, validate) : this.getInteractiveOption(optionName, this.getLocalizedString(promptMsg, new Object[]{optionName}));
                    }
                }
            }
        }
        if (validate && passwordVal != null && !this.isPasswordValid(passwordVal)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{optionName}));
        }
        return passwordVal;
    }

    private String getInteractiveOptionWithConfirmation(String optionName, String promptMsg, String confirmationPromptMsg, boolean validatePassword) throws CommandValidationException {
        String prompt = this.getLocalizedString(promptMsg, new Object[]{optionName});
        String confirmationPrompt = this.getLocalizedString(confirmationPromptMsg, new Object[]{optionName});
        String optionValue = this.getInteractiveOption(optionName, prompt);
        if (validatePassword && !this.isPasswordValid(optionValue)) {
            if (promptMsg.equals("AdminPasswordPrompt")) {
                String adminPassword = this.getLocalizedString("AdminPassword");
                throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{adminPassword}));
            }
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{optionName}));
        }
        String optionValueAgain = this.getInteractiveOption(optionName, confirmationPrompt);
        if (!optionValue.equals(optionValueAgain)) {
            throw new CommandValidationException(this.getLocalizedString("OptionsDoNotMatch", new Object[]{optionName}));
        }
        return optionValue;
    }

    protected String getInteractiveOption(String optionName, String prompt) throws CommandValidationException {
        String optionValue;
        if (this.getBooleanOption(INTERACTIVE)) {
            try {
                InputsAndOutputs.getInstance().getUserOutput().print(prompt);
                InputsAndOutputs.getInstance().getUserOutput().flush();
                optionValue = new CliUtil().getPassword();
            }
            catch (NoClassDefFoundError e) {
                optionValue = this.readInput();
            }
            catch (UnsatisfiedLinkError e) {
                optionValue = this.readInput();
            }
            catch (Exception e) {
                throw new CommandValidationException(e);
            }
        } else {
            throw new CommandValidationException(this.getLocalizedString("OptionIsRequired", new Object[]{optionName}));
        }
        return optionValue;
    }

    protected String readInput() {
        try {
            return InputsAndOutputs.getInstance().getUserInput().getLine();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private void loadPasswordFileOptions(String optionName) throws CommandException {
        String passwordFileName = this.getOption(PASSWORDFILE);
        File file = this.checkForFileExistence(null, passwordFileName);
        boolean displayWarning = false;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            Properties prop = new Properties();
            prop.load(is);
            Enumeration<?> en = prop.propertyNames();
            while (en.hasMoreElements()) {
                String entry = (String)en.nextElement();
                if (!entry.startsWith(ENV_PREFIX)) continue;
                String optionFromFile = entry.substring(ENV_PREFIX.length()).toLowerCase();
                boolean bl = displayWarning = !optionFromFile.matches(this.NOT_DEPRECATED_PASSWORDFILE_OPTIONS) || displayWarning;
                if (!optionFromFile.equalsIgnoreCase(optionName)) continue;
                String optionValue = prop.getProperty(entry);
                this.setOption(optionName, optionValue);
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ignore) {}
        }
        if (displayWarning && !this.warningDisplayed) {
            CLILogger.getInstance().printWarning(this.getLocalizedString("DeprecatedOptionsFromPasswordfile"));
            this.warningDisplayed = true;
        }
    }

    protected File checkForFileExistence(String parent, String fileName) throws CommandException {
        if (fileName == null) {
            return null;
        }
        File file = null;
        file = parent == null ? new File(fileName) : new File(parent, fileName);
        if (!file.canRead()) {
            throw new CommandException(this.getLocalizedString("FileDoesNotExist", new Object[]{fileName}));
        }
        return file;
    }

    protected int validatePort(String port) throws CommandValidationException {
        int portNum = -1;
        try {
            portNum = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            throw new CommandValidationException(this.getLocalizedString("InvalidPortNumber", new Object[]{port}));
        }
        if (portNum < 0 || portNum > 65535) {
            throw new CommandValidationException(this.getLocalizedString("InvalidPortRangeMsg"));
        }
        return portNum;
    }
}

