/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.security.AbstractSecurityContext;
import com.sun.enterprise.security.AppservAccessController;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public final class ClientSecurityContext
extends AbstractSecurityContext {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
    public static final String IIOP_CLIENT_PER_THREAD_FLAG = "com.sun.appserv.iiopclient.perthreadauth";
    private static final boolean isPerThreadAuth = Boolean.getBoolean("com.sun.appserv.iiopclient.perthreadauth");
    private static ThreadLocal localCsc = isPerThreadAuth ? new ThreadLocal() : null;
    private static volatile ClientSecurityContext sharedCsc;

    public ClientSecurityContext(String userName, Subject s) {
        this.initiator = new PrincipalImpl(userName);
        this.subject = s;
    }

    public static ClientSecurityContext init() {
        ClientSecurityContext sc = ClientSecurityContext.getCurrent();
        if (sc == null) {
            sc = ClientSecurityContext.generateDefaultSecurityContext();
        }
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientSecurityContext generateDefaultSecurityContext() {
        String PRINCIPAL_NAME = "auth.default.principal.name";
        String PRINCIPAL_PASS = "auth.default.principal.password";
        String username = "guest";
        String password = "getst123";
        Class<ClientSecurityContext> clazz = ClientSecurityContext.class;
        synchronized (ClientSecurityContext.class) {
            try {
                final Subject subject = new Subject();
                final PasswordCredential pc = new PasswordCredential(username, password, "default");
                AppservAccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        subject.getPrivateCredentials().add(pc);
                        return null;
                    }
                });
                ClientSecurityContext defaultCSC = new ClientSecurityContext(username, subject);
                ClientSecurityContext.setCurrent(defaultCSC);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return defaultCSC;
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "java_security.gen_security_context", e);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
        }
    }

    public static ClientSecurityContext getCurrent() {
        if (isPerThreadAuth) {
            return (ClientSecurityContext)localCsc.get();
        }
        return sharedCsc;
    }

    public static void setCurrent(ClientSecurityContext sc) {
        if (isPerThreadAuth) {
            localCsc.set(sc);
        } else {
            sharedCsc = sc;
        }
    }

    public Principal getCallerPrincipal() {
        return this.initiator;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "ClientSecurityContext[ Initiator: " + this.initiator + "Subject " + this.subject + " ]";
    }

    public static boolean hasEmtpyCredentials(ClientSecurityContext sc) {
        if (sc == null) {
            return true;
        }
        Subject s = sc.getSubject();
        if (s == null) {
            return true;
        }
        return s.getPrincipals().isEmpty();
    }
}

