/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.MaskingClassLoader;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.RepositoryChangeListener;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends com.sun.enterprise.module.bootstrap.Main {
    static final Logger logger = Logger.getAnonymousLogger();
    private static final String DEFAULT_DOMAINS_DIR_PROPNAME = "AS_DEF_DOMAINS_PATH";
    private static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";

    public static void main(String[] args) {
        new Main().run(args);
    }

    @Override
    protected void setParentClassLoader(StartupContext context, ModulesRegistry mr) throws BootException {
        Module parentModule;
        ClassLoader cl = this.getClass().getClassLoader();
        mr.setParentClassLoader(cl);
        Module shared = mr.makeModuleFor("org.glassfish.external:glassfish-jaxb", null);
        if (shared != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (URI location : shared.getModuleDefinition().getLocations()) {
                try {
                    urls.add(location.toURL());
                }
                catch (MalformedURLException e) {
                    throw new BootException("Cannot set up masking class loader", e);
                }
            }
            cl = new MaskingClassLoader(cl, urls.toArray(new URL[urls.size()]), "javax.xml.bind.", "javax.xml.ws.", "com.sun.xml.");
            mr.setParentClassLoader(cl);
        }
        if ((parentModule = mr.makeModuleFor("javax.javaee:javaee", null)) != null) {
            cl = parentModule.getClassLoader();
        }
        this.parseAsEnv(context.getRootDirectory().getParentFile());
        File domainRoot = this.getDomainRoot(context);
        this.verifyDomainRoot(domainRoot);
        Repository lib = mr.getRepository("lib");
        if (lib != null) {
            ArrayList<Repository> libs = new ArrayList<Repository>();
            libs.add(lib);
            File domainlib = new File(domainRoot, "lib");
            if (domainlib.exists()) {
                DirectoryBasedRepository domainLib = new DirectoryBasedRepository("domnainlib", domainlib);
                try {
                    domainLib.initialize();
                    mr.addRepository(domainLib);
                    libs.add(domainLib);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Error while initializing domain lib repository", e);
                }
            }
            cl = this.setupSharedCL(cl, libs);
        }
        mr.setParentClassLoader(cl);
    }

    @Override
    protected void createRepository(File root, File bootstrapJar, Manifest mf, ModulesRegistry mr) throws BootException {
        super.createRepository(root, bootstrapJar, mf, mr);
        Repository repo = mr.getRepository("shared");
        File repoLocation = new File(repo.getLocation());
        for (File file : repoLocation.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            try {
                DirectoryBasedRepository newRepo = new DirectoryBasedRepository(file.getName(), file);
                newRepo.initialize();
                mr.addRepository(newRepo);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cannot initialize repository at " + file.getAbsolutePath(), e);
            }
        }
    }

    private ClassLoader setupSharedCL(ClassLoader parent, List<Repository> sharedRepos) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (Repository repo : sharedRepos) {
            uris.addAll(repo.getJarLocations());
        }
        URL[] urls = new URL[uris.size()];
        int i = 0;
        for (URI uri : uris) {
            try {
                urls[i++] = uri.toURL();
            }
            catch (MalformedURLException e) {
                logger.warning("Error while adding library to shared classpath " + e.getMessage());
            }
        }
        return new ExtensibleClassLoader(urls, parent, sharedRepos);
    }

    private void parseAsEnv(File installRoot) {
        Properties asenvProps = new Properties();
        asenvProps.putAll((Map<?, ?>)System.getProperties());
        asenvProps.put("com.sun.aas.installRoot", installRoot.getPath());
        File configDir = new File(installRoot, "config");
        File asenv = this.getAsEnvConf(configDir);
        BufferedReader lnReader = null;
        try {
            lnReader = new LineNumberReader(new FileReader(asenv));
            String line = ((LineNumberReader)lnReader).readLine();
            Pattern p = Pattern.compile("[Ss]?[Ee]?[Tt]? *([^=]*)=\"?([^\"]*)\"?");
            while (line != null) {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    File f = new File(m.group(2));
                    if (!f.isAbsolute()) {
                        f = new File(configDir, m.group(2));
                        if (f.exists()) {
                            asenvProps.put(m.group(1), f.getAbsolutePath());
                        } else {
                            asenvProps.put(m.group(1), m.group(2));
                        }
                    } else {
                        asenvProps.put(m.group(1), m.group(2));
                    }
                }
                line = ((LineNumberReader)lnReader).readLine();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error opening asenv.conf : ", ioe);
        }
        finally {
            try {
                if (lnReader != null) {
                    lnReader.close();
                }
            }
            catch (IOException ioe) {}
        }
        System.setProperties(asenvProps);
    }

    private File getAsEnvConf(File configDir) {
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows") == -1) {
            return new File(configDir, "asenv.conf");
        }
        return new File(configDir, "asenv.bat");
    }

    private File getDomainRoot(StartupContext context) {
        Map<String, String> args = context.getArguments();
        String domainDir = this.getParam(args, "domaindir");
        if (this.ok(domainDir)) {
            return new File(domainDir);
        }
        File defDomainsRoot = this.getDefaultDomainsDir();
        String domainName = this.getParam(args, "domain");
        if (this.ok(domainName)) {
            return new File(defDomainsRoot, domainName);
        }
        return this.getDefaultDomain(defDomainsRoot);
    }

    private void verifyDomainRoot(File domainRoot) {
        String msg = null;
        if (domainRoot == null) {
            msg = "Internal Error: The domain dir is null.";
        } else if (!domainRoot.isDirectory()) {
            msg = "the domain directory is not a directory.";
        } else if (!domainRoot.canWrite()) {
            msg = "the domain directory is not writable.";
        } else if (!new File(domainRoot, "config").isDirectory()) {
            msg = "the domain directory is corrupt - there is no config subdirectory.";
        }
        if (msg != null) {
            throw new RuntimeException(msg);
        }
        domainRoot = this.absolutize(domainRoot);
        System.setProperty(INSTANCE_ROOT_PROP_NAME, domainRoot.getPath());
    }

    private File getDefaultDomainsDir() {
        String dirname = System.getProperty(DEFAULT_DOMAINS_DIR_PROPNAME);
        if (!this.ok(dirname)) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH is not set.");
        }
        File domainsDir = this.absolutize(new File(dirname));
        if (!domainsDir.isDirectory()) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH[" + dirname + "]" + " is specifying a file that is NOT a directory.");
        }
        return domainsDir;
    }

    private File getDefaultDomain(File domainsDir) {
        File[] domains = domainsDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (domains == null || domains.length == 0) {
            throw new RuntimeException("no domain directories found under " + domainsDir);
        }
        if (domains.length > 1) {
            throw new RuntimeException("More than one domain found under " + domainsDir + " -- you must specify one domain.");
        }
        return domains[0];
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private String getParam(Map<String, String> map, String name) {
        String val = map.get("-" + name);
        if (val == null) {
            val = map.get("--" + name);
        }
        return val;
    }

    private File absolutize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtensibleClassLoader
    extends URLClassLoader
    implements RepositoryChangeListener {
        public ExtensibleClassLoader(URL[] urls, ClassLoader parent, List<Repository> repos) {
            super(urls, parent);
            for (Repository repo : repos) {
                repo.addListener(this);
            }
        }

        @Override
        public void jarAdded(URI uri) {
            try {
                super.addURL(uri.toURL());
                logger.info("Added " + uri + " to shared classpath, no need to restart appserver");
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "Cannot add new added library to shared classpath", e);
            }
        }

        @Override
        public void jarRemoved(URI uri) {
        }

        @Override
        public void moduleAdded(ModuleDefinition moduleDefinition) {
        }

        @Override
        public void moduleRemoved(ModuleDefinition moduleDefinition) {
        }
    }
}

