/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.annotation.context.AppClientContext;
import com.sun.enterprise.deployment.annotation.context.ServiceReferenceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.annotation.handlers.HandlerChainHandler;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.persistence.Entity;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceRef;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebServiceRefHandler
extends AbstractHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return WebServiceRef.class;
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        Class[] dependencies = new Class[]{Stateless.class, Stateful.class, Entity.class};
        return dependencies;
    }

    protected HandlerProcessingResult processAWsRef(AnnotationInfo annInfo, WebServiceRef annotation) throws AnnotationProcessorException {
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        AnnotatedElement annElem = annInfo.getAnnotatedElement();
        Class<?> annotatedType = null;
        Class declaringClass = null;
        String serviceRefName = annotation.name();
        if (annInfo.getElementType().equals((Object)ElementType.FIELD)) {
            Field annotatedField = (Field)annElem;
            if (annCtx instanceof AppClientContext && !Modifier.isStatic(annotatedField.getModifiers())) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.injectionfieldnotstatic", "Injection fields for application clients must be declared STATIC"), annInfo);
            }
            annotatedType = annotatedField.getType();
            declaringClass = annotatedField.getDeclaringClass();
            if (serviceRefName.equals("")) {
                serviceRefName = declaringClass.getName() + "/" + annotatedField.getName();
            }
        } else if (annInfo.getElementType().equals((Object)ElementType.METHOD)) {
            Method annotatedMethod = (Method)annElem;
            this.validateInjectionMethod(annotatedMethod, annInfo);
            if (annCtx instanceof AppClientContext && !Modifier.isStatic(annotatedMethod.getModifiers())) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.injectionmethodnotstatic", "Injection methods for application clients must be declared STATIC"), annInfo);
            }
            annotatedType = annotatedMethod.getParameterTypes()[0];
            declaringClass = annotatedMethod.getDeclaringClass();
            if (serviceRefName == null || serviceRefName.equals("")) {
                String propertyName = this.getInjectionMethodPropertyName(annotatedMethod, annInfo);
                serviceRefName = declaringClass.getName() + "/" + propertyName;
            }
        } else if (annInfo.getElementType().equals((Object)ElementType.TYPE)) {
            if (serviceRefName == null || serviceRefName.length() == 0) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.nonametypelevel", "TYPE-Level annotation  must specify name member."), annInfo);
            }
            annotatedType = annotation.type();
            if (annotatedType == null || annotatedType == Object.class) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.typenotfound", "TYPE-level annotation symbol must specify type member."), annInfo);
            }
            declaringClass = (Class)annElem;
        } else {
            throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidtype", "annotation not allowed on this element."), annInfo);
        }
        ServiceReferenceContainer[] containers = null;
        ServiceReferenceDescriptor aRef = null;
        if (annCtx instanceof ServiceReferenceContainerContext) {
            containers = ((ServiceReferenceContainerContext)annCtx).getServiceRefContainers();
        }
        if (containers == null || containers.length == 0) {
            annInfo.getProcessingContext().getErrorHandler().warning(new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidannotationforthisclass", "Illegal annotation symbol for this class will be ignored"), annInfo));
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        for (ServiceReferenceContainer container : containers) {
            WebServiceClient wsclientAnn;
            try {
                aRef = container.getServiceReferenceByName(serviceRefName);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (aRef == null) {
                aRef = new ServiceReferenceDescriptor();
                aRef.setName(serviceRefName);
                container.addServiceReferenceDescriptor(aRef);
            }
            if (aRef.getMappedName() == null && annotation.mappedName() != null && annotation.mappedName().length() != 0) {
                aRef.setMappedName(annotation.mappedName());
            }
            aRef.setInjectResourceType("javax.jws.WebServiceRef");
            if (!annInfo.getElementType().equals((Object)ElementType.TYPE)) {
                InjectionTarget target = new InjectionTarget();
                if (annInfo.getElementType().equals((Object)ElementType.FIELD)) {
                    Field annotatedField = (Field)annElem;
                    target.setFieldName(annotatedField.getName());
                    target.setClassName(annotatedField.getDeclaringClass().getName());
                } else if (annInfo.getElementType().equals((Object)ElementType.METHOD)) {
                    Method annotatedMethod = (Method)annElem;
                    target.setMethodName(annotatedMethod.getName());
                    target.setClassName(annotatedMethod.getDeclaringClass().getName());
                }
                aRef.addInjectionTarget(target);
            }
            if (!Object.class.equals((Object)annotation.value())) {
                if (aRef.getServiceInterface() == null) {
                    aRef.setServiceInterface(annotation.value().getName());
                }
                if (aRef.getPortInfoBySEI(annotatedType.getName()) == null) {
                    ServiceRefPortInfo portInfo = new ServiceRefPortInfo();
                    portInfo.setServiceEndpointInterface(annotatedType.getName());
                    aRef.addPortInfo(portInfo);
                }
                if (aRef.getInjectionTargetType() == null) {
                    aRef.setInjectionTargetType(annotatedType.getName());
                }
            }
            if (aRef.getName() == null || aRef.getName().length() == 0) {
                aRef.setName(annotation.name());
            }
            if (aRef.getWsdlFileUri() == null && (annotation.wsdlLocation() == null || annotation.wsdlLocation().length() != 0)) {
                aRef.setWsdlFileUri(annotation.wsdlLocation());
            }
            if ((wsclientAnn = Object.class.equals((Object)annotation.value()) ? annotatedType.getAnnotation(WebServiceClient.class) : annotation.value().getAnnotation(WebServiceClient.class)) == null) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.classnotannotated", "Class must be annotated with a {1} annotation\n symbol : {1}\n location: {0}", new Object[]{annotatedType.toString(), WebServiceClient.class.toString()}));
            }
            if (aRef.getWsdlFileUri() == null) {
                aRef.setWsdlFileUri(wsclientAnn.wsdlLocation());
            }
            if (aRef.getServiceName() == null) {
                aRef.setServiceNamespaceUri(wsclientAnn.targetNamespace());
                aRef.setServiceLocalPart(wsclientAnn.name());
            }
            if (aRef.getServiceInterface() != null) continue;
            aRef.setServiceInterface(annotatedType.getName());
        }
        if (annElem.getAnnotation(HandlerChain.class) == null) {
            return new HandlerChainHandler().processHandlerChainAnnotation(annInfo, annCtx, annotatedType, declaringClass, false);
        }
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo annInfo) throws AnnotationProcessorException {
        WebServiceRef annotation = (WebServiceRef)annInfo.getAnnotation();
        return this.processAWsRef(annInfo, annotation);
    }
}

