/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.web;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.web.ConstraintFieldNode;
import com.sun.enterprise.deployment.node.runtime.web.WebRuntimeNode;
import com.sun.enterprise.deployment.runtime.web.CacheMapping;
import com.sun.enterprise.deployment.runtime.web.ConstraintField;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class CacheMappingNode
extends WebRuntimeNode {
    public CacheMappingNode() {
        this.registerElementHandler(new XMLElement("constraint-field"), ConstraintFieldNode.class, "addNewConstraintField");
    }

    protected Map getDispatchTable() {
        Map dispatchTable = super.getDispatchTable();
        dispatchTable.put("servlet-name", "setServletName");
        dispatchTable.put("url-pattern", "setUrlPattern");
        dispatchTable.put("cache-helper-ref", "setCacheHelperRef");
        dispatchTable.put("timeout", "setTimeout");
        dispatchTable.put("http-method", "addNewHttpMethod");
        dispatchTable.put("dispatcher", "addNewDispatcher");
        return dispatchTable;
    }

    public void startElement(XMLElement element, Attributes attributes) {
        CacheMapping descriptor = (CacheMapping)this.getRuntimeDescriptor();
        if (descriptor == null) {
            throw new RuntimeException("Trying to set values on a null descriptor");
        }
        if (element.getQName().equals("timeout")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("name".equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue("Timeout", "Name", attributes.getValue(i));
                    continue;
                }
                if (!"scope".equals(attributes.getQName(i))) continue;
                int index = 0;
                while (descriptor.getAttributeValue("Timeout", index, "Name") != null) {
                    ++index;
                }
                descriptor.setAttributeValue("Timeout", index - 1, "Scope", attributes.getValue(i));
            }
        } else if (element.getQName().equals("refresh-field")) {
            descriptor.setRefreshField(true);
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("name".equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue("RefreshField", 0, "Name", attributes.getValue(i));
                    continue;
                }
                if (!"scope".equals(attributes.getQName(i))) continue;
                descriptor.setAttributeValue("RefreshField", 0, "Scope", attributes.getValue(i));
            }
        } else if (element.getQName().equals("key-field")) {
            descriptor.addKeyField(true);
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("name".equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue("KeyField", "Name", attributes.getValue(i));
                    continue;
                }
                if (!"scope".equals(attributes.getQName(i))) continue;
                int index = descriptor.sizeKeyField();
                descriptor.setAttributeValue("KeyField", index - 1, "Scope", attributes.getValue(i));
            }
        } else {
            super.startElement(element, attributes);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, CacheMapping descriptor) {
        int i;
        String[] httpMethods;
        String scope;
        Node cacheMapping = super.writeDescriptor(parent, nodeName, descriptor);
        if (descriptor.getServletName() != null) {
            CacheMappingNode.appendTextChild(cacheMapping, "servlet-name", descriptor.getServletName());
        } else {
            CacheMappingNode.appendTextChild(cacheMapping, "url-pattern", descriptor.getUrlPattern());
        }
        CacheMappingNode.appendTextChild(cacheMapping, "cache-helper-ref", (String)descriptor.getValue("CacheHelperRef"));
        String[] dispatchers = descriptor.getDispatcher();
        if (dispatchers != null) {
            for (int i2 = 0; i2 < dispatchers.length; ++i2) {
                CacheMappingNode.appendTextChild(cacheMapping, "dispatcher", dispatchers[i2]);
            }
        }
        Element timeout = (Element)CacheMappingNode.forceAppendTextChild(cacheMapping, "timeout", (String)descriptor.getValue("Timeout"));
        String name = descriptor.getAttributeValue("Timeout", "Name");
        if (name != null) {
            CacheMappingNode.setAttribute(timeout, "name", name);
        }
        if ((scope = descriptor.getAttributeValue("Timeout", "Scope")) != null) {
            CacheMappingNode.setAttribute(timeout, "scope", scope);
        }
        if (descriptor.isRefreshField()) {
            Element refreshField = CacheMappingNode.appendChild(cacheMapping, "refresh-field");
            CacheMappingNode.setAttribute(refreshField, "name", descriptor.getAttributeValue("RefreshField", "Name"));
            CacheMappingNode.setAttribute(refreshField, "scope", descriptor.getAttributeValue("RefreshField", "Scope"));
        }
        if ((httpMethods = descriptor.getHttpMethod()) != null) {
            for (i = 0; i < httpMethods.length; ++i) {
                CacheMappingNode.appendTextChild(cacheMapping, "http-method", httpMethods[i]);
            }
        }
        if (descriptor.sizeKeyField() > 0) {
            for (i = 0; i < descriptor.sizeKeyField(); ++i) {
                if (!descriptor.isKeyField(i)) continue;
                Element keyField = CacheMappingNode.appendChild(cacheMapping, "key-field");
                CacheMappingNode.setAttribute(keyField, "name", descriptor.getAttributeValue("KeyField", i, "Name"));
                CacheMappingNode.setAttribute(keyField, "scope", descriptor.getAttributeValue("KeyField", i, "Scope"));
            }
        }
        if (descriptor.sizeConstraintField() > 0) {
            ConstraintField[] constraintFields = descriptor.getConstraintField();
            ConstraintFieldNode cfn = new ConstraintFieldNode();
            cfn.writeDescriptor(cacheMapping, "constraint-field", constraintFields);
        }
        return cacheMapping;
    }
}

